/*
FUNCTION
	<<atanh>>, <<atanhf>>---inverse hyperbolic tangent 

INDEX
	atanh
INDEX
	atanhf

ANSI_SYNOPSIS
	#include <math.h>
	double atanh(double <[x]>);
	float atanhf(float <[x]>);

TRAD_SYNOPSIS
	#include <math.h>
	double atanh(<[x]>)
	double <[x]>;

	float atanhf(<[x]>)
	float <[x]>;

DESCRIPTION
	<<atanh>> calculates the inverse hyperbolic tangent of <[x]>.

	<<atanhf>> is identical, other than taking and returning
	<<float>> values.

RETURNS
	<<atanh>> and <<atanhf>> return the calculated value.

	If 
	@ifinfo
	|<[x]>|
	@end ifinfo
	@tex
	$|x|$
	@end tex
	is greater than 1, the global <<errno>> is set to <<EDOM>>.

	If 
	@ifinfo
	|<[x]>|
	@end ifinfo
	@tex
	$|x|$
	@end tex
	is 1, the global <<errno>> is set to <<ERANGE>>; the
	result is has the same sign as <[x]>, and magnitude <<HUGE_VAL>> (for
	<<atanh>>) or <<FLT_MAX>> (for <<atanhf>>). 

PORTABILITY
	Neither <<atanh>> nor <<atanhf>> are ANSI C.

QUICKREF
	atanh - pure
	atanhf - pure


*/

#include "mathimpl.h"


#define DOUBLE
#define SNAME "atanh"
#include "atanh.h"

#undef SNAME


#define FLOAT
#define SNAME "atanhf"
#include "atanh.h"

