#include "funcs.h"


TYPE_RET					 
_DEFUN(atanh,(x), 
       TYPE_ARG x)		 
{					 
  TYPE abs_x;				 
  int sign;

  if (!finite(x)) 
  {
    return __matherror(SNAME, x, 0.0, DOMAIN, x);
  }

  if (x < 0) 
  {
    abs_x = -x;
    sign = 1;
  }
  else
  {
    abs_x = x;
    sign = 0;
  }

  if (abs_x > 1.0)
  {
    return __matherror(SNAME, x, 0.0, DOMAIN, infinity());
  }
  if (abs_x == 1.0)
  {
    return __matherror(SNAME, x, 0.0, OVERFLOW, TYPE_MAX);
  }


  abs_x = abs_x / (1.0 - abs_x);		 

  abs_x = 0.5  * log1p(abs_x + abs_x);	 

  return sign ? - abs_x : abs_x;
  
}					 
					
