/*
FUNCTION
<<copysign>>, <<copysignf>>---sign of <[y]>, magnitude of <[x]>

INDEX
	copysign
INDEX
	copysignf

ANSI_SYNOPSIS
	#include <math.h>
	double copysign (double <[x]>, double <[y]>);
	float copysignf (float <[x]>, float <[y]>);

TRAD_SYNOPSIS
	#include <math.h>
	double copysign (<[x]>, <[y]>)
	double <[x]>;
	double <[y]>;

	float copysignf (<[x]>, <[y]>)
	float <[x]>;
	float <[y]>;

DESCRIPTION
<<copysign>> constructs a number with the magnitude (absolute value)
of its first argument, <[x]>, and the sign of its second argument,
<[y]>.

<<copysignf>> does the same thing; the two functions differ only in
the type of their arguments and result.

RETURNS
<<copysign>> returns a <<double>> with the magnitude of
<[x]> and the sign of <[y]>.
<<copysignf>> returns a <<float>> with the magnitude of
<[x]> and the sign of <[y]>.

PORTABILITY
<<copysign>> is not required by either ANSI C or the System V Interface
Definition (Issue 2).

*/

#include "mathimpl.h"

double
_DEFUN(copysign, (x, y), double x _AND double y)
{
  __ieee_double_shape_type a,b;
  b.value = y;  
  a.value = x;
  a.number.sign =b.number.sign;
  return a.value;
}

float
_DEFUN(copysignf, (x, y), float x _AND float y)
{
  __ieee_float_shape_type a,b;
  b.value = y;  
  a.value = x;
  a.number.sign =b.number.sign;
  return a.value;
}
