/*
FUNCTION
       <<fabs>>, <<fabsf>>---absolute value (magnitude)
INDEX
	fabs
INDEX
	fabsf

ANSI_SYNOPSIS
	#include <math.h>
       double fabs(double <[x]>);
       float fabsf(float <[x]>);

TRAD_SYNOPSIS
	#include <math.h>
       double fabs(<[x]>) 
       double <[x]>;

       float fabsf(<[x]>)
       float <[x]>;

DESCRIPTION
<<fabs>> and <<fabsf>> calculate 
@tex
$|x|$, 
@end tex
the absolute value (magnitude) of the argument <[x]>, by direct
manipulation of the bit representation of <[x]>.

RETURNS
The calculated value is returned.  No errors are detected.

PORTABILITY
<<fabs>> is ANSI.
<<fabsf>> is an extension.

*/


#include "mathimpl.h"
double
_DEFUN(fabs,(x),double x)
{
 if (x > 0) return x ;
 return -x;
}


_FLOAT_RET
_DEFUN(fabsf,(x), _FLOAT_ARG x)
{
  if (x > 0) return x ;
  return -x;

}
