/*
FUNCTION
        <<gamma>>, <<gammaf>>---logarithmic gamma function
INDEX
gamma
INDEX
gammaf

ANSI_SYNOPSIS
#include <math.h>
double gamma(double <[x]>);
float gammaf(float <[x]>);

TRAD_SYNOPSIS
#include <math.h>
double gamma(<[x]>)
double <[x]>;

float gammaf(<[x]>)
float <[x]>;

DESCRIPTION
<<gamma>> calculates 
@tex
$ln\bigl(\Gamma(x)\bigr)$, 
@end tex
the natural logarithm of the gamma function of <[x]>.  The gamma function
(<<exp(gamma(<[x]>))>>) is a generalization of factorial, and retains
the property that  
@ifinfo
<<exp(gamma(N))>> is equivalent to <<N*exp(gamma(N-1))>>.
@end ifinfo
@tex
$\Gamma(N)\equiv N\times\Gamma(N-1)$.
@end tex
Accordingly, the results of the gamma function itself grow very
quickly.  <<gamma>> is defined as 
@tex
$ln\bigl(\Gamma(x)\bigr)$ rather than simply $\Gamma(x)$
@end tex
@ifinfo
the natural log of the gamma function, rather than the gamma function
itself, 
@end ifinfo
to extend the useful range of results representable.

<<gammaf>> performs the same calculation as <<gamma>>, but uses and
returns <<float>> values.

RETURNS
Normally, the computed result is returned.  

When <[x]> is not positive, or when the result is too large to be
representable, <<gamma>> returns <<HUGE_VAL>> and <<gammaf>> returns
<<FLT_MAX>>.  In both cases, <<errno>> is set to <<ERANGE>>.

You can modify this error treatment using <<matherr>>.

PORTABILITY
Neither <<gamma>> nor <<gammaf>> is ANSI C.
*/

#include "mathimpl.h"
int signgam;

#define DOUBLE
#define SNAME "gamma"
#include "gamma.h"
#undef SNAME

#define FLOAT
#define SNAME "gammaf"
#include "gamma.h"
