#include "funcs.h"


TYPE_RET
_DEFUN(gamma,(x),
TYPE_ARG x)
{
  static TYPE pnt68 = .6796875;
  static TYPE sqrtpi =  .9189385332046727417803297;

  static TYPE xbig = TYPE_MAX/1000.0;
#ifdef DOUBLE
  static TYPE frtbig = 2.25e76;
#else
  static TYPE frtbig = FLT_MAX;
#endif
  static TYPE d1 = -.5772156649015328605195174;
  static TYPE p1[8] = {
      4.945235359296727046734888,
      201.8112620856775083915565,
      2290.838373831346393026739,
      11319.67205903380828685045,
      28557.24635671635335736389,
      38484.96228443793359990269,
      26377.48787624195437963534,
      7225.813979700288197698961 };
  static TYPE q1[8] = {
      67.48212550303777196073036,
      1113.332393857199323513008,
      7738.757056935398733233834,
      27639.87074403340708898585,
      54993.10206226157329794414,
      61611.22180066002127833352,
      36351.27591501940507276287,
      8785.536302431013170870835 };
  static TYPE d2 = .4227843350984671393993777;
  static TYPE p2[8] = {
      4.974607845568932035012064,
      542.4138599891070494101986,
      15506.93864978364947665077,
      184793.2904445632425417223,
      1088204.76946882876749847,
      3338152.967987029735917223,
      5106661.678927352456275255,
      3074109.054850539556250927 };
  static TYPE q2[8] = { 
      183.0328399370592604055942,
      7765.049321445005871323047,
      133190.3827966074194402448,
      1136705.821321969608938755,
      5267964.117437946917577538,
      13467014.54311101692290052,
      17827365.30353274213975932,
      9533095.591844353613395747 };
  static TYPE d4 = 1.791759469228055000094023;
  static TYPE p4[8] = { 
      14745.02166059939948905062,
      2426813.369486704502836312,
      121475557.4045093227939592,
      2663432449.630976949898078,
      29403789566.34553899906876,
      170266573776.5398868392998,
      492612579337.743088758812,
      560625185622.3951465078242 };
  static TYPE q4[8] = {
      2690.530175870899333379843,
      639388.5654300092398984238,
      41355999.30241388052042842,
      1120872109.61614794137657,
      14886137286.78813811542398,
      101680358627.2438228077304,
      341747634550.7377132798597,
      446315818741.9713286462081 };
  static TYPE c[7] = {
      -.001910444077728,
      8.4171387781295e-4,
      -5.952379913043012e-4,
      7.93650793500350248e-4,
      -.002777777777777681622553,
      .08333333333333333331554247,
      .0057083835261 };

    

    
  static TYPE xden, corr, xnum;
  static int i;
  static TYPE y, xm1, xm2, xm4, res, ysq;

  y = x;
  if (x == 0.0) 
  {
    return __matherror(SNAME, x, 0.0, OVERFLOW, x);
  }
  
  if (y < 0) 
  {
    signgam = -1;
    y = -y;
  }
  else 
  {
    signgam= 1;
  }
  
  if (y > xbig) 
  {
    return __matherror(SNAME,x,0.0,OVERFLOW, TYPE_MAX);
  }
  
  if (y <= 2.22e-16)
  {
    res = -log(y);
  }
  else 
   if (y <= 1.5) {
       if (y < pnt68) 
       {
	 corr = -log(y);
	 xm1 = y;
       }
       else
       {
	 corr = 0.0;
	 xm1 = y - 0.5 - 0.5;
       }
       if (y <= 0.5 || y >= pnt68) 
       {
	 xden = 1.0;
	 xnum = 0.0;
	 for (i = 1; i <= 8; ++i) 
	 {
	   xnum = xnum * xm1 + p1[i - 1];
	   xden = xden * xm1 + q1[i - 1];

	 }
	 res = corr + xm1 * (d1 + xm1 * (xnum / xden));
       } 
       else
       {
	 xm2 = y - 0.5 - 0.5;
	 xden = 1.0;
	 xnum = 0.0;
	 for (i = 1; i <= 8; ++i) {
	     xnum = xnum * xm2 + p2[i - 1];
	     xden = xden * xm2 + q2[i - 1];

	   }
	 res = corr + xm2 * (d2 + xm2 * (xnum / xden));
       }
     } 
   else if (y <= 4.0)
   {
     xm2 = y - 2.0;
     xden = 1.0;
     xnum = 0.0;
     for (i = 1; i <= 8; ++i) {
	 xnum = xnum * xm2 + p2[i - 1];
	 xden = xden * xm2 + q2[i - 1];

       }
     res = xm2 * (d2 + xm2 * (xnum / xden));
   } 
   else if (y <= 12.0) 
   {
     xm4 = y - 4.0;
     xden = -1.0;
     xnum = 0.0;
     for (i = 1; i <= 8; ++i) 
     {
       xnum = xnum * xm4 + p4[i - 1];
       xden = xden * xm4 + q4[i - 1];

     }
     res = d4 + xm4 * (xnum / xden);
   } 
   else 
   {

     res = 0.0;
     if (y <= frtbig) 
     {
       res = c[6];
       ysq = y * y;
       for (i = 1; i <= 6; ++i) 
       {
	 res = res / ysq + c[i - 1];

       }
     }
     res /= y;
     corr = log(y);
     res = res + sqrtpi - 0.5 * corr;
     res += y * (corr - 1.0);
   }
  return res;

} 




