
/*
FUNCTION
	<<hypot>>, <<hypotf>>---distance from origin
INDEX
	hypot
INDEX
	hypotf

ANSI_SYNOPSIS
	#include <math.h>
	double hypot(double <[x]>, double <[y]>);
	float hypotf(float <[x]>, float <[y]>);

TRAD_SYNOPSIS
	double hypot(<[x]>, <[y]>)
	double <[x]>, <[y]>;

	float hypotf(<[x]>, <[y]>)
	float <[x]>, <[y]>;

DESCRIPTION
	<<hypot>> calculates the Euclidean distance
	@tex
	$\sqrt{x^2+y^2}$
	@end tex
	@ifinfo
	<<sqrt(<[x]>*<[x]> + <[y]>*<[y]>)>>
	@end ifinfo
	between the origin (0,0) and a point represented by the
	Cartesian coordinates (<[x]>,<[y]>).  <<hypotf>> differs only
	in the type of its arguments and result.

RETURNS
	Normally, the distance value is returned.  On overflow,
	<<hypot>> returns <<HUGE_VAL>> and <<hypotf>> returns
	<<MAX_FLT>>; both set <<errno>> to <<ERANGE>> when this
	happens.   

	You can change the error treatment with <<matherr>>.

PORTABILITY
	<<hypot>> and <<hypotf>> are not ANSI C.
*/

#include "mathimpl.h"

								       	
#define SNAME "hypot"
#define DOUBLE
#include "hypot.h"

#undef SNAME
#define FLOAT
#define SNAME "hypotf"
#include "hypot.h"

