/*
FUNCTION
	<<infinity>>---IEEE infinity

INDEX
	infinity

ANSI_SYNOPSIS
	#include <math.h>
	double infinity(void);
	float infinityf(void);

TRAD_SYNOPSIS
	#include <math.h>
	double infinity();
	float infinityf();


DESCRIPTION
	<<infinity>> and <<infinityf>> return the special number IEEE
	infinity in double and single precision arithmetic
	respectivly.

QUICKREF
	infinity - pure

*/


#include <ieeefp.h>

double
_DEFUN_VOID(infinity)
{
  __ieee_double_shape_type v;
  
  v.value = 0;
  v.nan.exponent = __IEEE_DBL_NAN_EXP;

  return v.value;

}


float
_DEFUN_VOID(infinityf)
{
  __ieee_float_shape_type v;
  
  v.value = 0;
  v.nan.exponent = __IEEE_FLT_NAN_EXP;

  return v.value;

}



double
_DEFUN_VOID(nan)
{
  __ieee_double_shape_type v;
  
  v.value = 0;
  v.nan.quiet = 1;
  
  v.nan.exponent = __IEEE_DBL_NAN_EXP;

  return v.value;

}


float
_DEFUN_VOID(nanf)
{
  __ieee_float_shape_type v;
  
  v.value = 0;
  v.nan.quiet = 1;
  v.nan.exponent = __IEEE_FLT_NAN_EXP;

  return v.value;

}


/*
  seee eeee eeee ffff ffff ffff ffff .....etc
  0100 0011 0011 0000 0000 0000 0000 0000 0000 0000

*/ 
static __ieee_double_shape_type vd;

double
_DEFUN_VOID(maxpowtwo)
{
  vd.number.exponent = __IEEE_DBL_EXPBIAS + __IEEE_DBL_FRACLEN;
  return vd.value;
}

static __ieee_float_shape_type v;  
float
_DEFUN_VOID(maxpowtwof)
{

  v.number.exponent = __IEEE_FLT_EXPBIAS + __IEEE_FLT_FRACLEN;

  return v.value;

}

