#include "funcs.h"
#define P7	 0.27204790957888846175e-14
#define P6	-0.76429178068910467734e-12
#define P5	 0.16058936490371589114e-9
#define P4	-0.25052106798274584544e-7
#define P3	 0.27557319210152756119e-5
#define P2	-0.19841269841201840457e-3
#define P1	 0.83333333333331650314e-2
#define P0	-0.16666666666666665052e0

static 
TYPE_RET
_DEFUN(SIN_POLY,(a),
       TYPE_ARG a)
{
  TYPE z = a*a;
  TYPE r= ((z*(P0+z*(P1+z*(P2+z*(P3+z*(P4+z*(P5+z*(P6+z*P7)))))))));
  return a+a *r;
}



TYPE_RET
_DEFUN(sin,(x),
TYPE_ARG x)

{
  if (!finite(x))
  {
    return __matherror(SNAME, x, 0.0, DOMAIN, x);
  }
  
  if (x < 0.0) 
  {
    x = M_TWOPI - (fmod (- x, M_TWOPI));
  }
  
  else if (x >= M_PI * 2.0) 
  {
    x = fmod (x, M_TWOPI);
  }
  

  if (x < M_PI_2)
   return SIN_POLY (x);
  else if (x < M_PI) 
  {
    x = M_PI - x;
	  
    return SIN_POLY (x);
  }
	
  else if (x < 3.0 * M_PI_2) 
  {
    x = x - M_PI;
    return (- SIN_POLY (x));
  }
	
  else 
  {
    x = M_TWOPI - x;
	  
    return (- SIN_POLY (x));
  }
	
}




TYPE_RET
_DEFUN(cos, (x), 
       TYPE_ARG x)
{
  if (!finite(x)) 
  {
    return __matherror(COSNAME, x, 0.0, DOMAIN, x);
  }
  
  return sin(x+M_PI_2);
}

