#include "funcs.h"

static TYPE_RET
_DEFUN(TANSUB_NAME,(x, y, flag),
       TYPE_ARG x _AND
       TYPE_ARG y _AND
       int flag)
{
  TYPE f, g, xn;
  TYPE xnum, xden;
	
  if (y > YMAX) {
      return __matherror(STAN_NAME, x, y, OVERFLOW, 0.0);
    }
  if (fabs(modf(x*0.63661977236758134308, &xn)) >= 0.5)
   xn += (x < 0.0) ? -1.0 : 1.0;
  f = modf(x, &g);
  f = ((g - xn*(3217.0/2048)) + f) - xn*-4.454455103380768678308e-6;
  if (fabs(f) < 2.33e-10) {
      xnum = f;
      xden = 1.0;
    } else {
	g = f*f;
	xnum = P(f,g);
	xden = Q(g);
      }
  flag |= ((int)xn & 1);
  switch (flag) {
    case 1:			/* A: TAN_NAME, xn odd */
      xnum = -xnum;
    case 2:			/* B: COTAN_NAME, xn even */
      return xden/xnum;
		
    case 3:			/* C: COTAN_NAME, xn odd */
      xnum = -xnum;
    case 0:			/* D: TAN_NAME, xn even */
      return xnum/xden;
    }
  return 0.0;
}



TYPE_RET
_DEFUN(cotan,(x),
TYPE_ARG x)
{
  TYPE y;

	
  y = fabs(x);
  if (y < TYPE_MIN)
  {
      return __matherror(SCOTAN_NAME, x, 0.0, OVERFLOW, TYPE_MAX);
    }
  return TANSUB_NAME(x,y,2);
}

TYPE_RET
_DEFUN(tan,(x),
       TYPE_ARG x)
{
  return TANSUB_NAME(x, fabs(x), 0);
}
