
/*

FUNCTION
        <<tanh>>, <<tanhf>>---hyperbolic tangent

INDEX
tanh
INDEX
tanhf

ANSI_SYNOPSIS
        #include <math.h>
        double tanh(double <[x]>);
        float tanhf(float <[x]>);

TRAD_SYNOPSIS
        #include <math.h>
        double tanh(<[x]>)
        double <[x]>;

        float tanhf(<[x]>)
        float <[x]>;


DESCRIPTION

<<tanh>> computes the hyperbolic tangent of
the argument <[x]>.  Angles are specified in radians.  

<<tanh(<[x]>)>> is defined as 
. sinh(<[x]>)/cosh(<[x]>)
	
<<tanhf>> is identical, save that it takes and returns <<float>> values.

RETURNS
The hyperbolic tangent of <[x]> is returned.

If <[x]> is NaN (not a number), <<errno>> is set to <<EDOM>>.

You can modify error handling for these functions using <<matherr>>.

PORTABILITY
<<tanh>> is ANSI C.  <<tanhf>> is an extension.

*/


#include "mathimpl.h"



#define DOUBLE
#define SNAME "tanh"
#include "tanh.h"
#undef SNAME
#define SNAME "tanhf"
#define FLOAT
#include "tanh.h"

