.TH sted 1 "24 May 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
sted \- simple text editor demo program
.SH SYNOPSIS
\fBsted\fP \fIfilename\fP ...
.SH DESCRIPTION
\fISted\fP is a simple text editor that illustrates the use of the
TextEditor and TextBuffer classes.  Multiple files can be edited in
separate windows.  Initially, windows are opened on each file
specified on the command line.  Sted is not intended to be a complete
editor and cannot save modifications to a file.
.SH EDITING MODEL
Sted implements a small subset of editing commands using an editing
model similar to emacs.  Each window has a single text selection that
is displayed with reversed colors.  If the selection is empty, an
insertion caret is displayed instead.  Characters typed into a window
replace the current contents of the selection.
.PP
Currently defined commands include
.TP
.B "quit"
Close all windows and exit
.TP
.B "close"
Close this window
.TP
.B "visit <filename>"
Open a new window on \fIfilename\fP
.TP
.B "file <filename>"
Edit \fIfilename\fP in the current window
.TP
.B "search <regexp>"
Search forward for a match with the regular expression \fIregexp\fP,
wrapping from the end to the beginning of the buffer if necessary.
.TP
.B "goto <line>"
Move the insertion point to the beginning of line \fIline\fP,
scrolling the display if necessary.
.PP
Commands are issued by clicking and typing in the 'minibuffer' at the
bottom of the window.
.SH MOUSE BINDINGS
The left mouse button is used to select text.  Clicking the left
button in the text window selects a new insertion point; dragging the
button selects a range of text.  If the mouse is dragged outside the
window, the display is scrolled to keep the selection point in view.
.PP
The middle and right mouse buttons illustrate different ways of
scrolling with the mouse.  Of course, scrolling can also be performed
using the scroller in the normal way.  The middle mouse button does
\'grabber\' scrolling.  Clicking and dragging the middle button causes
the text to move along with the mouse.  This scrolling style is useful
for fine control over small scrolling ranges.  The right mouse button
does 'rate' scrolling.  Clicking with the right button and 'pulling
back' on the mouse causes the text to scroll upwards at a rate
dependent on the position of the mouse.  'Pushing forward' causes
downwards scrolling.  This style of scrolling is useful for rapidly
scanning through a large document.
.SH KEYBOARD BINDINGS
For convenience, many operations can be performed from the keyboard.
These operations include scrolling, cursor movement, and command
execution.   The current keyboard bindings mimic similar bindings in
standard emacs.
.TP
.B "(ESC-V)"
backward page
.ns
.TP
.B "(^V)"
forward page
.ns
.TP
.B "(^P)"
backward line
.ns
.TP
.B "(^N)"
forward line
.ns
.TP
.B "(^B)"
backward character
.ns
.TP
.B "(^F)"
forward character
.ns
.TP
.B "(ESC-<)"
beginning of buffer
.ns
.TP
.B "(ESC->)"
end of buffer
.ns
.TP
.B "(^A)"
beginning of line
.ns
.TP
.B "(^E)"
end of line
.ns
.TP
.B "(^D)"
delete character
.ns
.TP
.B "(DEL) (^H)"
delete backward character
.ns
.TP
.B "(ESC-=)"
goto
.ns
.TP
.B "(^S)"
search
.ns
.TP
.B "(^X-^V)"
visit
.ns
.TP
.B "(^X-^F)"
file
.ns
.TP
.B "(^X-K)"
close
.ns
.TP
.B "(^X-^C)"
quit
.SH SEE ALSO
TextBuffer(3I), TextEditor(3I), StringEditor(3I), Regexp(3I)
