.TH ChiefDeputy 3I "29 May 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
ChiefDeputy \- buffer communication with remote object space
.SH SYNOPSIS
.B #include <InterViews/chief.h>
.SH DESCRIPTION
A chief deputy mutiplexes communication with a remote object space
across a single connection.
.SH PUBLIC OPERATIONS
.TP
.B "ChiefDeputy(Connection*)"
Construct a chief deputy that sends messages over the given connection.
.TP
.B "ObjectTag Tag()"
The tag for a chief deputy corresponds to the remote object space itself,
whose tag is by convention zero.
.TP
.B "Connection* GetServer()"
Return the connection associated with the remote object space.
.TP
.B "void Alloc(void*& dst, ObjectTag, int op, int len)"
Allocate a message in the buffer.
.TP
.B "int PackString(const char*, void* msg)"
.ns
.TP
.B "int PackString(const char*, int len, void* msg)"
Put a string or substring into a message buffer.
The buffer area is assumed to have already been allocated.
.TP
.B "void Msg(ObjectTag, int op)"
.ns
.TP
.B "void StringMsg(ObjectTag, int op, const char*)"
.ns
.TP
.B "void IntegerMsg(ObjectTag, int op, int val)"
Short-hand for allocating a message and storing fields
in the cases where a message has no parameters, a single string parameter,
or a single integer parameter.
.TP
.B "void Sync()"
Force all messages to be sent to the remote object space.
.TP
.B "int ReadReply(void* reply, int len)"
.ns
.TP
.B "void GetReply(void* reply, int len)"
.ns
.TP
.B "void GetString(const char*& str, int len)"
Read a reply from the object space, first flushing any messages
in the buffer.
ReadReply returns the actual size of the reply from the object space.
GetReply will abort if the size is not the size requested.
GetString will first read the size of a string and then the string itself.
.SH "SEE ALSO"
ChiefDeputy(3i), ObjectSpace(3i)
