.TH Pattern 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Pattern \- fill patterns for a painter
.SH SYNOPSIS
.B #include <InterViews/pattern.h>
.SH DESCRIPTION
A pattern
defines how to fill areas during graphics operations.
The global variables ``solid'' and ``clear'' point to patterns
for filling all or none
of the pixels in a particular area;
``lightgray'', ``gray'', and ``darkgray'' point to patterns
for filling one-eighth, one-half, or seven-eighths
of the pixels in an area respectively.
.SH PUBLIC OPERATIONS
.TP
.B "Pattern(int b[patternHeight])"
Construct a pattern from the array \fIb\fP.
For each element of \fIb\fP,
the least significant
.I patternWidth
bits are used.
If a bit is one, then the foreground color will be used when filling.
Otherwise, the background color will be used.
The first pattern element defines the topmost row of pixels, and the
least significant bit of each element defines the rightmost column.
.TP
.B "Pattern(int i)"
Construct a pattern by interpreting the least signficant 16 bits of \fIi\fP
as a 4x4 bitmap and replicating it to make a full
.I patternWidth
by
.I patternHeight
array.
.TP
.B "Pattern(Bitmap*)"
Construct a pattern from the bitmap.  If necessary, the bitmap will be
tiled or truncated to satisfy window system requirements for fill
pattern sizes.
.SH SEE ALSO
Painter(3I)
