.TH PropertySheet 3I "15 August 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
PropertySheet \- user-customizable attributes
.SH SYNOPSIS
.B #include <InterViews/propsheet.h>
.SH DESCRIPTION
A property sheet is a tree of directories and attributes.
The syntax and semantics of property sheets is the same as
the X Toolkit defines for resources, though the terminology
here is slightly different.
.PP
An attribute is defined by a string name, string value, and optional
string type descriptor.
A property directory contains a list of attributes,
a list of subdirectories, a list of ``default'' attributes, and
a list of ``default'' subdirectories.
Any of the lists can be empty.
InterViews uses a global property sheet called ``properties''
to customize the appearance and behavior of interactive objects.
.SH PUBLIC OPERATIONS
.TP
.B "PropertySheet()"
Construct a property sheet.
The initial sheet contains a single root directory with no attributes.
.TP
.B "~PropertySheet()"
Free all storage associated with the property sheet.
.TP
.B "boolean Load(const char* filename)"
Read a set of attributes from the given file.
Each attribute is defined on a separate line,
with its path from the root fully-qualified.
A ``.'' separates directories, a ``*'' separates a default, and
a ``:'' separate the path from the value.
Thus, ``A.B*C.D:this is a test'' defines an attribute D
with value ``this is a test''.  The path to D starts
at the property sheet root, followed by a subdirectory named A,
a subdirectory named B, and a default subdirectory named C.
.PP
If any of the directories are not present, Load will create them.
If an attribute is already defined, Load will overwrite its value
with the new value.
.TP
.B "void Put(const char* path, const char* value, const char* type = nil)"
Add an attribute to the property sheet explicitly.
.TP
.B "boolean Get(PropertyDef&)"
Find an attribute.
PropertyDef is a structure containing a name,
type descriptor, and value.
To make lookup fast in the cases where the name can be
processed ahead of time,
the name is an index into a StringTable(3I).
The search looks in each directory on the property directory stack
in order.
Get searches the top directory for an attribute and all
other directories for a default attribute.
.TP
.B "boolean GetLocal(PropDir*, PropertyDef&)"
Find an attribute that is local to a particular property directory.
.TP
.B "PropDir* Find(PropertyName)"
Find the property directory that matches the given directory name.
The search looks in each directory on the property directory stack
in order.
If no directory can be found with the given name,
Find returns \fInil\fP.
.TP
.B "void Push(PropDir*, boolean sibling)"
Add a property directory to the stack.
If sibling is true, then Get will search both the top and
next to top stack elements for an attribute.
.TP
.B "void Pop()"
Remove the top of the property directory stack.
.TP
.B "PropDir* Root()"
Return the root directory of the property sheet.
.SH "SEE ALSO"
Interactor(3I), StringTable(3I)
