.TH Rubband 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Rubband \- rubberbanding graphical objects
.SH SYNOPSIS
.B #include <InterViews/rubband.h>
.br
.B #include <InterViews/rubline.h>
.br
.B #include <InterViews/rubrect.h>
.br
.B #include <InterViews/rubcurve.h>
.br
.SH DESCRIPTION
.B Rubband
is the base class for a set of classes that
provide graphical feedback to a user
when performing an interactive operation such as sizing a rectangle.
A rubberband varies in appearance as its ``tracking'' point changes.
A rubberband is NOT an interactor itself, but is used by an interactor.
The rubberband constructors therefore must be passed the painter and canvas
to use for drawing.
.SH PUBLIC OPERATIONS
.TP
.B "RubberLine(Painter*, Canvas*, Coord fx, fy, mx, my, offx = 0, offy = 0)"
A rubber line stretches to follow the tracking point while its other
endpoint stays tied down.
.TP
.B "RubberAxis(Painter*, Canvas*, Coord fx, fy, mx, my, offx = 0, offy = 0)"
A rubber axis stretches either horizontally or vertically to follow
the tracking point while its other endpoint stays tied down.
One endpoint stays fixed while the other moves along either
the horizontal or vertical axis, whichever is closer to the tracking point.
.TP
.B "SlidingLine(Painter*, Canvas*, Coord x0, y0, x1, y1, rfx, rfy, offx = 0, offy = 0)"
A sliding line slides around without changing its length or angle
as the tracking point moves around a reference point.
.TP
.B "RotatingLine(Painter*, Canvas*, Coord x0, y0, x1, y1, rfx, rfy, offx = 0, offy = 0)
A rotating line rotates around (\fIcx\fP,\ \fIcy\fP) based on the angle
between the radius from (\fIcx\fP,\ \fIcy\fP) to (\fIrfx\fP,\ \fIrfy\fP) and
the radius from (\fIcx\fP,\ \fIcy\fP) to the tracking point.
.TP
.B "RubberRect(Painter*, Canvas*, Coord fx, fy, mx, my, offx = 0, offy = 0)"
A rubber rectangle stretches to follow the tacking point while its opposite
corner stays tied down.
.TP
.B "SlidingRect(Painter*, Canvas*, Coord x1, y1, x2, y2, rfx, rfy, offx = 0, offy = 0)"
A sliding rectangle slides around the screen without changing
its side or orientation as the tracking point moves around a reference point.
.TP
.B "ScalingRect(Painter*, Canvas*, Coord x1, y1, x2, y2, cx, cy, offx = 0, offy = 0)"
A scaling rectangle scales equally in both dimensions about
(\fIcx\fP,\ \fIcy\fP) to keep one edge intersecting the tracking point.
.TP
.B "RotatingRect(Painter*, Canvas*, Coord x1, y1, x2, y2, cx, cy, rfx, rfy, offx = 0, offy = 0)"
A rotating rectangle rotates about (\fIcx\fP,\ \fIcy\fP) based
on the radius from (\fIcx\fP,\ \fIcy\fP) to (\fIrfx\fP,\ \fIrfy\fP) and
the radius from (\fIcx\fP,\ \fIcy\fP) to the tracking point.
.TP
.B "StretchingRect(Painter*, Canvas*, Coord x1, y1, x2, y2, Side ts, Coord offx = 0, offy = 0)"
A stretching rectangle's tracking side follows the tracking point while
the opposite side stays fixed.
The \fIside\fP can be one of \fILeftSide\fP, \fIRightSide\fP,
\fIBottomSide\fP, or \fITopSide\fP.
.TP
.B "RubberCircle(Painter*, Canvas*, Coord cx, cy, rx, ry, offx = 0, offy = 0)"
A rubber circle's radius varies with the magnitude of the tracking point's
distance from (\fIcx\fP,\ \fIcy\fP).
.TP
.B "RubberEllipse(Painter*, Canvas*, Coord cx, cy, rx, ry, offx = 0, offy = 0)"
A rubber ellipse's horizontal and vertical radii vary with
the magnitude of the tracking point's distance from (\fIcx\fP,\ \fIcy\fP).
.TP
.B "RubberSpline(Painter*, Canvas*, Coord x[], y[], int n, pt, Coord offx = 0, offy = 0)"
.ns
.TP
.B "RubberClosedSpline(Painter*, Canvas*, Coord x[], y[], int n, pt, Coord offx = 0, offy = 0)"
A rubber spline is the section of a B-spline
defined by \fIn\fP control points that changes shape as
the control point indexed by \fIpt\fP is set to the tracking point.
.TP
.B "RubberHandles(Painter*, Canvas*, Coord x[], y[], int n, pt, size, Coord offx = 0, offy = 0)"
A rubber handles object is a set of filled squares
centered about each point in the list.
The point index by \fIpt\fP follows the tracking point.
.TP
.B "SlidingPointList(Painter*, Canvas*, Coord x[], y[], int n, pt, Coord rfx, rfy, offx = 0, offy = 0)"
A sliding point list slides around the screen without changing
its appearance as the tracking point moves around a reference point.
.TP
.B "SlidingLineList(Painter*, Canvas*, Coord x[], y[], int n, pt, Coord rfx, rfy, offx = 0, offy = 0)"
A sliding line list slides around the screen without changing
the appearance of its connected lines as the tracking point
moves around (\fIrfx\fP,\ \fIrfy\fP).
.TP
.B "virtual void Draw()"
.ns
.TP
.B "void Redraw()"
.ns
.TP
.B "virtual void Erase()"
Explicitly draw, redraw, and erase the rubberband.  Multiple calls to Draw
without an intervening Erase will only draw the rubberband once.  Redraw
forces the rubberband to be drawn.  Since rubberbands are drawn in XOR mode,
Redraw will erase the rubberband every other time it is called.  These
functions are used only on occasion, for example, when part of the screen is
erased while a rubberband is visible.  The Track function is normally used
to draw the rubberband in response to mouse input.
.TP
.B "virtual void Track(Coord x, Coord y)"
Erase the rubberband and redraw it using the new tracking point.
.TP
.B "void GetOriginal(Coord& x1, Coord& y2, Coord& x2, Coord& y2)"
.ns
.TP
.B "void GetCurrent(Coord& x1, Coord& y2, Coord& x2, Coord& y2)"
GetOriginal obtains the original points specified for the rubberband.
GetCurrent obtains the current points based on the most recent call
to Track.
The meaning of the points depends on the kind of rubberband.
For lines, the points are the endpoints;
for rectangles, the points are opposite corners;
for curves, (\fIx1\fP,\ \fIy1\fP) is the center and
\fIx2\fP and \fIy2\fP are the radii.
.TP
.B "virtual void SetPainter(Painter*)"
.ns
.TP
.B "Painter* GetPainter()"
Explicitly set and get the painter used by the rubberband.  
By default, rubberbands use a copy of the painter passed to their constructor.
The user can specify a particular painter to use by passing a nil painter
to the constructor and later calling SetPainter.  \fIN.B.:\fP
the rubberband may alter the painter specified via SetPainter.
.TP
.B "virtual void SetCanvas(Canvas*)"
.ns
.TP
.B "Canvas* GetCanvas()"
Explicitly set and get the canvas used by the rubberband.
.SH SEE ALSO
Canvas(2I), Painter(2I)
