.TH TextEditor 3I "24 May 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
TextEditor \- basic unstructured text editing
.SH SYNOPSIS
.B #include <InterViews/texteditor.h>
.SH DESCRIPTION
A TextEditor is an interactor that provides an interactive interface
for simple text editing of a TextBuffer.  TextEditor uses an editing
model based on a single current selection.  Editing operations operate
on the text in the selection, alter the position or size of the
selection, or scroll the display to view other parts of the text.
TextEditor interprets a perspective for interactive scrolling using a
scroller.
.SH PUBLIC OPERATIONS
.TP
.B "TextEditor(int rows, int cols, int tabsize, int highlight)"
.ns
.TP
.B "~TextEditor()"
Create or destroy an instance of TextEditor.  The natural size of a
TextEditor is specified by \fIrows\fP and \fIcolumns\fP.  The
TextEditor will be tall enough to display \fIrows\fP lines of text in
the current font, and it will be wide enough to display \fIcolumns\fP
characters.  For proportionally-spaced fonts, the width of the
character 'n' is taken to be representative.  Tab characters in the
text are expanded to multiples of \fItabsize\fP character widths.  The
current selection highlighted with the text style \fIhighlight\fP.
.TP
.B "void Edit(TextBuffer*)"
Specify the text buffer to edit.  A text buffer must be specified
before the TextEditor is displayed.
.TP
.B "int Dot()"
.ns
.TP
.B "int Mark()"
The current selection is bounded by two indices into the text buffer.
By convention these indices are called dot and mark.  Dot is the
position at which text will be inserted and deleted.  Mark locates the
end of the selection that moves as the selection is modified.  When
the selection is empty (an insertion point), dot and mark are equal.
.TP
.B "void InsertText(const char* string, int count)"
.ns
.TP
.B "void DeleteText(int count)"
.ns
.TP
.B "void DeleteSelection()"
Edit the text buffer at the current selection.  InsertText inserts
count characters from string after dot.  The selection becomes an
insertion point following the newly inserted text.  DeleteText deletes
count characters at dot.  If count is positive, the characters
following dot are deleted; if count is negative the characters before
dot are deleted.  The selection becomes an insertion point in the
place of the deleted text.  DeleteSelection deletes the text between
dot and mark, changing the selection to an insertion point.
.TP
.B "void BackwardCharacter(int count)"
.ns
.TP
.B "void ForwardCharacter(int count)"
.ns
.TP
.B "void BackwardLine(int count)"
.ns
.TP
.B "void ForwardLine(int count)"
.ns
.TP
.B "void BackwardWord(int count)"
.ns
.TP
.B "void ForwardWord(int count)"
.ns
.TP
.B "void BackwardPage(int count)"
.ns
.TP
.B "void ForwardPage(int count)"
Move the current selection forward or backward by the specified number
of the specified units.  The default movement is one unit.  The
selection is not moved before the beginning of after the end of the
text.
.TP
.B "void BeginningOfLine()"
.ns
.TP
.B "void EndOfLine()"
.ns
.TP
.B "void BeginningOfWord()"
.ns
.TP
.B "void EndOfWord()"
.ns
.TP
.B "void BeginningOfSelection()"
.ns
.TP
.B "void EndOfSelection()"
.ns
.TP
.B "void BeginningOfText()"
.ns
.TP
.B "void EndOfText()"
Move the current selection forwards or backwards to the specified
feature of the text.
.TP
.B "void ScrollToSelection()"
.ns
.TP
.B "void ScrollToView(Coord x, Coord y)"
.ns
.TP
.B "void ScrollBy(Coord dx, Coord dy)"
Scroll the display.  ScrollToSelection scrolls the display so that dot
will be visible.  If dot is currently visible, no scrolling takes
place.  ScrollToView scrolls the display so that the text currently at
the position (\fIx\fP, \fIy\fP) will be visible.  If the specified
point is currently visible, no scrolling takes place.  ScrollBy
specifies an amount by which to scroll the display.  Positive values
scroll the display upwards and to the right.  In each case, the final
position of the display is limited so that some text will be visible.
.TP
.B "void Select(int dot)"
.ns
.TP
.B "void Select(int dot, int mark)"
.ns
.TP
.B "void SelectMore(int mark)"
.ns
.TP
.B "void SelectAll()"
Modify the current selection in terms of text indices.  With a single
parameter, Select moves both dot and mark to the specified index.
With two parameters, dot and mark can be controlled independently.
SelectMore leaves dot unchanged and moves mark.  SelectAll sets dot to
the end of the text and mark to the beginning.
.TP
.B "int Locate(Coord x, Coord y)"
Return the text index most closely matching the point (\fIx\fP,
\fIy\fP).
.SH SEE ALSO
Interactor(2I), TextBuffer(3I)
