.TH Damage 3I "17 January 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
Damage \- manages and repairs damage to graphics
.SH SYNOPSIS
.B #include <InterViews/Graphic/damage.h>
.SH DESCRIPTION
\fBDamage\fP is a class that keeps track of and repairs portions of a 
graphic that have been \fIdamaged\fP, that is, that need to be redrawn.
A graphic is damaged when its (component's) appearance changes.  Damage
objects try to minimize the amount of redraw needed to repair a graphic.
They are most useful when the graphic is complicated enough that
it would be undesirable to redraw the entire canvas when the graphic 
is modified.  Damage objects do \fInot\fP eliminate the need for
an interactor's \fIRedraw\fP member function, though they could
be used to implement it.

.SH PUBLIC OPERATIONS
.TP
.B "Damage(Canvas* = nil, Painter* = nil, Graphic* = nil)"
Create a new Damage object for a graphic 
on the given canvas.  The painter is used to erase damaged areas using
its ClearRect function prior to redrawing them.
.TP
.B "void Incur(Graphic*)"
.ns
.TP
.B "void Incur(BoxObj&)"
.ns
.TP
.B "void Incur(Coord left, Coord bottom, Coord right, Coord top)"
Notify the damage object that a rectangular area has been damaged, either by
passing the graphic that contributed the area or the area itself.
.TP
.B "void Repair()"
Repair all damage incurred since the last Repair (or since the damage object
was created if this is the first Repair).
.TP
.B "void Added(Graphic*)"
Notify the damage object that the given graphic was appended (\fInot\fP
inserted) to the graphic
but never drawn.  The damage object can thus be responsible for drawing
newly added graphics as well.
.TP
.B "void Reset()"
Reset the damage object.  Any damage incurred is lost.
.TP
.B "boolean Incurred()"
Returns true if any damage has been incurred.
.TP
.B "void SetCanvas(Canvas*)"
.ns
.TP
.B "void SetPainter(Painter*)"
.ns
.TP
.B "void SetGraphic(Graphic*)"
.ns
.TP
.B "Canvas* GetCanvas()"
.ns
.TP
.B "Painter* GetPainter()"
.ns
.TP
.B "Graphic* GetGraphic()"
Set and get attributes of the damage object.
.SH SEE ALSO
libgraphic(3I)
