.TH OldTextBuffer 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
OldTextBuffer \- simple text buffer manager
.SH SYNOPSIS
.B #include <InterViews/textbuffer.h>
.SH DESCRIPTION
A text buffer is an interactor that manages a two-dimensional array
of fixed width text.
The dimensions of the array is a function of the space available
in a text buffer's canvas and the size of the font in
a text buffer's output painter.
Text buffers currently do not handle any input events;
they only perform text-based output commands on their canvas.
.SH PUBLIC OPERATIONS
.TP
.B "OldTextBuffer(Sensor*, Painter*)"
.ns
.TP
.B "OldTextBuffer(int rows, int cols, Sensor*, Painter*)"
Create a new text buffer, optionally specifying the size of the
character array.
The shape of a text buffer is infinitely stretchable and shrinkable.
.TP
.B "void GetSize(int& rows, int& cols)"
Get the current size of the text buffer.
.TP
.B "int Row(Coord y)"
.ns
.TP
.B "int Column(Coord x)"
Return the row or column associated with the given coordinate.
.TP
.B "void AddChar(char)"
Add a character to the text buffer at the current position and
advance the position to the next location.
If the position is beyond the last column of the buffer, then
move to the next row.
If the position is beyond the last row of the buffer then
scroll the buffer up one row, discarding the first row.
.TP
.B "void Flush()"
Force any characters that have been added since the last call to Flush
to be written to the screen.
.TP
.B "void BatchedScrolling(boolean)"
Enable ``batched scrolling'', meaning several scroll operations
will be combined into one larger scroll for faster screen update.
.TP
.B "void Blink(boolean)"
.ns
.TP
.B "void Bold(boolean)"
.ns
.TP
.B "void Inverse(boolean)"
.ns
.TP
.B "void Underline(boolean)"
Start or stop making subsequent text blink, boldface,
inverse video, or underlined.
.TP
.B "void CarriageReturn()"
.ns
.TP
.B "void BackSpace()"
.ns
.TP
.B "void Tab()"
Move to the next row, previous column, or start of the next tab position.
.TP
.B "void CheckScroll(const char* buf, int index, int len)"
If batched scrolling is enabled and
adding the characters in \fIbuf\fP will cause any scrolling,
then do all the scrolling at once.
.TP
.B "void ClearScreen()"
Erase the entire screen.
.TP
.B "void ClearLines(int where, int count)"
Erase the text in \fIcount\fP rows down from row \fIwhere\fP.
.TP
.B "void EraseLine()"
Erase the text on the current row.
.TP
.B "void EraseBOL()"
.ns
.TP
.B "void EraseEOL()"
.ns
.TP
.B "void EraseEOS()"
.ns
Erase from the current position to either
the beginning or end of the current row, or to the end of the screen.
.TP
.B "void CursorOn()"
.ns
.TP
.B "void CursorOff()"
.ns
.TP
.B "void OutlineCursor(boolean)"
Turn on or off display of the block cursor at the current position.
The cursor can be either a filled rectangle
(inverting the character at the current position) or an outline.
.TP
.B "void CursorLeft(int n)"
.ns
.TP
.B "void CursorRight(int n)"
.ns
.TP
.B "void CursorUp(int n)"
.ns
.TP
.B "void CursorDown(int n)"
.ns
.TP
.B "void Goto(int row, int col)"
Move the current position.
.TP
.B "void InsertCharacters(int)"
.ns
.TP
.B "void InsertLines(int n)"
Open space in the text buffer for \fIn\fP characters or lines.
.TP
.B "void DeleteCharacters(int n)"
.ns
.TP
.B "void DeleteLines(int n)"
Remove \fIn\fP characters or lines from the buffer, moving
characters to the left or moving lines up to occupy the available space.
.TP
.B "void ScrollUp(int where, int count)"
.ns
.TP
.B "void ScrollDown(int where, int count)"
Move \fIcount\fP lines up or down, discarding lines off the top and
clearing lines at the bottom.
.TP
.B "void SetRegion(int t, int b)"
Set the top and bottom rows of the text buffer that will be affected
by subsequent operations.
.SH "SEE ALSO"
Interactor(2I), Painter(2I)
.SH NOTE
This class is old and clumsy, and is provided only for backward compatibility.
It may disappear in a future distribution.  New applications
should use \fITextViewer\fP(3I).
