/*
 * Replay mode.
 */

#include "log.h"
#include "logger.h"
#include <InterViews/connection.h>
#include <os/timing.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

Replayer::Replayer (const char* s) {
    log->Open(s);
}

/*
 * Sleep for n milliseconds.
 */

static void Wakeup (int) {
    /* nothing else to do */
}

static void MSleep (int n) {
    struct itimerval value, ovalue;

    int sigs = sigblock(1 << SIGALRM);
    SignalHandler f = signal(SIGALRM, Wakeup);
    value.it_interval.tv_sec = 0;
    value.it_interval.tv_usec = 0;
    value.it_value.tv_sec = n/1000;
    value.it_value.tv_usec = (n%1000) * 1000;
    setitimer(ITIMER_REAL, &value, &ovalue);
    sigpause(0);
    signal(SIGALRM, f);
    sigblock(sigs);
}

void Replayer::Run (char**) {
    int delay, dir, n;
    char buf[logbufsize];

    Connection* x = XConnection();
    for (;;) {
	n = log->Read(delay, dir, buf);
	if (n <= 0) {
	    break;
	}
	if (delay != 0) {
	    MSleep(delay);
	}
	if (dir == from_client) {
	    int w = x->Write(buf, n);
	    if (w < n) {
		fprintf(stderr, "only wrote %d bytes\n", w);
		exit(1);
	    }
	} else {
	    /*
	     * The input message could have been generated by the user,
	     * in which case there won't be one pending now.
	     * So just check to see if a message is pending from the X server.
	     */
	    int r = x->Pending();
	    if (r > 0) {
		x->Read(buf, r);
	    } else {
		/* ignore data */
	    }
	}
    }
    printf("Type carriage return to exit: ");
    getchar();
    Quit(0);
}
