/* xtimer.h -- function prototypes and data structures used in xtimer.c. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#ifndef _GIT_XTIMER_H
#define _GIT_XTIMER_H


#include <sys/types.h>

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include "stdc.h"


#define XT_OFF			0
#define XT_ON			1

#define XT_NO			0
#define XT_YES			1

#define XT_SAFE_TO_CALL		1


typedef struct tag_xtimer_t
{
    /* total count of interrupts occured.  */
    int interrupts;

    /* interrupts occured while the hook was safe to call.  */
    int hits;

    /* the timer hook function.  */
    void (* hook) __P((struct tag_xtimer_t *, int));

    /* xtimer flags.  Actually specifying only if the timer hook is safe
       to call.  */
    int flags;
} xtimer_t;


typedef void (* xtimer_function) __P((xtimer_t *, int));


extern void xtimer __P((int));
extern int xtimer_register __P((xtimer_function));
extern void xtimer_set_flags __P((int, int));


#endif /* _GIT_XTIMER_H */
