/* Return the address for a person in the GNATS responsible file.
   Copyright (C) 1993 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>

#include "gnats.h"

/* The name this program was run with.  */
char *program_name;

/* Defined in version.c.  */
extern char *version_string;

void usage (), version ();

void
main (argc, argv)
     int argc;
     char **argv;
{
  Responsible *r;
  char *p;

  program_name = (char *) basename (argv[0]);

  if (argc != 2)
    usage ();

  if (argv[1][0] == '\0')
    {
      fprintf (stderr, "%s: name must be non-null\n", program_name);
      exit (1);
    }


  p = (char *) strchr (argv[1], ' ');
  if (p != (char *) NULL)
    *p = '\0';
  r = get_responsible_address (argv[1]);
  if (r)
    printf ("%s\n", r->alias);
  else
    {
      fprintf (stderr, "%s: could not read the list of responsible people\n",
	       program_name);
      exit (1);
    }
  
  exit (0);
}

void
usage ()
{
  fprintf (stderr, "Usage: %s name\n", program_name);
  exit (1);
}

void
version ()
{
  printf ("pr-addr %s\n", version_string);
}

