/* $Id: gsr.h%v 1.1 1993/08/06 05:15:40 woo Exp woo $ */
/* gsr.h  -- header used with Gnuplot graphics support routines. */
/* $Log: gsr.h%v $
 * Revision 1.1  1993/08/06  05:15:40  woo
 * Initial revision
 *
 * Revision 1.3  1993/06/14  19:22:41  jack
 * Modified for gnuplot 3.4
 *
 * Revision 1.2  1993/05/28  18:51:24  jack
 * Modified for use with RLaB.
 *
 * Revision 1.2  1993/05/22  14:09:45  jack
 * Made GSRxformat and GSRyformat external when RLAB is defined.
 * Allows rlab to handle dynamic allocation for tic foemats.
 *
 */
#ifndef INCgsr
#define INCgsr

/*-
   gnuplot Graphics Support Routines header file.  This file is
   required (needs to be included) by users of the gnuplot Graphics 
   Support library: gsr.c
-*/

/* 
   Defines required by users of the Gnuplot Graphics Support Routines
*/
#include <stdio.h>
#include <math.h>
#ifndef INCgtplot
#include "gtplot.h"
#endif

#ifndef max		/* Lattice C has max() in math.h, but shouldn't! */
#define max(a,b) ((a > b) ? a : b)
#endif

#ifndef min
#define min(a,b) ((a < b) ? a : b)
#endif


/* Gnuplot Graphic Support Routine Globals: */

/* File pointer being used by the term routines. */
#define GSRoutfile GToutfile

#ifdef GSR_OWNER

/* Define the boundary of the plot
 * These are computed at each call to gnu_init(), and are constant over
 * the period of one plot. They must change when the term
 * type changes (requiring a call to gnu_init()).
 */
int GSRxleft, GSRxright, GSRybot, GSRytop;
TBOOLEAN GSRlogx, GSRlogy;

/*
   Value where the yaxis is located (used by IMPULSE lines).
*/
int GSRxaxis_y;

/*
   Value of the point and line types in use (especially for gsr_curve())
*/
int  GSRpoint_type = 0, GSRline_type = 0;

/* Boundary and scale factors, in user coordinates */
double GSRxmin, GSRxmax, GSRymin, GSRymax;
double GSRxscale, GSRyscale;
float GSRxtic, GSRytic;
#ifdef RLAB
extern char *GSRxformat , *GSRyformat ;
#else
char *GSRxformat = "%g", *GSRyformat = "%g";
#endif  /*  RLAB  */
#else

/*-
   Gnuplot Graphics Support Routine externals (available while using package):

   GSRxleft, GSRxright -- location of left, right, top, and bottom sides 
   GSRybot, GSRytop       of the plot border in terminal units.

   GSRlogx, GSRlogy    -- flags indicating the x or y dimension is log scale.

   GSRxaxis_y          -- location of the yaxis (used for IMPULSE plotting).

   GSRpoint_type       -- Current point type (usually at least -1 - 6 available)
   GSRline_type        -- Current line type  (-2 - 12 on some terminals)

   GSRxmin, GSRxmax,   -- maximum and minimum values expected in user
   GSRymin, GSRymax       coordinates for X and Y coordinates.

   GSRxscale,          -- scaling factors to use to change from user
   GSRyscale;             coordinates back to terminal coordinates.

   GSRxtic, GSRytic    -- tic width in user coordinates.

   GSRxformat,         -- format strings to use with x and y tic values
   GSRyformat;            (default is "%g")
-*/

extern int GSRxleft, GSRxright, GSRybot, GSRytop;
extern TBOOLEAN GSRlogx, GSRlogy;
extern int GSRxaxis_y;
extern int  GSRpoint_type, GSRline_type;
extern double GSRxmin, GSRxmax, GSRymin, GSRymax;
extern double GSRxscale, GSRyscale;
extern float GSRxtic, GSRytic;
extern char *GSRxformat, *GSRyformat;
/*- end of GSR external definitions. -*/

#endif

/*-
   gsr_map_x(x)
   Macro to map user coordinate x to screen coordinate.

   gsr_map_y(y)
   Macro to map user coordinate y to screen coordinate.

   These macros map from user to terminal coordinates (maps floating
   point x or y to screen
-*/
#define gsr_map_x(x) (int)(GSRxleft+(x-GSRxmin)*GSRxscale+0.5) 
#define gsr_map_y(y) (int)(GSRybot+(y-GSRymin)*GSRyscale+0.5)

#endif
