;;;
;;; mac.scm -- A library of Macintosh toolbox functions in SCHEME
;;;
;;; Part of MacSCM 1.0.
;;;
;;; Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)
;;;
;;; This code is in the public domain.	You can copy it, sell it, modify it,
;;; all without any restrictions.
;;;

;;;
;;; Window Manager Proc Codes
;;;

(define documentProc	0)  ; standard document window, no zoom box.
(define dBoxProc	1)  ; alert box or modal dialog box.
(define plainDBox	2)  ; plain box.
(define altDBoxProc	3)  ; plain box with shadow.
(define noGrowDocProc	4)  ; movable window, no size box or zoom box.
(define movableDBoxProc 5)  ; movable modal dialog box.
(define zoomDocProc	8)  ; standard document window.
(define zoomNoGrow	12) ; zoomable, nonresizable window.
(define rDocProc	16) ; rounded-corner window.

;;;
;;; Window Manager Part Codes
;;;

(define inDesk	    0) ; none of the following.
(define inMenuBar   1) ; in menu bar.
(define inSysWindow 2) ; in desk accessory window.
(define inContent   3) ; If window is active, then
		       ; anywhere in content region except size box.
		       ; Otherwise, anywhere including size box.
(define inDrag	    4) ; in drag (title bar) region.
(define inGrow	    5) ; in size box (active window only).
(define inGoAway    6) ; in close box.
(define inZoomIn    7) ; in zoom box (window in standard state).
(define inZoomOut   8) ; in zoom box (window in user state).

;;;
;;; Control Manager Proc Codes
;;;

(define pushButProc   0)
(define checkBoxProc  1)
(define radioButProc  2)
(define scrollBarProc 16)
(define popupMenuProc 1008)

(define useWFont 8)

;;;
;;; Control Manager Part Codes
;;;

(define inButton     10)
(define inCheckBox   11)
(define inUpButton   20)
(define inDownButton 21)
(define inPageUp     22)
(define inPageDown   23)
(define inThumb	     129)

;;;
;;; Event Manager Event Codes
;;;

(define nullEvent   0)
(define mouseDown   1)
(define mouseUp	    2)
(define keyDown	    3)
(define keyUp	    4)
(define autoKey	    5)
(define updateEvt   6)
(define diskEvt	    7)
(define activateEvt 8)
(define osEvt	    15)

;;;
;;; Event Manager Event Code Masks
;;;

(define mDownMask	   2)
(define mUpMask		   4)
(define keyDownMask	   8)
(define keyUpMask	   16)
(define autoKeyMask	   32)
(define updateMask	   64)
(define diskMask	   128)
(define activMask	   256)
(define highLevelEventMask 1024)
(define osMask		   -32768)
(define everyEvent	   -1)

;;;
;;; Event Manager Event Message Masks
;;;

(define charCodeMask	 #x000000FF)
(define keyCodeMask	 #x0000FF00)
(define adbAddrMask	 #x00FF0000)
(define osEvtMessageMask #xFF000000)

;;;
;;; OSEvent Messages
;;;

(define mouseMovedMessage    #xFA)
(define suspendResumeMessage #x01)
(define resumeFlag	     1)	   ; bit 0 of message indicates resume vs suspend
(define convertClipboardFlag 2)	   ; bit 1 in resume message indicates clipboard change

;;;
;;; Event Manager Event Modifiers
;;;

(define activeFlag 1)	 ; bit 0 of modifiers for activate event
(define btnState   128)	 ; Bit 7 of low byte is mouse button state
(define cmdKey	   256)	 ; Bit 0
(define shiftKey   512)	 ; Bit 1
(define alphaLock  1024) ; Bit 2
(define optionKey  2048) ; Bit 3 of high byte
(define controlKey 4096)

;;;
;;; obsolete equates
;;;

(define networkEvt  10)
(define driverEvt   11)
(define app1Evt	    12)
(define app2Evt	    13)
(define app3Evt	    14)
(define app4Evt	    15)
(define networkMask 1024)
(define driverMask  2048)
(define app1Mask    4096)
(define app2Mask    8192)
(define app3Mask    16384)
(define app4Mask    -32768)

;;;
;;; Standard Fonts
;;;

(define systemFont  0)
(define applFont    1)
(define newYork	    2)
(define geneva	    3)
(define monaco	    4)
(define venice	    5)
(define london	    6)
(define athens	    7)
(define sanFran	    8)
(define toronto	    9)
(define cairo	    11)
(define losAngeles  12)
(define times	    20)
(define helvetica   21)
(define courier	    22)
(define symbol	    23)
(define mobile	    24)
(define commandMark 17)
(define checkMark   18)
(define diamondMark 19)

;;;
;;; mac:rect-explode
;;; mac:pt-explode
;;; mac:evt-explode
;;;
;;; These functions turn a macintosh-specific object into a list of
;;; constituent objects.
;;;

(define (mac:rect-explode rect)
  (list (mac:rect-get-left rect)
	(mac:rect-get-top rect)
	(mac:rect-get-right rect)
	(mac:rect-get-bottom rect)))

(define (mac:pt-explode pt)
  (list (mac:pt-get-h pt)
	(mac:pt-get-v pt)))

(define (mac:evt-explode evt)
  (list (mac:evt-get-what evt)
	(mac:evt-get-msg-int evt)
	(mac:evt-get-when evt)
	(mac:evt-get-where evt)
	(mac:evt-get-mods evt)))

(define (mac:ctrl-same? ctrl1 ctrl2)
  (eq? (mac:ctrl-get-ref ctrl1) (mac:ctrl-get-ref ctrl2)))

(define (mac:wind-same? wind1 wind2)
  (eq? (mac:wind-get-ref wind1) (mac:wind-get-ref wind2)))

(define (mac:mods-get-active mods)  (not (= 0 (logand mods activeFlag))))
(define (mac:mods-get-button mods)  (not (= 0 (logand mods btnState))))
(define (mac:mods-get-command mods) (not (= 0 (logand mods cmdKey))))
(define (mac:mods-get-shift mods)   (not (= 0 (logand mods shiftKey))))
(define (mac:mods-get-alpha mods)   (not (= 0 (logand mods alphaLock))))
(define (mac:mods-get-option mods)  (not (= 0 (logand mods optionKey))))
(define (mac:mods-get-control mods) (not (= 0 (logand mods controlKey))))

(define (mac:string->number string)
  (letrec
    ((iter
       (lambda (string index max total)
	 (if (>= index max)
	     total
	     (iter string (1+ index) max (+ (* 256 total)
					    (char->integer
					      (string-ref string index))))))))
    (iter string 0 (string-length string) 0)))
