
/*  *************************************************************************
    macctrl.c -- The Macintosh control functions code for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "macwind.h"
#include "macctrl.h"


/*  ************************************************************************/


static Str255 GStr255;
static char ARG6[] = "arg6";
static char ARG7[] = "arg7";
static char ARG8[] = "arg8";
static char ARG9[] = "arg9";


/*  ************************************************************************/


static SCM *GpScmCtrlActionProc;
static pascal void MyCtrlActionProc (ControlHandle theControl, short part);
static pascal void MyCtrlActionProc (ControlHandle theControl, short part) {
    SCM c, i;
    GrafPtr G;

    GetPort(&G);

    c = (SCM) GetCRefCon(theControl);
    i = MAKINUM(part);

    apply(*GpScmCtrlActionProc, cons2(c, i, EOL), EOL);

    SetPort(G);
}

void init_mac_ctrl2 (void) {
    GpScmCtrlActionProc = &CDR(sysintern("mac:ctrl-action-proc", UNSPECIFIED));
}



/*  ************************************************************************/


#define TrkControl(a,b)	    TrackControl(a,b,NULL)
#define TrkControl2(a,b)    TrackControl(a,b,MyCtrlActionProc)


#define SUBRS(x)								\
x("ctrl-new",		c_new,	    SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("ctrl-set-title",	c_s_title,  CTRLSTRING_FUNC,	    SetCTitle)		\
x("ctrl-set-value",	c_s_value,  CTRLINT_FUNC,	    SetCtlValue)	\
x("ctrl-set-min",	c_s_min,    CTRLINT_FUNC,	    SetCtlMin)		\
x("ctrl-set-max",	c_s_max,    CTRLINT_FUNC,	    SetCtlMax)		\
x("ctrl-set-ref",	c_s_ref,    SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("ctrl-get-title",	c_g_title,  CTRL_STRING_FUNC,	    GetCTitle)		\
x("ctrl-get-value",	c_g_value,  CTRL_INT_FUNC,	    GetCtlValue)	\
x("ctrl-get-min",	c_g_min,    CTRL_INT_FUNC,	    GetCtlMin)		\
x("ctrl-get-max",	c_g_max,    CTRL_INT_FUNC,	    GetCtlMax)		\
x("ctrl-get-ref",	c_g_ref,    SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("ctrl-get-var",	c_g_var,    CTRL_INT_FUNC,	    GetCVariant)	\
x("ctrl-dispose",	c_dispose,  CTRL_FUNC,		    DisposeControl)	\
x("ctrl-hide",		c_hide,	    CTRL_FUNC,		    HideControl)	\
x("ctrl-show",		c_show,	    CTRL_FUNC,		    ShowControl)	\
x("ctrl-draw",		c_draw,	    CTRL_FUNC,		    Draw1Control)	\
x("ctrl-hilite",	c_hilite,   CTRLINT_FUNC,	    HiliteControl)	\
x("ctrl-move",		c_move,	    CTRLINT2_FUNC,	    MoveControl)	\
x("ctrl-size",		c_size,	    CTRLINT2_FUNC,	    SizeControl)	\
x("ctrl-drag",		c_drag,	    CTRLPTRECT2INT_FUNC,    DragControl)	\
x("ctrl-test",		c_test,	    CTRLPT_INT_FUNC,	    TestControl)	\
x("ctrl-track",		c_track,    CTRLPT_INT_FUNC,	    TrkControl)		\
x("ctrl-track-2",	c_track_2,  CTRLPT_INT_FUNC,	    TrkControl2)	\
x("wind-find-ctrl",	w_f_c,	    SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("wind-find-ctrlp",	w_f_c_p,    SPECIAL_FUNC,	    SPECIAL_FUNC)	\
x("wind-kill-ctrls",	w_kill_cs,  WIND_FUNC,		    KillControls)	\
x("wind-draw-ctrls",	w_draw_cs,  WIND_FUNC,		    DrawControls)	\


/*  ************************************************************************/


DECLARE_FUNCS(SUBRS,init_mac_ctrl)


/*  ************************************************************************/


SCM mac_c_new(SCM s_args)
{
  ControlHandle ppControl;
  WindowPtr w;
  Rect r;
  char *pc;
  short value, min, max, procID;
  char vis;
  SCM s;

  GET_NEXT_MACWIND(w,	s_args, ARG1, s_mac_c_new);
  GET_NEXT_MACRECT(r,	s_args, ARG2, s_mac_c_new);
  GET_NEXT_STRING(pc,	s_args, ARG3, s_mac_c_new);
  GET_NEXT_BOOL(vis,	s_args, ARG4, s_mac_c_new);
  GET_NEXT_INT(value,	s_args, ARG5, s_mac_c_new);
  GET_NEXT_INT(min,	s_args, ARG6, s_mac_c_new);
  GET_NEXT_INT(max,	s_args, ARG7, s_mac_c_new);
  GET_NEXT_INT(procID,	s_args, ARG8, s_mac_c_new);

  c2pstr (strncpy((char *) GStr255, pc, 255));

  ppControl = NewControl (w, &r, &GStr255, vis, value, min, max, procID, 0);

  if (ppControl) {
    s = make_macctrl(ppControl);
    SetCRefCon(ppControl, (long) s);
    return s;
  }
  else {
    return BOOL_F;
  }
}

SCM mac_c_s_ref(SCM s_args)
{
  ControlHandle c;
  SCM s;

  GET_NEXT_MACCTRL(c, s_args, ARG1, s_mac_c_s_ref);
  GET_NEXT_SCM(s, s_args, ARG1, s_mac_c_s_ref);
  SetCRefCon(c, (long) s);

  return UNSPECIFIED;
}

SCM mac_c_g_ref(SCM s_args)
{
  ControlHandle c;

  GET_NEXT_MACCTRL(c, s_args, ARG1, s_mac_c_g_ref);

  return (SCM) GetCRefCon(c);
}

SCM mac_w_f_c(SCM s_args)
{
  Point p;
  WindowPtr w;
  ControlHandle c;
  short h;

  GET_NEXT_MACWIND(w, s_args, ARG1, s_mac_w_f_c);
  GET_NEXT_MACPT(p, s_args, ARG2, s_mac_w_f_c);
  h = FindControl(p, w, &c);

  if (c)
    return make_macctrl(c);
  else
    return BOOL_F;
}

SCM mac_w_f_c_p(SCM s_args)
{
  Point p;
  WindowPtr w;
  ControlHandle c;
  short h;

  GET_NEXT_MACWIND(w, s_args, ARG1, s_mac_w_f_c_p);
  GET_NEXT_MACPT(p, s_args, ARG2, s_mac_w_f_c_p);
  h = FindControl(p, w, &c);

  return MAKINUM(h);
}


/*  ************************************************************************/
