.TH XMS 1 "24 Nov 1991" "MandelSpawn 0.06"
.SH NAME 
xms \- X MandelSpawn, a network Mandelbrot program for X11
.SH SYNOPSIS  
.B xms
[
.B \-iterations
n ] [
.B \-colours
n ] [
.B \-wrap
] [
.B \-spectrum
colour\-colour\- ... \-colour
] [
.B \-greyscale
] [
.B \-center
] [
.B \-nocenter
] [
.B \-cursor
cursor ] [
.B \-x
coord ] [
.B \-y
coord ] [
.B \-range
r ] [
.B \-julia
]
.SH DESCRIPTION  
.I Xms
is a program for interactive display of the 
Mandelbrot and Julia sets under the X window system.  
You can select an area of interest using the mouse and
zoom in on it either in the same window or by popping up a new window.
.PP 
.I Xms
relies on "computation server" processes (see 
.IR mslaved (8))
running on one or more machines to do the actual computations.   
.PP
.SH "INTERACTING WITH XMS"
When 
.I xms
starts up it first creates an initial window showing the
entire Mandelbrot set.  The window may be moved or stretched using
the window manager.  You can select an area to zoom into using
the left mouse button, and then zoom in by pressing the middle button or
the \fBz\fP key.
Normally a new window is created for the zoomed image, but if you
want to reuse the original window you can do that by keeping the
shift key depressed while zooming.
.PP
If
.I xms
has been compiled with the X11R4 Xaw library, 
the right mouse button
pops up a menu with several self-explanatory options.  Without
Xaw, pressing the 
right mouse button (or the \fBc\fP key) closes the window pointed to, and
shift-right button (or pressing 
\fBq\fP) causes the program to exit,
destroying all its windows.
.PP
Pressing the \fBj\fP key (j as in Julia) pops up a new window showing the 
Julia set corresponding to the point at the center of the selected area.
The \fBo\fP key zooms out in such a way that what is currently visible
in the window will be be positioned in the selected area after the zoom.
These keys may also be used together with the shift key.  It is also
possible to zoom out by dragging the rubberband box
.I outside
the window and then zoom using \fBz\fP or the middle mouse button.
.PP
Pressing \fBw\fP causes the window coordinates to be printed on the
standard output, and \fBs\fP prints various statistics about computation
server performance.
.PP
.SH "COMMAND LINE OPTIONS"
In addition to the standard Xt options, 
.I xms
provides the following options:
.IP "\fB\-iterations\fP \fIn\fP"
Specifies the maximum number of iterations.  The default is 250.
.IP "\fB\-colours\fP \fIn\fP"
Specifies the number of colours or shades of grey to use.
Because white and black are needed for the popup menu under X11R4,
you need to specify a value that is at least 2 less than 
the number of colours supported by the hardware.
The default value
for \fB\-colours\fP is the value of \fB\-iterations\fP.  
The default of 250 iterations
leaves 6 colours for other applications on an 8-plane display, 
thus avoiding the "technicolor effect" in most cases.
If you have less than 250 colours available
(Motif users often do), you will have to specify
either the \fB\-iterations\fP or \fB\-colours\fP option.  If \fB\-colours\fP
is less than \fB\-iterations\fP, the same colour is reused for several
consecutive iteration counts or, if the \fB\-wrap\fP option was given,
the same sequence of colours 
will be repeated as many
times as necessary.  The areas corresponding to the maximum
iteration count, i.e. the
inside of the Mandelbrot set, will always use the last colour of those
specified with the \fB\-spectrum\fP option.
Has no effect with a single-plane display.
.IP "\fB\-wrap\fP"
See above.
.IP "\fB\-spectrum\fP \fIcolour\-colour\- ... \-colour\fP"
Uses the specified colours or shades of grey (can only be used with
a colour or greyscale 
display).  The first one is used
for the area outside the circle with radius 2 around the origin, the last one
is used for the Mandelbrot set itself.  For intervening iteration counts
the colour is found by interpolating linearly in RGB space between pairs 
of the colours given in the argument.
.IP "\fB\-greyscale\fP"
This is a synonym for "\fB\-spectrum\fP \fIwhite\-black\fP".
.IP "\fB\-center\fP"
Causes the center of the rubberband box to remain fixed while a corner
follows the cursor when selecting an area to zoom into.  This is the default.
.IP "\fB\-nocenter\fP"
Causes one corner of the rubberband box to remain fixed while the opposite
corner follows the cursor when selecting an area to zoom into.
.IP "\fB\-cursor\fP \fIcursor\fP"
Specifies the type of cursor.
.IP "\fB\-x\fP, \fB\-y\fP, \fB\-range\fP"
Specify the center coordinates and horizontal width, respectively, of
the part of the Mandelbrot or Julia set shown in the initial window.
These options currently work only if
.I xms
has been compiled with the X11R4 library.
.IP "\fB\-julia\fP"
Causes the initial window to show a Julia set instead of a Mandelbrot
set.  The "\fB\-cx\fP" and "\fB\-cy\fP" options may be used to
choose the \fIc\fP parameter for the Julia set.
.PP
.SH BUGS
By zooming out from the initial picture it is possible to view 
areas (starting at a distance of about 10 from
the origin) where the fixed-point arithmetic used by some servers
overflows.  This bug remains unfixed because some users think
the fractal interference patterns caused by the overflow
look at least as interesting as the Mandelbrot set itself.
.PP
The \fB\-x\fP, \fB\-y\fP, \fB\-range\fP, \fB\-cx\fP, and \fB\-cy\fP
options work only with the X11R4 library.
.PP
.SH FILES
.if n .ta 2.5i
.if t .ta 2i
/usr/local/etc/mslaves	list of computation server hosts
.br
$HOME/.mslaves	per-user override of the above
.PP
.SH "SEE ALSO"
X(1), X(8C), mslaved(8), mslavedc(8), enslave(1)
.PP
.SH ENVIRONMENT
DISPLAY	the default host and display.
.PP
.SH COPYRIGHT
.if n Copyright (C) 1990, 1991 Andreas Gustafsson (gson@niksula.hut.fi)
.if t Copyright \(co 1990, 1991 Andreas Gustafsson (gson@niksula.hut.fi)
