/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

#include "agg.h"

/* **************************** ******** ****************************** */
/* Module Mapping.c 		20/10/92		Jochen Alt (ja) */
/* **************************** ******** ****************************** */

void sos_Object_sos_Object_Mapping::change_list_cursor (sos_Bool new_lc)
{  sos_Object_sos_Object_Mapping_impl old_impl = self.get_impl();

   agg_Impl impl_type = self.get_impl_type();
   sos_Bool kboe = self.get_role1_based_on_equal();
   sos_Bool iboe = self.get_role2_based_on_equal();

   sos_Object_sos_Object_Mapping new_m =
      sos_Object_sos_Object_Mapping::create (self.container(),
					     new_lc, kboe,iboe,impl_type);

   sos_Object_sos_Object_Mapping_impl new_impl = new_m.get_impl();
   agg_iterate_association (old_impl, sos_Object key, sos_Object info)
      new_impl.insert (key,info);
   agg_iterate_association_end (old_impl, key, info)

      // switch  the implementations
   self.set_impl (new_impl);
   new_m.set_impl (old_impl);

      // destroy yet created Mapping with old Mapping_impl
   new_m.destroy();
} // ** Mapping::change_list_cursor ***


void sos_Object_sos_Object_Mapping::local_initialize 
					 (sos_Object_sos_Object_Mapping m)
{  sos_Object_sos_Object_Mapping_impl im;
   sos_Container cnt = m.container();
   agg_Impl impl_type = m.get_impl_type();
   sos_Bool lc = m.get_list_cursor();
   sos_Bool kboe = m.get_role1_based_on_equal();
   sos_Bool iboe = m.get_role2_based_on_equal();

   switch (impl_type)
   {  case AGG_LIST:  
         im = sos_Object_sos_Object_Mapping_List::create (cnt, lc, kboe, iboe);
         break;
      case AGG_HASH:
         im = sos_Object_sos_Object_Mapping_Hash::create (cnt,lc,kboe,iboe);
         break;
      case AGG_AUTOMATIC:
         im = sos_Object_sos_Object_Mapping_List::create (cnt, lc, kboe, iboe);
         break;
      default:
         err_assert (FALSE,"Mapping::invalid implementation type");
	 break;
   }
   m.set_impl (im);
} // *** Mapping::local_initialize ***
 
void sos_Object_sos_Object_Mapping::change_impl_type 
					       (agg_Impl new_impl_type)
{  
   sos_Container cnt = self.container();
   if ((new_impl_type != AGG_AUTOMATIC) AND
       (new_impl_type != self.get_impl_type()))
   {  
      sos_Object_sos_Object_Mapping_impl old_impl = self.get_impl();
      sos_Object_sos_Object_Mapping_impl new_impl =
         sos_Object_sos_Object_Mapping_impl::make (NO_OBJECT);
      sos_Bool kboe = self.get_role1_based_on_equal();
      sos_Bool iboe = self.get_role2_based_on_equal();
      sos_Bool lc   = self.get_list_cursor();
      switch (new_impl_type)
      {  case AGG_LIST:
            new_impl = sos_Object_sos_Object_Mapping_List::create 
						     (cnt, lc, kboe,iboe);
            break;
         case AGG_HASH:
            new_impl = sos_Object_sos_Object_Mapping_Hash::create 
						     (cnt, lc, kboe, iboe);
            break;
         case AGG_AUTOMATIC: // suppress warning
	    break;
      }

      agg_iterate_association (old_impl, sos_Object key,sos_Object info)
      {  new_impl.insert (key, info); }
      agg_iterate_association_end (old_impl, key,info)
      
      self.set_impl (new_impl);
      old_impl.destroy();
   }
   self.set_impl_type (new_impl_type);

   if (new_impl_type == AGG_AUTOMATIC)
      self.check_impl_type(self.get_impl());
} // *** Mapping::change_impl_type ***

void sos_Object_sos_Object_Mapping::check_impl_type 
				(sos_Object_sos_Object_Mapping_impl m)
// if automatic, change the implementation type if the conditions are right
{  if (self.get_impl_type() == AGG_AUTOMATIC)
   {  sos_Int c = self.card();
      if (c > 12) 
      {	if (m.has_type 
		(sos_Object_sos_Object_Mapping_List_type))
	{  self.change_impl_type (AGG_HASH);
	   self.set_impl_type (AGG_AUTOMATIC);
	}
      }
      else if (c < 8)
      {   if (m.has_type 
	       (sos_Object_sos_Object_Mapping_Hash_type))
          {  self.change_impl_type (AGG_LIST);
	     self.set_impl_type (AGG_AUTOMATIC);
          }
      }
   }
} // ** Mapping:check_impl_type ***

void sos_Object_sos_Object_Mapping::local_assign 
			     (sos_Object_sos_Object_Mapping m, sos_Object o)
// change the implementation type and assign 
{  sos_Object_sos_Object_Mapping om = 
      sos_Object_sos_Object_Mapping::make (o);
   m.clear();
   sos_Object_sos_Object_Mapping_impl o_impl= om.get_impl();
   if (o_impl.has_type (sos_Object_sos_Object_Mapping_List_type))
      m.change_impl_type (AGG_LIST);
   else if (o_impl.has_type (sos_Object_sos_Object_Mapping_Hash_type))
      m.change_impl_type (AGG_HASH);

   m.get_impl().assign (o_impl); 

   if (om.get_impl_type() == AGG_AUTOMATIC)
      m.change_impl_type (AGG_AUTOMATIC);
} // *** Mapping::local_assign ***

sos_Bool sos_Object_sos_Object_Mapping::local_equal 
	      (sos_Object_sos_Object_Mapping m, sos_Object o, sos_Eq_kind e)
{ 
   sos_Object_sos_Object_Mapping_impl m_impl = m.get_impl();
   sos_Object_sos_Object_Mapping_impl o_impl = 
      sos_Object_sos_Object_Mapping::make(o).get_impl();

   if (m_impl.type().operator== (o_impl.type())) //ATT2.0 QUEERNESS: explicit operator
      return m_impl.equal (o_impl, e);
   else
   {  sos_Bool result = TRUE;

      if (o_impl.card() != m_impl.card())
	 result = FALSE;
      else
      {  sos_Bool info_based_on_equal = m.get_role2_based_on_equal();
	 agg_iterate_association (m_impl, sos_Object key, sos_Object info)
	 {  if (NOT agg_same_entity (o_impl[key],info,
				     info_based_on_equal,e))
	    {  result = FALSE;
	       break;
	    }
	 }
	 agg_iterate_association_end (m_impl, key, info);
      }
      return result;
   }
} // *** Mapping::local_equal ***
 

sos_Bool sos_Object_sos_Object_Mapping::is_key (sos_Object key)
{   return self.get_impl().is_key (key); } 

sos_Bool sos_Object_sos_Object_Mapping::is_info (sos_Object info)
{   return self.get_impl().is_info (info); } 

void sos_Object_sos_Object_Mapping::insert (sos_Object key, sos_Object info)
{ sos_Object_sos_Object_Mapping_impl m = self.get_impl();
  m.insert (key,info); 
  self.check_impl_type(m);
}

void sos_Object_sos_Object_Mapping::remove (sos_Object key)
{ sos_Object_sos_Object_Mapping_impl m = self.get_impl();
  m.remove (key);
  self.check_impl_type(m);
}

sos_Object sos_Object_sos_Object_Mapping::operator[] (sos_Object key)
{ return self.get_impl()[key]; }

// Cursor operations that do not modify the Mapping or the cursor
// don't need to check the correct node type, because these
// operations just use the mother-class sos_Mapping_node instead the
// implementation specialized classes sos_Mapping_Hash_node or
// sos_Mapping_List_node
sos_Object sos_Object_sos_Object_Mapping::get_key (sos_Cursor c)
{  return self.get_impl().get_key (c); }

sos_Object sos_Object_sos_Object_Mapping::get_info (sos_Cursor c)
{  return self.get_impl().get_info (c); }

void sos_Object_sos_Object_Mapping::set_info (sos_Cursor c, sos_Object info)
{   self.get_impl().set_info (c,info); }

sos_Bool sos_Object_sos_Object_Mapping::move_cursor 
					  (sos_Cursor c, sos_Object key)
{  sos_Object_sos_Object_Mapping_impl m = self.get_impl();
   m.check_node_type (c);
   return m.move_cursor (c,key); 
}

void sos_Object_sos_Object_Mapping::insert_before 
			    (sos_Cursor c, sos_Object key, sos_Object info)
{  sos_Object_sos_Object_Mapping_impl m = self.get_impl();
   m.check_node_type (c);
   m.insert_before (c,key,info); 
   self.check_impl_type(m);
}

void sos_Object_sos_Object_Mapping::insert_after 
			    (sos_Cursor c, sos_Object key, sos_Object info)
{  sos_Object_sos_Object_Mapping_impl m = self.get_impl();
   m.check_node_type (c);
   m.insert_after (c,key,info); 
   self.check_impl_type(m);
}

sos_Int sos_Object_sos_Object_Mapping::size () 
{ return self.sos_Object::size() + self.get_impl().size(); }

sos_Bool sos_Object_sos_Object_Mapping::is_role1 (sos_Object key) 
{ return self.get_impl().is_role1 (key); }

sos_Bool sos_Object_sos_Object_Mapping::is_role2 (sos_Object info) 
{ return self.get_impl().is_role2 (info); }

sos_Object sos_Object_sos_Object_Mapping::get_role1 (sos_Cursor c) 
{ return self.get_impl().get_role1 (c); }

sos_Object sos_Object_sos_Object_Mapping::get_role2 (sos_Cursor c) 
{ return self.get_impl().get_role2 (c); }

void sos_Object_sos_Object_Mapping::clear()
{ self.get_impl().clear(); }

void sos_Object_sos_Object_Mapping::remove_at (sos_Cursor c)
{ sos_Object_sos_Object_Mapping_impl m = self.get_impl();
  m.check_node_type (c);
  m.remove_at(c); 
  self.check_impl_type (m);
}

sos_Int sos_Object_sos_Object_Mapping::card()
{  return self.get_impl().card(); }

sos_Cursor sos_Object_sos_Object_Mapping::open_cursor (sos_Container cnt)
{  return self.get_impl().open_cursor(cnt); }

void sos_Object_sos_Object_Mapping::close_cursor (sos_Cursor c)
{  self.get_impl().close_cursor (c); }

sos_Cursor sos_Object_sos_Object_Mapping::duplicate 
(sos_Cursor c, sos_Container cnt /* = TEMP_CONTAINER*/)
{  sos_Object_sos_Object_Mapping_impl m = self.get_impl();
   m.check_node_type (c);
   return m.duplicate (c,cnt); 
}

sos_Bool sos_Object_sos_Object_Mapping::is_valid (sos_Cursor c)
{ return self.get_impl().is_valid (c); }

sos_Bool sos_Object_sos_Object_Mapping::to_first (sos_Cursor c)
{  sos_Object_sos_Object_Mapping_impl m = self.get_impl();
   m.check_node_type (c);
   return m.to_first (c); 
}

sos_Bool sos_Object_sos_Object_Mapping::to_last (sos_Cursor c)
{  sos_Object_sos_Object_Mapping_impl m = self.get_impl();
   m.check_node_type(c);
   return m.to_last (c); 
}

sos_Bool sos_Object_sos_Object_Mapping::to_succ (sos_Cursor c, sos_Int i)
{  sos_Object_sos_Object_Mapping_impl m = self.get_impl();
   m.check_node_type (c);
   return m.to_succ (c,i); 
}

sos_Bool sos_Object_sos_Object_Mapping::to_pred (sos_Cursor c, sos_Int i)
{  sos_Object_sos_Object_Mapping_impl m = self.get_impl();
   m.check_node_type (c);
   return m.to_pred (c,i); 
}

void sos_Object_sos_Object_Mapping::local_finalize 
					      (sos_Object_sos_Object_Mapping m)
{  m.get_impl().destroy(); }


sos_Int sos_Object_sos_Object_Mapping::local_hash_value (sos_Object_sos_Object_Mapping m)
{ return m.get_impl().hash_value(); }

// check if the node c.get_current() has the corroesponding type to
// the current implementation
void sos_Object_sos_Object_Mapping_impl::check_node_type (sos_Cursor c)
{  sos_Object_sos_Object_Mapping_impl m = self;
   sos_Node n = c.get_current();
   n.check_list_cursor (self);
   sos_Node  new_node;
   if (NOT (n.has_type (sos_Mapping_List_node_type))
      AND (m.has_type (sos_Object_sos_Object_Mapping_List_type)))
   {  new_node = sos_Mapping_node::create (c.container(), self.get_list_cursor());
      sos_Object key = sos_Mapping_node::make (n).get_key();
      n.destroy();
      m.move_cursor (c, key);
   }
} // ** check_node_type **

