#line 1 "./src/agg/Set.C"
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */
// **************************************************************************
// Module Set                       03/07/89           Bernhard Schiefer (bs)
//                                                     modified: 23/7/90 (ja)
//                                                              24/10/91 (bs)
//                                                              24/10/92 (ja)
// **************************************************************************
// implements methods of classes: Set
// **************************************************************************

#include "agg.h"
  

// *** Sets are based on Object_sos_Bool_Mappings ***

// **************************************************************************
void _sos_Object_Set::change_impl_type (const sos_Typed_id&_OBSThis,agg_Impl impl)
// **************************************************************************
const{   get_m(_OBSThis).change_impl_type (impl);
} // ** Set::change_impl_type ***

// **************************************************************************
void _sos_Object_Set::change_list_cursor (const sos_Typed_id&_OBSThis,sos_Bool list_cursor)
// **************************************************************************
const{  get_m(_OBSThis).change_list_cursor (list_cursor);
   set_list_cursor (_OBSThis,list_cursor);
} // ** Set::change_list_cursor ***
 

// **************************************************************************
void _sos_Object_Set::local_initialize (OBST_PARDECL(sos_Object_Set) set)
// **************************************************************************
{  T_PROC ("sos_Object_Set::local_initialize");
   TT (agg_H, T_ENTER);

   set.set_m (sos_Object_sos_Object_Mapping::create
		 (set.container(),
		  set.get_list_cursor(),
		  set.get_based_on_equal(),
		  FALSE,
		  set.get_impl_type()));

   TT (agg_H, T_LEAVE);
} // ** local_initialize **

// **************************************************************************
void _sos_Object_Set::local_finalize (OBST_PARDECL(sos_Object_Set) set)
// **************************************************************************
{  T_PROC ("sos_Object_Set::local_finalize");
   TT (agg_H, T_ENTER);

   set.get_m().destroy();

   TT (agg_H, T_LEAVE);
} // ** local_finalize **

// **************************************************************************
void _sos_Object_Set::insert (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) o)
// **************************************************************************
// fuege das Objekt o in das Set ein, es wird die Anzahl der danach im
// Set vorhandenen Exemplare geliefert.
const{
   T_PROC ("sos_Object_Set::insert");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping m = get_m(_OBSThis);
   m.insert (o, NO_OBJECT); // don't care for the Mapping-Entity

   TT (agg_H, T_LEAVE);
} // ** insert **

// **************************************************************************
void _sos_Object_Set::remove (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) o)
// **************************************************************************
// loesche ein Objekt o, es wird TRUE,geliefert, falls es drin war
const{  
   T_PROC ("sos_Object_Set::remove");
   TT (agg_H, T_ENTER);

   get_m(_OBSThis).remove (o);

   TT (agg_H, T_LEAVE);
} // ** remove **

// **************************************************************************
void _sos_Object_Set::__plus_assign (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Set) aset)
// **************************************************************************
// Nach A += B wurden alle Elemente in B zu A aufaddiert
const{
   T_PROC ("sos_Object_Set::operator+=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping this_m = get_m(_OBSThis);
   sos_Object_sos_Object_Mapping aset_m = aset.get_m();

   sos_Cursor cur = aset_m.open_cursor ();
   for (;aset_m.is_valid (cur); aset_m.to_succ (cur))
   {  sos_Object o = aset_m.get_key (cur);
      this_m.insert (o, NO_OBJECT);
   } // for
   aset_m.close_cursor (cur);

   TT (agg_H, T_LEAVE);
} // ** operator+= **

// **************************************************************************
void _sos_Object_Set::__minus_assign (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Set) aset)
// **************************************************************************
// Nach A -= B wurden aus A alle Elemente, die in B sind, entfernt
const{  
   T_PROC ("sos_Object_Set::operator-=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping this_m = get_m(_OBSThis);
   sos_Object_sos_Object_Mapping aset_m = aset.get_m();

   sos_Cursor cur = aset_m.open_cursor();
   for (;aset_m.is_valid (cur);aset_m.to_succ (cur))
   {  sos_Object o = aset_m.get_key (cur);
      this_m.remove (o);
   } // for
   aset_m.close_cursor (cur);

   TT (agg_H, T_LEAVE);
} // ** operator-= **

// **************************************************************************
void _sos_Object_Set::__times_assign (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Set) aset)
// **************************************************************************
// Liefert die Schnittmenge von A und B in A,
// Also entferne aus self alle Elemente, die nicht in aset sind
const{
   T_PROC ("sos_Object_Set::operator*=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping aset_m = aset.get_m();
   sos_Object_sos_Object_Mapping this_m = get_m(_OBSThis);

   sos_Cursor cur = this_m.open_cursor();
   for (;this_m.is_valid (cur);)
   {  sos_Object o = this_m.get_key (cur);
      if (NOT aset_m.is_key (o))
         this_m.remove_at (cur);
      else
         this_m.to_succ (cur);
   } // for 
   this_m.close_cursor (cur);

   TT (agg_H, T_LEAVE);
} // ** operator*= **

// **************************************************************************
sos_Bool _sos_Object_Set::__less (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Set) aset)
// **************************************************************************
// Liefert TRUE zurueck, wenn jedes Element aus this auch in aset ist
// und aset mindestens ein Element mehr enthaelt
const{ 
   T_PROC ("sos_Object_Set::operator<");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping aset_m = aset.get_m();
   sos_Object_sos_Object_Mapping this_m = get_m(_OBSThis);
   sos_Bool result = TRUE;

   if (this_m.card() >= aset_m.card())
      result = FALSE;
   else
   {  sos_Cursor cur = this_m.open_cursor();
      for (;this_m.is_valid (cur);this_m.to_succ (cur))
      {  sos_Object o = this_m.get_key (cur);
         if (NOT aset_m.is_key (o))
         {  result = FALSE;
            break;
         }
      } // for
      this_m.close_cursor (cur);
   }

   TT (agg_H, T_LEAVE);
   return result;
} // ** operator< **

// **************************************************************************
sos_Bool _sos_Object_Set::__less_equal (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Set) aset)
// **************************************************************************
// Liefert TRUE zurueck, wenn jedes Element aus this auch in aset ist
const{ 
   T_PROC ("sos_Object_Set::operator<=");
   TT (agg_H, T_ENTER);

   sos_Object_sos_Object_Mapping aset_m = aset.get_m();
   sos_Object_sos_Object_Mapping this_m = get_m(_OBSThis);
   sos_Bool result = TRUE;

   // pruefe zuerst, ob die Anzahl der Elemente schon ein Ergebnis liefert
   if (this_m.card() > aset_m.card())
      result = FALSE;
   else
   {  sos_Cursor cur = this_m.open_cursor();
      for (;this_m.is_valid (cur); this_m.to_succ (cur))
      {  sos_Object o = this_m.get_key (cur);
         if (NOT aset_m.is_key (o))
         {  result = FALSE;
            break;
         }
      } // for
      this_m.close_cursor (cur);
   }
   TT (agg_H, T_LEAVE);
   return result;
} // ** operator<= **

// **************************************************************************
sos_Bool _sos_Object_Set::__greater (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Set) aset)
const{ return sos_Bool (aset < sos_Object_Set::make(_OBSThis,this)); }
// **************************************************************************

// **************************************************************************
sos_Bool _sos_Object_Set::__greater_equal (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object_Set) aset)
const{ return sos_Bool (aset <= sos_Object_Set::make(_OBSThis,this)); }
// **************************************************************************

// **************************************************************************
void _sos_Object_Set::local_assign (OBST_PARDECL(sos_Object_Set) x,OBST_PARDECL( sos_Object) o)
// **************************************************************************
{  T_PROC ("sos_Object_Set::local_assign");
   TT(agg_H, T_ENTER);

   sos_Object_Set y = sos_Object_Set::make (o);
   x.get_m().assign (y.get_m());

   TT(agg_H, T_LEAVE);
} // local_assign

// **************************************************************************
sos_Bool _sos_Object_Set::local_equal (OBST_PARDECL(sos_Object_Set) x,OBST_PARDECL(
				      sos_Object)     o,
	 			      sos_Eq_kind    eq_kind)
// **************************************************************************
{  T_PROC ("sos_Object_Set::local_equal")
   TT(agg_H, T_ENTER);
   
   sos_Object_Set y = sos_Object_Set::make (o);
   sos_Bool result = x.get_m().equal (y.get_m(), eq_kind);

   TT(agg_H, T_LEAVE);
   return result;
} // local_equal

// **************************************************************************
sos_Int _sos_Object_Set::local_hash_value (OBST_PARDECL(sos_Object_Set) x)
// **************************************************************************
{  T_PROC ("sos_Object_Set::local_hash_value");
   TT(agg_H, T_ENTER);
   
   sos_Int result = x.get_m().hash_value ();

   TT(agg_H, T_LEAVE);

   return result;
} // local_hash_value

// **************************************************************************
sos_Bool _sos_Object_Set::is_element (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Object) o)
// **************************************************************************
const{  T_PROC ("sos_Object_Set::is_element");
   TT (agg_H, T_ENTER);

   sos_Bool result = get_m(_OBSThis).is_key (o);
 
   TT (agg_H, T_LEAVE);
   return result;
} // ** is_element(sos_Object)

// **************************************************************************
sos_Object _sos_Object_Set::get (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  T_PROC ("sos_Object_Set::get");
   TT (agg_H, T_ENTER);

   sos_Object o = get_m(_OBSThis).get_key (c);

   TT (agg_H, T_LEAVE);
   return o;
} // ** get **

// **************************************************************************
void _sos_Object_Set::remove_at (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  T_PROC ("sos_Object_Set::remove_at");
   TT (agg_H, T_ENTER);

   get_m(_OBSThis).remove_at (c);

   TT (agg_H, T_LEAVE);
} // ** remove_at **

// **************************************************************************
void _sos_Object_Set::clear(const sos_Typed_id&_OBSThis)
// **************************************************************************
const{  T_PROC ("sos_Object_Set::clear");
   TT (agg_H, T_ENTER);
   
   get_m(_OBSThis).clear();

   TT (agg_H, T_LEAVE);
} // ** clear

// **************************************************************************
sos_Int _sos_Object_Set::card (const sos_Typed_id&_OBSThis)
// **************************************************************************
const{  return get_m(_OBSThis).card ();
} // card

// **************************************************************************
sos_Cursor _sos_Object_Set::open_cursor (const sos_Typed_id&_OBSThis,sos_Container Cursor_ct)
// **************************************************************************
const{  return get_m(_OBSThis).open_cursor (Cursor_ct);
} // open_cursor

// **************************************************************************
void _sos_Object_Set::close_cursor (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  get_m(_OBSThis).close_cursor (c);
} // close_cursor
 
// **************************************************************************
sos_Cursor _sos_Object_Set::duplicate (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, 
				      sos_Container cnt /*= TEMP_CONTAINER */)
// **************************************************************************
const{  return get_m(_OBSThis).duplicate (c,cnt);
} // duplicate

// **************************************************************************
sos_Bool _sos_Object_Set::is_valid (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  return get_m(_OBSThis).is_valid (c);
} // ** is_valid **
 
// **************************************************************************
sos_Bool _sos_Object_Set::to_first (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  return get_m(_OBSThis).to_first (c);
} // to_first

// **************************************************************************
sos_Bool _sos_Object_Set::to_last (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c)
// **************************************************************************
const{  return get_m(_OBSThis).to_last (c);
} // to_last
 
// **************************************************************************
sos_Bool _sos_Object_Set::to_succ (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, sos_Int steps)
// **************************************************************************
const{  T_PROC ("sos_Object_Set::to_succ");
   TT (agg_H, T_ENTER);

   sos_Bool result = get_m(_OBSThis).to_succ (c, steps);
 
   TT (agg_H, T_LEAVE);
   return result;
} // ** to_succ**

// **************************************************************************
sos_Bool _sos_Object_Set::to_pred (const sos_Typed_id&_OBSThis,OBST_PARDECL(sos_Cursor) c, sos_Int steps)
// **************************************************************************
const{  T_PROC ("sos_Object_Set::to_pred");
   TT (agg_H, T_ENTER);

   sos_Bool result = get_m(_OBSThis).to_pred (c, steps);
   
   TT (agg_H, T_LEAVE);
   return result;
} // ** to_pred **
