#ifndef _CCI_INCRLOAD_H
#define _CCI_INCRLOAD_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
typedef void (*cci_Xtor_p)();

class cci_XtorList
{ public:
   void init()  { card = 0; size = 0; }
   void fini()  { if (list) delete list; }
   void clear()	{ card = 0; }

   void add     (cci_Xtor_p);
   void process	(sos_Bool reverse);

  private:
   cci_Xtor_p* list;
   int	       size, card;
};

class cci_IncrLd
{ public:
   const char   *initial_wd,  // current working directory at startup 
	        *executable,  // name of running executable
	        *ld_param1,   // first additional parameter for load mechanism
	        *ld_params,   // remaining parameter(s) for load mechanism
		*searchpath,  // ":"-separated list of paths in `searchpaths'
	        **searchpaths;// string array of search paths (NULL terminated)
   char		*tmpf1,	      // name of temporary files which will be removed
		*tmpf2;	      // at process end - if defined
   sos_String   ld_context;   // context for accessing schema dependency lists
   sos_Bool     echo;	      // flag: echo files to be loaded

   cci_XtorList dtors;	      // destructors of loaded modules

   void init (char*[]);
   void final_init ();
   void fini ();

   int  find_file (smg_String&, sos_Bool = TRUE);
};

typedef void cci_LoadFct (const sos_Object_List&,
			  const sos_String_List&, const sos_String_List&);

// --------------------------------------------------------------------------

extern cci_IncrLd   cci_incr_ld;
extern cci_LoadFct* cci_load_fct;

/*
 * The following implicit initializations are employed:
 *	tmpf1 = tmpf2 = executable = NULL;
 *	dtors: size = card = 0;
 *
 *	cci_load_fct = NULL;
 */

#endif
