 /* --------------------------------------------------------------------------
  * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
  *
  * You can use and distribute this software under the terms of the license
  * version 1 you should have received along with this software.
  * If not or if you want additional information, write to
  * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
  * D-76131 Karlsruhe, Germany.
  * --------------------------------------------------------------------------
  */
%{

#define OBST_IMP_FORMATTED_IO
#include "obst_stdinc.h"

extern "C"
{
#ifndef FLEX_SCANNER 
#ifdef HAVE_YYWRAP
extern int     yywrap();
#endif
#endif

static int     yylook();
extern int     yyback(int*, int);
extern YYSTYPE yylval;
static void    yyecho();
}

static int name_or_keyword ()
{  switch (yytext[0])
   {  case 'a':
         if (streql (yytext, "abstract")) return abstract_tok;
	 break;
      case 'c':
         if (streql (yytext, "class")) return class_tok;
	 break;
      case 'd':
         if (streql (yytext, "definite")) return definite_tok;
	 break;
      case 'e':
         if (streql (yytext, "enum")) return enum_tok;
         if (streql (yytext, "extern")) return extern_tok;
	 break;
      case 'f':
         if (streql (yytext, "friend")) return friend_tok;
	 break;
      case 'l':
         if (streql (yytext, "local")) return local_tok;
	 break;
      case 'o':
         if (streql (yytext, "operator")) return operator_tok;
	 break;
      case 'p':
         if (streql (yytext, "private")) return private_tok;
         if (streql (yytext, "protected")) return protected_tok;
         if (streql (yytext, "public")) return public_tok;
	 break;
      case 's':
         if (streql (yytext, "set")) return set_tok;
         if (streql (yytext, "schema")) return schema_tok;
         if (streql (yytext, "static")) return static_tok;
	 break;
      case 't':
         if (streql (yytext, "typedef")) return typedef_tok;
	 break;
      case 'u':
         if (streql (yytext, "union")) return union_tok;
	 break;
      case 'w':
         if (streql (yytext, "with")) return with_tok;
	 break;
      default:
	 break;
   }
   return name_tok;
}

%}

letter	   ([a-zA-Z_])
digit	   ([0-9])
diglet	   ([a-zA-Z_0-9])
whitespace ([ \014\n\r\t])

%START comment
%%

"/*"			{yyecho(); BEGIN comment;}
<comment>[^\n*]*\n	{yyecho();}
<comment>[^\n*]*"*/"	{yyecho(); BEGIN 0;}
<comment>[^\n*]*"*"	{yymore();}

"//"[^\n]*\n		{yyecho();}

"<"			{yyecho(); return l_abr_tok;}
">"			{yyecho(); return r_abr_tok;}
"&"			{yyecho(); return ampersand_tok;}
"&="			{yyecho(); return ampersand_assign_tok;}
"&&"			{yyecho(); return and_tok;}
"="			{yyecho(); return assign_tok;}
"|"			{yyecho(); return bar_tok;}
"|="			{yyecho(); return bar_assign_tok;}
"["			{yyecho(); return l_br_tok;}
"]"			{yyecho(); return r_br_tok;}
"{"			{yyecho(); return l_brc_tok;}
"}"			{yyecho(); return r_brc_tok;}
"^"			{yyecho(); return circumflex_tok;}
"^="			{yyecho(); return circumflex_assign_tok;}
":"			{yyecho(); return colon_tok;}
","			{yyecho(); return comma_tok;}
"=="			{yyecho(); return equal_tok;}
">="			{yyecho(); return greater_equal_tok;}
"<="			{yyecho(); return less_equal_tok;}
"-"			{yyecho(); return minus_tok;}
"-="			{yyecho(); return minus_assign_tok;}
"!="			{yyecho(); return not_equal_tok;}
"||"			{yyecho(); return or_tok;}
"("			{yyecho(); return l_par_tok;}
")"			{yyecho(); return r_par_tok;}
"%"			{yyecho(); return percent_tok;}
"%="			{yyecho(); return percent_assign_tok;}
"+"			{yyecho(); return plus_tok;}
"+="			{yyecho(); return plus_assign_tok;}
">>="			{yyecho(); return rshift_assign_tok;}
"<<="			{yyecho(); return lshift_assign_tok;}
"/"			{yyecho(); return slash_tok;}
"/="			{yyecho(); return slash_assign_tok;}
"*"			{yyecho(); return star_tok;}
"*="			{yyecho(); return star_assign_tok;}
";"			{yyecho(); return semicolon_tok;}
"!"			{yyecho(); return exclam_tok;}
{digit}+		{yyecho();
			 yylval.i = atoi (yytext);
			 return number_tok;}
{letter}{diglet}*	{yyecho();
			 int tok = name_or_keyword();
			 if (tok == name_tok)
			 {  yylval.s = new char[yyleng+1];
			    strcpy (yylval.s, yytext);
			 }
			 return tok;}
{whitespace}		{yyecho();}
.			{yyecho(); cfe_error (err_USE, err_CFE_LEXICAL_ERROR);}
