#ifndef _OBST_STATS_H
#define _OBST_STATS_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

typedef struct
{  int occurences;		/* number of times this 'data' occurs	*/
   int data;			/* counted data entry			*/
} obst_histentry;

typedef struct
{  char*	   descr;	/* name of hash table (must not be freed)    */
   int		   buckets;	/* number of hash buckets		     */
   int		   histsize;	/* size of 'histogram' array		     */
   obst_histentry* histogram;   /* histogram of bucket sizes (must be freed) */
} obst_htabinfo;

typedef struct
{  obst_htabinfo*  htabs;	/* array of hash table statistics	*/
   int		   size;	/* size of 'htabs'			*/
} obst_htabstat;

/*
 * Builds up the histogram array '*h' of size '*size' by counting the
 * occurences of 'data' values.
 * The array is dynamically allocated and should be freed by the caller.
 * The first call must be done with '*size == 0'.
 * The array will be ordered by ascending 'data' values.
 */
extern void obst_add_histdata __FSIG_((obst_histentry** h, int* sz, int data));

/*
 * Adds an entry to the 'htabs' field and returns it. This entry will be
 * dynamically allocated.
 *
 * WARNING: Existing pointers into the 'htabs' field will in general become
 *	    invalid.
 */
extern obst_htabinfo* obst_add_htabinfo __FSIG_((obst_htabstat*));

/*
 * Frees the space associated with the given statistics array which must have
 * been built up via the _obst_add* functions.
 * 'htstat->size' must be 0 for the first call.
 */
extern void obst_free_htabstat __FSIG_((obst_htabstat* htstat));

/*
 * Collects the available hash table statistics, 'htstat' is fully initialized.
 */
extern void obst_collect_stats __FSIG_((obst_htabstat* htstat));
extern void _cci_collect_stats __FSIG_((obst_htabstat*));
#endif
