%{
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 * SCP PARSER: J. Uhl, D. Theobald, C. Zenger
 * --------------------------------------------------------------------------
 */
%}
%token char_tok
%token comma_tok
%token dot_tok
%token double_colon_tok
%token equal_tok
%token l_br_tok
%token l_brc_tok
%token l_par_tok
%token name_tok
%token number_tok
%token operator_string_tok
%token operator_tok
%token r_br_tok
%token r_brc_tok
%token r_par_tok
%token self_tok
%token semi_colon_tok
%token special_tok
%token string_tok
%token white_space_tok

%type <c> char_tok
%type <c> comma_tok
%type <c> dot_tok
%type <c> double_colon_tok
%type <c> equal_tok
%type <c> l_br_tok
%type <c> l_brc_tok
%type <c> l_par_tok
%type <c> name_tok
%type <c> number_tok
%type <c> operator_string_tok
%type <c> operator_tok
%type <c> r_br_tok
%type <c> r_brc_tok
%type <c> r_par_tok
%type <c> self_tok
%type <c> semi_colon_tok
%type <c> special_tok
%type <c> string_tok
%type <c> white_space_tok

%type <s> dot
%type <s> dot_begin
%type <s> dot_rest
%type <s> item
%type <s> l_par
%type <s> name
%type <s> name_begin
%type <s> name_dc
%type <s> name_or_operator_lp
%type <s> name_rest
%type <s> paritems
%type <s> paritems_rpar
%type <s> operator
%type <s> operator_string
%type <s> other_begin
%type <s> self
%type <s> self_begin
%type <s> self_dot
%type <s> self_rest
%type <s> special
%type <s> white_space
%type <s> white_spaces

%{

#define OBST_IMP_STRINGOP
#define OBST_IMP_MALLOC
#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "_obst_config.h"
#include "obst_progstd.h"
#include "smg.h"
#include "scp_err.h"
#include "mta_use.h"
#include "cci_use.h"
#include "scp_yacc.h"

/* ---------------------------------------------------------------------------
 * error handling
 */

extern int	yylineno;
EXPORT sos_Bool scp_do_warnings;	// initialized in 'main'

LOCAL void do_error (err_class kind, char *what)
{  char where[15];
   sprintf (where, "line %d", yylineno);
   err_raise (kind, what, where);
}

inline LOCAL void sys_err (char *what)
{  do_error (err_SYS, what);
}

inline LOCAL void usage_err (char *what)
{  do_error (err_USE, what);
}

inline LOCAL void warning (char *what)
{  if (scp_do_warnings)
      do_error (err_WNG, what);
}

/* ---------------------------------------------------------------------------
 * class for manipulating strings and string lists
 */

class strings;
LOCAL ostream& operator<< (ostream&, strings&);

class string_elem
{  char        *s;
   string_elem *next;

   friend class strings;
   friend ostream& operator<< (ostream&, strings&);
};

class strings
{  string_elem *first, *last;
public:
   static strings make ();
   static strings make (char*);

   void	    _init () { first = NULL; last = NULL; }

   char*&   operator[](int);
   strings& operator+ (const strings&);
   void     clear ();

   void	    prepend_str (char*);

   friend ostream& operator<< (ostream&, strings&);
};

// ---------------

strings strings::make ()
{  strings result;
   result._init();
   return result;
}

strings strings::make (char *s1)
{  strings result;
   result.first      = new string_elem;
   result.first->s   = s1;
   result.first->next= 0;
   result.last       = result.first;
   return result;
}

char*& strings::operator[] (int i)
{  for (string_elem *e = first;  i --; )
       e=e->next;
   return e->s;		// crash in case of empty list is intended!
}

strings& strings::operator+ (const strings &s1)
{  if (s1.first != NULL)
   {  if (first == NULL)
         first = s1.first;
      else
	 last->next = s1.first;
      last = s1.last;
   }
   return *this;
}

void strings::clear ()
{  string_elem *e_next;
   for (string_elem *e = first;  e;  e = e_next)
   {  e_next = e->next;
      if (e->s)
	 delete e->s;
      delete e;
   }
   _init();
}

void strings::prepend_str (char* s)
{  if (first)
      if (first->s)
      {  smg_String newstr = smg_String(s) + smg_String(first->s,SMG_TRANSFER);
	 first->s	   = newstr.make_Cstring (SMG_TRANSFER);
      }
      else
	 first->s	   = obst_strdup (s);
}

LOCAL ostream& operator<< (ostream& c, strings &s)
{  string_elem *e_next;

   for (string_elem *e = s.first;  e;  e = e_next)
   {  e_next = e->next;
      if (e->s)
      {  c << e->s;
	 delete e->s;
      }
      delete e;
   }
   c.flush();
   s._init();
   return c;
}

/* ---------------------------------------------------------------------------
 * for handling parameter lists
 */
  		     // (Note, that we can't store strings* here since such
 		     //  a pointer will be invalidated when the referenced
		     //  list gets appended to another list.)
struct pl_elem
{  strings prefix;   // prefix of parameter
   strings tpsuffix; // suffix of declaration of parameter type
};

struct pl_list
{  int count;	// number of parameters at this level
   int lineno;	// starting line of this list
};
   
static int	pl_maxlevels = 0;	// current size of list stack array
static int	pl_level     = -1;	// current list level
static pl_list* pl_stack     = NULL;	// array holding list stack

static int	pl_maxparams = 0;	// current size of param array
static pl_elem* pl_param     = NULL;	// info on parameter list at level 1
static int	pl_no_suffix = 0;	// tpsuffix not set for current param?

// ---------------

class ParamList
{
   static int  paramidx(int);
public:
   static void enter();
   static void leave() 	      { -- pl_level; }
   static void add();
   static int  add_prefix()   { return (pl_level == 0); }
   static int  add_tpsuffix() { register
				int result = (pl_level == 0 && pl_no_suffix);
				pl_no_suffix = 0;
				return result;
			      }

   static strings& prefix   (int idx = -1)
			      { return pl_param[paramidx(idx)].prefix; }
   static strings& tpsuffix (int idx = -1)
			      { return pl_param[paramidx(idx)].tpsuffix; }

   static int in_list()       { return (pl_level >= 0); }
   static int count() 	      { return pl_stack[pl_level + 1].count; }
   static int starting_line() { return pl_stack[pl_level].lineno; }
};

// ---------------

void ParamList::add()
{  if (pl_level >= 0)
   {  int i = pl_stack[pl_level].count ++;
      if (i < pl_maxparams)
      {  pl_param[i].prefix._init();
         pl_param[i].tpsuffix._init();
      }
   }
   pl_no_suffix = 1;
}

void ParamList::enter()
{  if (++pl_level == pl_maxlevels)
      if (pl_maxlevels)
         pl_stack = (pl_list*)REALLOC (pl_stack,
				       sizeof(pl_list) * (pl_maxlevels += 10));
      else
         pl_stack = new pl_list[pl_maxlevels = 10];

   pl_stack[pl_level].count  = 0;
   pl_stack[pl_level].lineno = yylineno;
}

int ParamList::paramidx (int idx)
{  // pl_level > 0 is a bracketing error in the input. We ignore this since
   // this is a syntax error detected elsewhere either by scp or during the
   // following compiler run.

   if (idx < 0  OR  pl_level > 0)
      idx = pl_stack[0].count - 1;	// last current param

   if (idx >= pl_maxparams)
   {  int i = pl_maxparams;

      if (pl_maxparams)
         pl_param = (pl_elem*)REALLOC (pl_param,
				       sizeof(pl_elem) * (pl_maxparams += 10));
      else
         pl_param = new pl_elem[pl_maxparams = 10];

      err_assert(idx < pl_maxparams, "scp - ParamList::paramidx: growth > 1!");

      do
      {	 pl_param[i].prefix._init();
         pl_param[i].tpsuffix._init();
      }
      while (++i < pl_maxparams);
   }
   return idx;
}


/* ---------------------------------------------------------------------------
 * global variables for scp
 */

LOCAL char*    class_name_of_method = 0;
				   // in implementation of method `...`, 
				   // 0 means outside of method-implementation

LOCAL sos_Bool global_var_init = FALSE; 
				   // in initialization of a global variable

LOCAL int      nesting = 0;     // nesting level of curly brackets
LOCAL sos_Bool is_operator;	   // last 'name_or_operator_lp' was operator


/* The following variables are initialized in main(). */

EXPORT sos_Schema_module scp_mdl;  // current schema

EXPORT sos_Bool 	 force_indirect_call;
	// TRUE --> all method calls via 'static type'-class 
	// FALSE -> optimization (direct calls to implementation class) allowed

/* ---------------------------------------------------------------------------
 * yacc interface
 */

typedef union
{  strings s;
   char*   c;
} _YYSTYPE;
#define YYSTYPE _YYSTYPE

LOCAL void yyerror (char *what)
{  smg_String error = what;

   if (error.equal ("syntax error") AND ParamList::in_list())
      error += smg_String(" (possibly missing match for '(' in line ")
	       + ParamList::starting_line() + ")";

   usage_err (error.make_Cstring (SMG_BORROW));
}

/* ---------------------------------------------------------------------------
 * interface to meta database
 */

LOCAL sos_Class_type get_obst_class (char *cname)
{
   sos_String     cn = sos_String::create (TEMP_CONTAINER, cname);
   sos_Type_descr td = scp_mdl.lookup_type (cn);
   sos_Type       tp;
   cn.destroy();

   if (td != NO_OBJECT  AND  NOT (tp = td.make_type()).is_scalar())
      return sos_Class_type::make(tp);
   else
      return sos_Class_type::make(NO_OBJECT);
}

LOCAL sos_Bool get_method_attributes
			       (sos_Class_type ct,
				char *mname, int paramcount,
			        sos_Bool       &is_static,
				sos_Bool       &is_protected,
				sos_Bool       &call_indirect,
				sos_Bool       &maybe_attrset,
				sos_Param_List &params)
{  static sos_Type vtp = _obst_knl_type (_THE_VOID_TYPE);

   sos_String      mn  = sos_String::create (TEMP_CONTAINER, mname);
   sos_Method_List ml  = ct.get_methods()[mn];
   mn.destroy();
   if (ml == NO_OBJECT) return FALSE;

   sos_Method best_match;
   int	      best_pcnt = 9999;
   agg_iterate (ml, sos_Method m)
      params = m.get_params();
      int pcnt = (params == NO_OBJECT) ? 0
				       : params.card();
      if (paramcount <= pcnt AND pcnt < best_pcnt)
      {  best_match = m;
	 if ((best_pcnt = pcnt) EQ paramcount) break;
      }
   agg_iterate_end (ml, m);

   if (best_pcnt EQ 9999) return FALSE;

   // *** a complete lookup requires a check for default paramters
   //	  in the case 'best_pcnt != paramcount'

   is_static    = best_match.get_is_static();
   is_protected = (sos_Bool)(best_match.get_kind() EQ sos_PROTECTED);
   call_indirect= (sos_Bool)(
		   best_match.get_is_generated()
		   AND (   streql (mname, "create")
		        OR streql (mname, "copy") OR streql (mname, "clone")));
   maybe_attrset= (sos_Bool)(
		   NOT(   is_static
		       OR paramcount != 1
		       OR NOT streqln ("set_", mname, 4)
		       OR best_match.get_result_type().make_type() != vtp));
   return TRUE;
}

/* ---------------------------------------------------------------------------
 * various substitutions
 */

LOCAL strings& operator_replacement (strings &op_stuff)
{
   op_stuff[0][0] = '\0';

   sos_String mn = sos_String::create (TEMP_CONTAINER, op_stuff[1]);
   sos_String on = cci_Method_impl::operator_string (mn);

   if (op_stuff[1])
      delete op_stuff[1];
   op_stuff[1] = on.make_Cstring();

   on.destroy();
   mn.destroy();

   return op_stuff;
}

LOCAL void this_parameter (strings &name_lp, int paramcount, sos_Bool is_op)
{
   if (is_op)
      operator_replacement (name_lp);

   if (nesting == 0)
      name_lp = name_lp
	        + strings::make(obst_strdup ("const sos_Typed_id&_OBSThis"));
   else
      name_lp = name_lp + strings::make(obst_strdup ("_OBSThis"));

   if (paramcount > 0)
      name_lp = name_lp + strings::make(obst_strdup (","));
}

LOCAL strings& self_replacement (strings &self_stuff)
{
   if (class_name_of_method != 0)
   {  if (self_stuff[0])
	 delete self_stuff[0];

      self_stuff[0] = obst_strdup ("::make(_OBSThis,this)");
      self_stuff    = strings::make(obst_strdup (class_name_of_method))
	 	      + self_stuff;
   }
   return self_stuff;
}

LOCAL void impl_method (strings &class_dc,
			strings &name_lp,
		  	int paramcount,
			sos_Bool is_op,
			sos_Bool is_static)
{
   class_dc = strings::make (obst_strdup ("_")) + class_dc;
   if (is_op OR NOT is_static)
      this_parameter (name_lp, paramcount, is_op);
}

void method_decl (strings &class_dc, strings &name_lp, strings &paritems_rpar,
		  int paramcount,
		  sos_Bool is_op, sos_Bool is_static, sos_Bool maybe_attrset,
		  sos_Param_List &params)
{  class_dc = strings::make (obst_strdup ("_")) + class_dc;
   if (is_op OR NOT is_static)
   {  this_parameter (name_lp, paramcount, is_op);
      if (NOT is_static)
         paritems_rpar = paritems_rpar + strings::make (obst_strdup ("const"));
   }
   if (paramcount)
   {  if (is_op)
	 maybe_attrset = FALSE;

      int idx = 0;
      agg_iterate (params, sos_Param p)
	 if (NOT p.get_is_ref())
         {  sos_Type ptp = p.get_type().make_type();

	    if (ptp == sos_Float_type)
	    {  ParamList::prefix  (idx).prepend_str ("_OBST_FLOATDECL(");
	       ParamList::tpsuffix(idx).prepend_str (")");
	    }
	    else if (maybe_attrset OR NOT ptp.is_scalar())
	    {  ParamList::prefix  (idx).prepend_str ("OBST_PARDECL(");
	       ParamList::tpsuffix(idx).prepend_str (")");
	    }
         }
         ++ idx;
      agg_iterate_end (params, p);
   }
}

LOCAL sos_Bool cplusplus_shortcut (strings &name_lp, int paramcount)
{  char* mname = name_lp[0];

   if (paramcount != 0)
      return FALSE;

   char *prefix = "_OBSThis.";

   if (streql(mname, "container") OR streql(mname, "offset"))
      ;					// self.<m>() --> _OBSThis.<m>()
   else if (streql(mname, "_typed_id"))
   {  name_lp.clear();			// self.<m>() --> (_OBSThis)
      prefix = "(_OBSThis";
   }
   else if (streql(mname, "_self_id"))
   {  delete mname;			// self.<m>() --> _OBSThis.get_id()
      name_lp[0] = obst_strdup("get_id");
   }
   else if (streql(mname, "_type_id"))
   {  delete mname;			// self.<m>() --> _OBSThis.get_tp()
      name_lp[0] = obst_strdup("get_tp");
   }
   else if (streql(mname, "_size"))
      prefix = "";			// self.<m>() --> <m>()
   else
      return FALSE;
   
   name_lp = strings::make(obst_strdup (prefix)) + name_lp;
   return TRUE;
}

/* ---------------------------------------------------------------------------
 * decisions on substitutions follow
 */

LOCAL strings& qualified_method
			(strings &class_dc, strings &name_lp, 
			 strings &paritems_rpar, int paramcount)
{
   sos_Bool       is_static, is_protected, call_indirect, maybe_attrset;
   char*	  mname = (is_operator) ? name_lp[1] : name_lp[0];
   sos_Class_type ct    = get_obst_class (class_dc[0]);
   sos_Param_List pl;

   if (ct != NO_OBJECT
       AND get_method_attributes (ct, mname,     paramcount,
				  is_static,     is_protected, call_indirect,
				  maybe_attrset, pl))
   {
     if (global_var_init)		// * global variable initialization
	;
     else if (nesting == 0)    		// * definition header of OBST method
     {
	class_name_of_method = obst_strdup (class_dc[0]);
	method_decl (class_dc, name_lp, paritems_rpar, paramcount, 
		     is_operator, is_static, maybe_attrset, pl);
     }
     else if (class_name_of_method)	// * qualified method call, not to self
     {
	if (NOT is_static)
	   usage_err ("qualified call, on an object different from self");

	else				// * qualified static method call
	{
	   if (call_indirect OR force_indirect_call)
	   {  if (is_protected)		// * no optimization allowed
	         usage_err ("qualified call of protected static method "
			    "only when optimizing");
	      else
		 ;
	   }
	   else                  	// * optimization allowed
	   {  impl_method (class_dc, name_lp,
			   paramcount, is_operator, is_static);
 
	      if (is_protected)		// * possible incompatibility
		 warning ("qualified call of protected static method "
			  "only when optimizing");
	   }
	}
     } // if (class_name_of_method)
  } // if (ct...)
  return (class_dc + name_lp);
}

inline LOCAL strings& unqualified_call (strings &name_lp, int)
{
   // There are currently no substitutions for these methods
   // (a candidate might be e.g. a shortcut implementation for 'container()').

   return name_lp;
}

LOCAL
strings& self_qualified_call (strings &self_dot, strings &class_dc,
			      strings &name_lp, int paramcount)
{
   if (get_obst_class (class_dc[0]) != NO_OBJECT)
   {
      if (nesting == 0)			// * self in global context
	 ;
      else if (class_name_of_method == 0)// * not in OBST method implementation
	 ;
      else if (force_indirect_call)	// * no optimization allowed
	 usage_err ("qualified call on self only when optimizing");
      else
      {					// * possible incompatibility
	 warning ("qualified call on self only when optimizing");

	 // The substitution is wrong if name_lp has a C++ shortcut.

	 impl_method (class_dc, name_lp, paramcount, is_operator, FALSE);
	 self_dot.clear();		// throw away self_dot
      }
   }
   return (self_dot + class_dc + name_lp);
}

LOCAL
strings& self_unqualified_call (strings &self_dot,
				strings &name_lp, int paramcount)
{
   if (class_name_of_method == 0)	// * not in SOS method implementation
      ;
   else if (force_indirect_call)	// * no optimization allowed
      if (cplusplus_shortcut (name_lp, paramcount))
	 self_dot.clear();
      else
	 self_replacement (self_dot);
   else					// * optimization allowed
   {  if (NOT cplusplus_shortcut (name_lp, paramcount))
	 this_parameter (name_lp, paramcount, is_operator);
      self_dot.clear();
   }
   return (self_dot + name_lp);
}

/* ---------------------------------------------------------------------------
 * yacc-grammar (note: default action is '$$ = $1;')
 */
%}

%%

items
   : white_space { cout << $1; }
   | items item  { cout << $2; }
   ;

item
   : name_begin
   | dot_begin
   | self_begin
   | other_begin
   ;

name_begin 
   : name_dc name_or_operator_lp paritems_rpar
     { 
        $$ = qualified_method ($1, $2, $3, ParamList::count()) + $3;
     }
   | name_rest
   ;

dot_begin
   : dot name_dc name_or_operator_lp paritems_rpar
     {
	$$ = $1 + qualified_method ($2, $3, $4, ParamList::count()) + $4;
     }
   | dot name_or_operator_lp paritems_rpar
     {
	$$ = $1 + unqualified_call ($2, ParamList::count()) + $3;
     }
   | dot_rest
   ;

self_begin 
   : self_dot name_dc name_or_operator_lp paritems_rpar
     { 
        $$ = self_qualified_call ($1, $2, $3, ParamList::count()) + $4;
     }
   | self_dot name_or_operator_lp paritems_rpar
     {
        $$ = self_unqualified_call ($1, $2, ParamList::count()) + $3;
     }
   | self_rest
     {
        $$ = self_replacement ($1);
     }
   ;

paritems_rpar
   : r_par_tok white_space
     {
	$$ = strings::make($1) + $2;
	ParamList::leave();
     }
   | {
	ParamList::add();
     }
     paritems r_par_tok white_space
     {
     	$$ = $2 + strings::make($3) + $4;

	if (ParamList::add_prefix())
   	   ParamList::prefix(0) = $$;
	ParamList::leave();
     }
   ;

paritems
   : item
   | paritems item { $$ = $1 + $2; }
   ;

name_rest
   : name_dc name     { $$ = $1 + $2; }
   | name_dc operator { $$ = $1 + $2; }
   | name_dc
   | name
   ;

dot_rest
   : dot name_rest { $$ = $1 + $2; }
   | dot operator  { $$ = $1 + $2; }
   | dot
   ;

self_rest
   : self_dot name_rest { $$ = $1 + $2; }
   | self_dot operator  { $$ = $1 + $2; }
   | self_dot
   | self
   ;

name_or_operator_lp
   : name     l_par { is_operator = FALSE; $$ = $1 + $2; }
   | operator l_par { is_operator = TRUE;  $$ = $1 + $2; }
   ;

name_dc
   : name double_colon_tok white_space { $$ = $1 + strings::make($2) + $3; }
   ;

name 
   : name_tok white_space
     {
	if (ParamList::add_tpsuffix())
	{  ParamList::tpsuffix() = strings::make(NULL);

	   $$ = strings::make($1) + ParamList::tpsuffix() + $2;
	}
	else
	   $$ = strings::make($1) + $2;
     }
   ;

self_dot 
   : self dot		  { $$ = $1 + $2; }
   ;

self
   : self_tok white_space { $$ = strings::make($1) + $2; }
   ;

dot: dot_tok  white_space { $$ = strings::make($1) + $2; }
   ;

operator 
   : operator_tok white_space operator_string
     { 
	$$ = strings::make($1) + $3 + $2; 
     }
   ;

operator_string 
   : operator_string_tok white_space { $$ = strings::make($1) + $2; }
   | equal_tok 		 white_space { $$ = strings::make($1) + $2; }
   | name_tok 		 white_space { $$ = strings::make($1) + $2; }
   | special_tok 	 white_space { $$ = strings::make($1) + $2; }
   | l_par_tok white_space r_par_tok white_space
     {  
	$$ = strings::make (obst_strdup ("()")) + $2 + $4; // simplify operator
	delete $1;					   // for replacement
	delete $3;
     }
   | l_br_tok white_space r_br_tok white_space
     {  
	$$ = strings::make (obst_strdup ("[]")) + $2 + $4; // simplify operator
	delete $1;					   // for replacement
	delete $3;
     }
   ;

l_par
   : l_par_tok
     {
	ParamList::enter();
     }
     white_space
     {
	$$ = strings::make($1) + $3;	// the {}-part is counted as #2
     }
   ;

other_begin
   : operator
   | l_par paritems_rpar	     { $$ = $1 + $2; }
   | char_tok 	         white_space { $$ = strings::make($1) + $2; }
   | double_colon_tok    white_space { $$ = strings::make($1) + $2; }
   | l_br_tok 	         white_space { $$ = strings::make($1) + $2; }
   | number_tok          white_space { $$ = strings::make($1) + $2; }
   | operator_string_tok white_space { $$ = strings::make($1) + $2; }
   | r_br_tok 	         white_space { $$ = strings::make($1) + $2; }
   | special 	         white_space { $$ = $1 + $2; } 
   | special_tok         white_space { $$ = strings::make($1) + $2; }
   | string_tok          white_space { $$ = strings::make($1) + $2; }
   ;

special
   : comma_tok
     {  
	$$ = strings::make($1);

	ParamList::add();
	if (ParamList::add_prefix())
	{  ParamList::prefix() = strings::make(NULL);
	   $$ = $$ + ParamList::prefix();
	}
     }
   | equal_tok
     {  
        if (nesting == 0  AND  NOT ParamList::in_list())
	   global_var_init = TRUE;
        $$ = strings::make($1);
     }
   | semi_colon_tok
     { 
        global_var_init = FALSE;
        $$ = strings::make($1);
     }
   | l_brc_tok
     {
	nesting ++;
	$$ = strings::make($1);
     }
   | r_brc_tok
     {
	if (--nesting <= 0)
	{  delete class_name_of_method;
	   class_name_of_method = 0;
	   nesting = 0;
	}
	$$ = strings::make($1);
     }
   ;

white_space
   : 		  { $$ = strings::make(); }
   | white_spaces
   ;

white_spaces
   : 		  white_space_tok { $$ =      strings::make($1); }
   | white_spaces white_space_tok { $$ = $1 + strings::make($2); }
   ;

%%

#include "scp_lex.h"
