
#define yylineno scp_yylineno
#define yyin scp_yyin
#define yyreds scp_yyreds
#define yyout scp_yyout
#define yyparse scp_yyparse
#define yylex scp_yylex
#define yyerror scp_yyerror
#define YY_DECL scp_YY_DECL
#define yylval scp_yylval
#define yyval scp_yyval
#define yys scp_yys
#define yyv scp_yyv
#define yypv scp_yypv

# line 2 "src/scp/scp.y"
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 * SCP PARSER: J. Uhl, D. Theobald, C. Zenger
 * --------------------------------------------------------------------------
 */
# define char_tok 257
# define comma_tok 258
# define dot_tok 259
# define double_colon_tok 260
# define equal_tok 261
# define l_br_tok 262
# define l_brc_tok 263
# define l_par_tok 264
# define name_tok 265
# define number_tok 266
# define operator_string_tok 267
# define operator_tok 268
# define r_br_tok 269
# define r_brc_tok 270
# define r_par_tok 271
# define self_tok 272
# define semi_colon_tok 273
# define special_tok 274
# define string_tok 275
# define white_space_tok 276

# line 81 "src/scp/scp.y"

#define OBST_IMP_STRINGOP
#define OBST_IMP_MALLOC
#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "_obst_config.h"
#include "obst_progstd.h"
#include "smg.h"
#include "scp_err.h"
#include "mta_use.h"
#include "cci_use.h"
#include "scp_yacc.h"

/* ---------------------------------------------------------------------------
 * error handling
 */

extern int	yylineno;
EXPORT sos_Bool scp_do_warnings;	// initialized in 'main'

LOCAL void do_error (err_class kind, char *what)
{  char where[15];
   sprintf (where, "line %d", yylineno);
   err_raise (kind, what, where);
}

inline LOCAL void sys_err (char *what)
{  do_error (err_SYS, what);
}

inline LOCAL void usage_err (char *what)
{  do_error (err_USE, what);
}

inline LOCAL void warning (char *what)
{  if (scp_do_warnings)
      do_error (err_WNG, what);
}

/* ---------------------------------------------------------------------------
 * class for manipulating strings and string lists
 */

class strings;
LOCAL ostream& operator<< (ostream&, strings&);

class string_elem
{  char        *s;
   string_elem *next;

   friend class strings;
   friend ostream& operator<< (ostream&, strings&);
};

class strings
{  string_elem *first, *last;
public:
   static strings make ();
   static strings make (char*);

   void	    _init () { first = NULL; last = NULL; }

   char*&   operator[](int);
   strings& operator+ (const strings&);
   void     clear ();

   void	    prepend_str (char*);

   friend ostream& operator<< (ostream&, strings&);
};

// ---------------

strings strings::make ()
{  strings result;
   result._init();
   return result;
}

strings strings::make (char *s1)
{  strings result;
   result.first      = new string_elem;
   result.first->s   = s1;
   result.first->next= 0;
   result.last       = result.first;
   return result;
}

char*& strings::operator[] (int i)
{  for (string_elem *e = first;  i --; )
       e=e->next;
   return e->s;		// crash in case of empty list is intended!
}

strings& strings::operator+ (const strings &s1)
{  if (s1.first != NULL)
   {  if (first == NULL)
         first = s1.first;
      else
	 last->next = s1.first;
      last = s1.last;
   }
   return *this;
}

void strings::clear ()
{  string_elem *e_next;
   for (string_elem *e = first;  e;  e = e_next)
   {  e_next = e->next;
      if (e->s)
	 delete e->s;
      delete e;
   }
   _init();
}

void strings::prepend_str (char* s)
{  if (first)
      if (first->s)
      {  smg_String newstr = smg_String(s) + smg_String(first->s,SMG_TRANSFER);
	 first->s	   = newstr.make_Cstring (SMG_TRANSFER);
      }
      else
	 first->s	   = obst_strdup (s);
}

LOCAL ostream& operator<< (ostream& c, strings &s)
{  string_elem *e_next;

   for (string_elem *e = s.first;  e;  e = e_next)
   {  e_next = e->next;
      if (e->s)
      {  c << e->s;
	 delete e->s;
      }
      delete e;
   }
   c.flush();
   s._init();
   return c;
}

/* ---------------------------------------------------------------------------
 * for handling parameter lists
 */
  		     // (Note, that we can't store strings* here since such
 		     //  a pointer will be invalidated when the referenced
		     //  list gets appended to another list.)
struct pl_elem
{  strings prefix;   // prefix of parameter
   strings tpsuffix; // suffix of declaration of parameter type
};

struct pl_list
{  int count;	// number of parameters at this level
   int lineno;	// starting line of this list
};
   
static int	pl_maxlevels = 0;	// current size of list stack array
static int	pl_level     = -1;	// current list level
static pl_list* pl_stack     = NULL;	// array holding list stack

static int	pl_maxparams = 0;	// current size of param array
static pl_elem* pl_param     = NULL;	// info on parameter list at level 1
static int	pl_no_suffix = 0;	// tpsuffix not set for current param?

// ---------------

class ParamList
{
   static int  paramidx(int);
public:
   static void enter();
   static void leave() 	      { -- pl_level; }
   static void add();
   static int  add_prefix()   { return (pl_level == 0); }
   static int  add_tpsuffix() { register
				int result = (pl_level == 0 && pl_no_suffix);
				pl_no_suffix = 0;
				return result;
			      }

   static strings& prefix   (int idx = -1)
			      { return pl_param[paramidx(idx)].prefix; }
   static strings& tpsuffix (int idx = -1)
			      { return pl_param[paramidx(idx)].tpsuffix; }

   static int in_list()       { return (pl_level >= 0); }
   static int count() 	      { return pl_stack[pl_level + 1].count; }
   static int starting_line() { return pl_stack[pl_level].lineno; }
};

// ---------------

void ParamList::add()
{  if (pl_level >= 0)
   {  int i = pl_stack[pl_level].count ++;
      if (i < pl_maxparams)
      {  pl_param[i].prefix._init();
         pl_param[i].tpsuffix._init();
      }
   }
   pl_no_suffix = 1;
}

void ParamList::enter()
{  if (++pl_level == pl_maxlevels)
      if (pl_maxlevels)
         pl_stack = (pl_list*)REALLOC (pl_stack,
				       sizeof(pl_list) * (pl_maxlevels += 10));
      else
         pl_stack = new pl_list[pl_maxlevels = 10];

   pl_stack[pl_level].count  = 0;
   pl_stack[pl_level].lineno = yylineno;
}

int ParamList::paramidx (int idx)
{  // pl_level > 0 is a bracketing error in the input. We ignore this since
   // this is a syntax error detected elsewhere either by scp or during the
   // following compiler run.

   if (idx < 0  OR  pl_level > 0)
      idx = pl_stack[0].count - 1;	// last current param

   if (idx >= pl_maxparams)
   {  int i = pl_maxparams;

      if (pl_maxparams)
         pl_param = (pl_elem*)REALLOC (pl_param,
				       sizeof(pl_elem) * (pl_maxparams += 10));
      else
         pl_param = new pl_elem[pl_maxparams = 10];

      err_assert(idx < pl_maxparams, "scp - ParamList::paramidx: growth > 1!");

      do
      {	 pl_param[i].prefix._init();
         pl_param[i].tpsuffix._init();
      }
      while (++i < pl_maxparams);
   }
   return idx;
}


/* ---------------------------------------------------------------------------
 * global variables for scp
 */

LOCAL char*    class_name_of_method = 0;
				   // in implementation of method `...`, 
				   // 0 means outside of method-implementation

LOCAL sos_Bool global_var_init = FALSE; 
				   // in initialization of a global variable

LOCAL int      nesting = 0;     // nesting level of curly brackets
LOCAL sos_Bool is_operator;	   // last 'name_or_operator_lp' was operator


/* The following variables are initialized in main(). */

EXPORT sos_Schema_module scp_mdl;  // current schema

EXPORT sos_Bool 	 force_indirect_call;
	// TRUE --> all method calls via 'static type'-class 
	// FALSE -> optimization (direct calls to implementation class) allowed

/* ---------------------------------------------------------------------------
 * yacc interface
 */

typedef union
{  strings s;
   char*   c;
} _YYSTYPE;
#define YYSTYPE _YYSTYPE

LOCAL void yyerror (char *what)
{  smg_String error = what;

   if (error.equal ("syntax error") AND ParamList::in_list())
      error += smg_String(" (possibly missing match for '(' in line ")
	       + ParamList::starting_line() + ")";

   usage_err (error.make_Cstring (SMG_BORROW));
}

/* ---------------------------------------------------------------------------
 * interface to meta database
 */

LOCAL sos_Class_type get_obst_class (char *cname)
{
   sos_String     cn = sos_String::create (TEMP_CONTAINER, cname);
   sos_Type_descr td = scp_mdl.lookup_type (cn);
   sos_Type       tp;
   cn.destroy();

   if (td != NO_OBJECT  AND  NOT (tp = td.make_type()).is_scalar())
      return sos_Class_type::make(tp);
   else
      return sos_Class_type::make(NO_OBJECT);
}

LOCAL sos_Bool get_method_attributes
			       (sos_Class_type ct,
				char *mname, int paramcount,
			        sos_Bool       &is_static,
				sos_Bool       &is_protected,
				sos_Bool       &call_indirect,
				sos_Bool       &maybe_attrset,
				sos_Param_List &params)
{  static sos_Type vtp = _obst_knl_type (_THE_VOID_TYPE);

   sos_String      mn  = sos_String::create (TEMP_CONTAINER, mname);
   sos_Method_List ml  = ct.get_methods()[mn];
   mn.destroy();
   if (ml == NO_OBJECT) return FALSE;

   sos_Method best_match;
   int	      best_pcnt = 9999;
   agg_iterate (ml, sos_Method m)
      params = m.get_params();
      int pcnt = (params == NO_OBJECT) ? 0
				       : params.card();
      if (paramcount <= pcnt AND pcnt < best_pcnt)
      {  best_match = m;
	 if ((best_pcnt = pcnt) EQ paramcount) break;
      }
   agg_iterate_end (ml, m);

   if (best_pcnt EQ 9999) return FALSE;

   // *** a complete lookup requires a check for default paramters
   //	  in the case 'best_pcnt != paramcount'

   is_static    = best_match.get_is_static();
   is_protected = (sos_Bool)(best_match.get_kind() EQ sos_PROTECTED);
   call_indirect= (sos_Bool)(
		   best_match.get_is_generated()
		   AND (   streql (mname, "create")
		        OR streql (mname, "copy") OR streql (mname, "clone")));
   maybe_attrset= (sos_Bool)(
		   NOT(   is_static
		       OR paramcount != 1
		       OR NOT streqln ("set_", mname, 4)
		       OR best_match.get_result_type().make_type() != vtp));
   return TRUE;
}

/* ---------------------------------------------------------------------------
 * various substitutions
 */

LOCAL strings& operator_replacement (strings &op_stuff)
{
   op_stuff[0][0] = '\0';

   sos_String mn = sos_String::create (TEMP_CONTAINER, op_stuff[1]);
   sos_String on = cci_Method_impl::operator_string (mn);

   if (op_stuff[1])
      delete op_stuff[1];
   op_stuff[1] = on.make_Cstring();

   on.destroy();
   mn.destroy();

   return op_stuff;
}

LOCAL void this_parameter (strings &name_lp, int paramcount, sos_Bool is_op)
{
   if (is_op)
      operator_replacement (name_lp);

   if (nesting == 0)
      name_lp = name_lp
	        + strings::make(obst_strdup ("const sos_Typed_id&_OBSThis"));
   else
      name_lp = name_lp + strings::make(obst_strdup ("_OBSThis"));

   if (paramcount > 0)
      name_lp = name_lp + strings::make(obst_strdup (","));
}

LOCAL strings& self_replacement (strings &self_stuff)
{
   if (class_name_of_method != 0)
   {  if (self_stuff[0])
	 delete self_stuff[0];

      self_stuff[0] = obst_strdup ("::make(_OBSThis,this)");
      self_stuff    = strings::make(obst_strdup (class_name_of_method))
	 	      + self_stuff;
   }
   return self_stuff;
}

LOCAL void impl_method (strings &class_dc,
			strings &name_lp,
		  	int paramcount,
			sos_Bool is_op,
			sos_Bool is_static)
{
   class_dc = strings::make (obst_strdup ("_")) + class_dc;
   if (is_op OR NOT is_static)
      this_parameter (name_lp, paramcount, is_op);
}

void method_decl (strings &class_dc, strings &name_lp, strings &paritems_rpar,
		  int paramcount,
		  sos_Bool is_op, sos_Bool is_static, sos_Bool maybe_attrset,
		  sos_Param_List &params)
{  class_dc = strings::make (obst_strdup ("_")) + class_dc;
   if (is_op OR NOT is_static)
   {  this_parameter (name_lp, paramcount, is_op);
      if (NOT is_static)
         paritems_rpar = paritems_rpar + strings::make (obst_strdup ("const"));
   }
   if (paramcount)
   {  if (is_op)
	 maybe_attrset = FALSE;

      int idx = 0;
      agg_iterate (params, sos_Param p)
	 if (NOT p.get_is_ref())
         {  sos_Type ptp = p.get_type().make_type();

	    if (ptp == sos_Float_type)
	    {  ParamList::prefix  (idx).prepend_str ("_OBST_FLOATDECL(");
	       ParamList::tpsuffix(idx).prepend_str (")");
	    }
	    else if (maybe_attrset OR NOT ptp.is_scalar())
	    {  ParamList::prefix  (idx).prepend_str ("OBST_PARDECL(");
	       ParamList::tpsuffix(idx).prepend_str (")");
	    }
         }
         ++ idx;
      agg_iterate_end (params, p);
   }
}

LOCAL sos_Bool cplusplus_shortcut (strings &name_lp, int paramcount)
{  char* mname = name_lp[0];

   if (paramcount != 0)
      return FALSE;

   char *prefix = "_OBSThis.";

   if (streql(mname, "container") OR streql(mname, "offset"))
      ;					// self.<m>() --> _OBSThis.<m>()
   else if (streql(mname, "_typed_id"))
   {  name_lp.clear();			// self.<m>() --> (_OBSThis)
      prefix = "(_OBSThis";
   }
   else if (streql(mname, "_self_id"))
   {  delete mname;			// self.<m>() --> _OBSThis.get_id()
      name_lp[0] = obst_strdup("get_id");
   }
   else if (streql(mname, "_type_id"))
   {  delete mname;			// self.<m>() --> _OBSThis.get_tp()
      name_lp[0] = obst_strdup("get_tp");
   }
   else if (streql(mname, "_size"))
      prefix = "";			// self.<m>() --> <m>()
   else
      return FALSE;
   
   name_lp = strings::make(obst_strdup (prefix)) + name_lp;
   return TRUE;
}

/* ---------------------------------------------------------------------------
 * decisions on substitutions follow
 */

LOCAL strings& qualified_method
			(strings &class_dc, strings &name_lp, 
			 strings &paritems_rpar, int paramcount)
{
   sos_Bool       is_static, is_protected, call_indirect, maybe_attrset;
   char*	  mname = (is_operator) ? name_lp[1] : name_lp[0];
   sos_Class_type ct    = get_obst_class (class_dc[0]);
   sos_Param_List pl;

   if (ct != NO_OBJECT
       AND get_method_attributes (ct, mname,     paramcount,
				  is_static,     is_protected, call_indirect,
				  maybe_attrset, pl))
   {
     if (global_var_init)		// * global variable initialization
	;
     else if (nesting == 0)    		// * definition header of OBST method
     {
	class_name_of_method = obst_strdup (class_dc[0]);
	method_decl (class_dc, name_lp, paritems_rpar, paramcount, 
		     is_operator, is_static, maybe_attrset, pl);
     }
     else if (class_name_of_method)	// * qualified method call, not to self
     {
	if (NOT is_static)
	   usage_err ("qualified call, on an object different from self");

	else				// * qualified static method call
	{
	   if (call_indirect OR force_indirect_call)
	   {  if (is_protected)		// * no optimization allowed
	         usage_err ("qualified call of protected static method "
			    "only when optimizing");
	      else
		 ;
	   }
	   else                  	// * optimization allowed
	   {  impl_method (class_dc, name_lp,
			   paramcount, is_operator, is_static);
 
	      if (is_protected)		// * possible incompatibility
		 warning ("qualified call of protected static method "
			  "only when optimizing");
	   }
	}
     } // if (class_name_of_method)
  } // if (ct...)
  return (class_dc + name_lp);
}

inline LOCAL strings& unqualified_call (strings &name_lp, int)
{
   // There are currently no substitutions for these methods
   // (a candidate might be e.g. a shortcut implementation for 'container()').

   return name_lp;
}

LOCAL
strings& self_qualified_call (strings &self_dot, strings &class_dc,
			      strings &name_lp, int paramcount)
{
   if (get_obst_class (class_dc[0]) != NO_OBJECT)
   {
      if (nesting == 0)			// * self in global context
	 ;
      else if (class_name_of_method == 0)// * not in OBST method implementation
	 ;
      else if (force_indirect_call)	// * no optimization allowed
	 usage_err ("qualified call on self only when optimizing");
      else
      {					// * possible incompatibility
	 warning ("qualified call on self only when optimizing");

	 // The substitution is wrong if name_lp has a C++ shortcut.

	 impl_method (class_dc, name_lp, paramcount, is_operator, FALSE);
	 self_dot.clear();		// throw away self_dot
      }
   }
   return (self_dot + class_dc + name_lp);
}

LOCAL
strings& self_unqualified_call (strings &self_dot,
				strings &name_lp, int paramcount)
{
   if (class_name_of_method == 0)	// * not in SOS method implementation
      ;
   else if (force_indirect_call)	// * no optimization allowed
      if (cplusplus_shortcut (name_lp, paramcount))
	 self_dot.clear();
      else
	 self_replacement (self_dot);
   else					// * optimization allowed
   {  if (NOT cplusplus_shortcut (name_lp, paramcount))
	 this_parameter (name_lp, paramcount, is_operator);
      self_dot.clear();
   }
   return (self_dot + name_lp);
}

/* ---------------------------------------------------------------------------
 * yacc-grammar (note: default action is '$$ = $1;')
 */
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 894 "src/scp/scp.y"


#include "scp_lex.h"
static int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 67
# define YYLAST 182
static int yyact[]={

    18,    32,    28,    19,    33,    20,    35,    31,    37,    21,
    22,    30,    23,    36,    92,    38,    34,    25,    26,    18,
    32,    28,    19,    33,    20,    35,    31,    37,    21,    22,
    30,    23,    36,     4,    38,    34,    25,    26,    84,    88,
    39,    87,    85,   101,    83,    53,    37,   102,    64,    30,
    31,    86,    31,    64,    28,     2,    52,     5,    12,    68,
    54,     1,     3,    24,    15,    14,     8,    29,     9,    82,
    79,    17,    16,     6,    55,    56,    57,    58,    59,    60,
    61,    62,    63,    42,    65,    46,    67,    51,    66,    11,
    10,    13,     7,    69,    70,     0,     0,    71,     0,     0,
     0,    75,    45,    43,    50,    48,    77,     0,     0,    78,
     0,     0,    80,    72,    73,    27,    42,     0,    73,    72,
    81,    42,     0,    73,    89,     0,    41,     0,    47,     0,
    47,    90,    40,    91,     0,     0,     0,    93,     0,    94,
    95,    96,    97,    98,    99,    44,     0,    49,   100,     0,
     0,     0,     0,     0,     0,     0,     0,   103,   104,    41,
     0,     0,     0,     0,    41,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    74,     0,     0,     0,
     0,    76 };
static int yypact[]={

  -243,  -238, -1000,  -236, -1000, -1000, -1000, -1000, -1000, -1000,
  -219, -1000,  -219, -1000,  -219, -1000, -1000,  -226,  -243,  -243,
  -243,  -243,  -243,  -243,  -243,  -243,  -243,  -207,  -243,  -205,
  -243, -1000, -1000, -1000, -1000, -1000, -1000,  -243,  -243, -1000,
  -226,  -214,  -214,  -219,  -226, -1000,  -214,  -212,  -219,  -226,
 -1000,  -214, -1000,  -243,  -238, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,  -243, -1000, -1000,  -223,  -243, -1000,
 -1000, -1000, -1000, -1000,  -226, -1000,  -226, -1000, -1000,  -257,
 -1000, -1000, -1000,  -243,  -243,  -243,  -243,  -243,  -243, -1000,
 -1000, -1000,  -243, -1000, -1000, -1000, -1000, -1000,  -228,  -222,
 -1000,  -243,  -243, -1000, -1000 };
static int yypgo[]={

     0,    58,    92,    91,    57,    71,   115,    73,    90,   132,
    89,    70,    56,    72,    69,    68,    67,    66,    65,    64,
    63,    55,    62,    61,    60,    59 };
static int yyr1[]={

     0,    23,    23,     4,     4,     4,     4,     7,     7,     2,
     2,     2,    17,    17,    17,    12,    24,    12,    11,    11,
    10,    10,    10,    10,     3,     3,     3,    19,    19,    19,
    19,     9,     9,     8,     6,    18,    16,     1,    13,    14,
    14,    14,    14,    14,    14,    25,     5,    15,    15,    15,
    15,    15,    15,    15,    15,    15,    15,    15,    20,    20,
    20,    20,    20,    21,    21,    22,    22 };
static int yyr2[]={

     0,     3,     5,     2,     2,     2,     2,     7,     2,     9,
     7,     2,     9,     7,     3,     5,     1,     9,     2,     5,
     5,     5,     2,     2,     5,     5,     2,     5,     5,     2,
     2,     5,     5,     7,     5,     5,     5,     5,     7,     5,
     5,     5,     5,     9,     9,     1,     7,     2,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     5,     3,     3,
     3,     3,     3,     1,     2,     3,     5 };
static int yychk[]={

 -1000,   -23,   -21,   -22,   276,    -4,    -7,    -2,   -17,   -15,
    -8,   -10,    -1,    -3,   -18,   -19,   -13,    -5,   257,   260,
   262,   266,   267,   269,   -20,   274,   275,    -6,   259,   -16,
   268,   264,   258,   261,   273,   263,   270,   265,   272,   276,
    -9,    -6,   -13,    -8,    -9,   -10,   -13,    -6,    -8,    -9,
   -10,   -13,   -12,   271,   -24,   -21,   -21,   -21,   -21,   -21,
   -21,   -21,   -21,   -21,   260,   -21,    -1,   -21,   -25,   -21,
   -21,   -12,    -5,    -5,    -9,   -12,    -9,   -12,   -21,   -11,
    -4,   -21,   -14,   267,   261,   265,   274,   264,   262,   -21,
   -12,   -12,   271,    -4,   -21,   -21,   -21,   -21,   -21,   -21,
   -21,   271,   269,   -21,   -21 };
static int yydef[]={

    63,    -2,     1,    64,    65,     2,     3,     4,     5,     6,
    22,     8,    26,    11,    29,    14,    47,    16,    63,    63,
    63,    63,    63,    63,    63,    63,    63,    23,    63,    30,
    63,    45,    58,    59,    60,    61,    62,    63,    63,    66,
    16,    20,    21,    22,    16,    24,    25,    23,    22,    16,
    27,    28,    48,    63,     0,    49,    50,    51,    52,    53,
    54,    55,    56,    57,    63,    37,    35,     0,    63,    34,
    36,     7,    31,    32,    16,    10,    16,    13,    15,     0,
    18,    33,    38,    63,    63,    63,    63,    63,    63,    46,
     9,    12,    63,    19,    39,    40,    41,    42,     0,     0,
    17,    63,    63,    43,    44 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

static yytoktype yytoks[] =
{
	"char_tok",	257,
	"comma_tok",	258,
	"dot_tok",	259,
	"double_colon_tok",	260,
	"equal_tok",	261,
	"l_br_tok",	262,
	"l_brc_tok",	263,
	"l_par_tok",	264,
	"name_tok",	265,
	"number_tok",	266,
	"operator_string_tok",	267,
	"operator_tok",	268,
	"r_br_tok",	269,
	"r_brc_tok",	270,
	"r_par_tok",	271,
	"self_tok",	272,
	"semi_colon_tok",	273,
	"special_tok",	274,
	"string_tok",	275,
	"white_space_tok",	276,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"items : white_space",
	"items : items item",
	"item : name_begin",
	"item : dot_begin",
	"item : self_begin",
	"item : other_begin",
	"name_begin : name_dc name_or_operator_lp paritems_rpar",
	"name_begin : name_rest",
	"dot_begin : dot name_dc name_or_operator_lp paritems_rpar",
	"dot_begin : dot name_or_operator_lp paritems_rpar",
	"dot_begin : dot_rest",
	"self_begin : self_dot name_dc name_or_operator_lp paritems_rpar",
	"self_begin : self_dot name_or_operator_lp paritems_rpar",
	"self_begin : self_rest",
	"paritems_rpar : r_par_tok white_space",
	"paritems_rpar : /* empty */",
	"paritems_rpar : paritems r_par_tok white_space",
	"paritems : item",
	"paritems : paritems item",
	"name_rest : name_dc name",
	"name_rest : name_dc operator",
	"name_rest : name_dc",
	"name_rest : name",
	"dot_rest : dot name_rest",
	"dot_rest : dot operator",
	"dot_rest : dot",
	"self_rest : self_dot name_rest",
	"self_rest : self_dot operator",
	"self_rest : self_dot",
	"self_rest : self",
	"name_or_operator_lp : name l_par",
	"name_or_operator_lp : operator l_par",
	"name_dc : name double_colon_tok white_space",
	"name : name_tok white_space",
	"self_dot : self dot",
	"self : self_tok white_space",
	"dot : dot_tok white_space",
	"operator : operator_tok white_space operator_string",
	"operator_string : operator_string_tok white_space",
	"operator_string : equal_tok white_space",
	"operator_string : name_tok white_space",
	"operator_string : special_tok white_space",
	"operator_string : l_par_tok white_space r_par_tok white_space",
	"operator_string : l_br_tok white_space r_br_tok white_space",
	"l_par : l_par_tok",
	"l_par : l_par_tok white_space",
	"other_begin : operator",
	"other_begin : l_par paritems_rpar",
	"other_begin : char_tok white_space",
	"other_begin : double_colon_tok white_space",
	"other_begin : l_br_tok white_space",
	"other_begin : number_tok white_space",
	"other_begin : operator_string_tok white_space",
	"other_begin : r_br_tok white_space",
	"other_begin : special white_space",
	"other_begin : special_tok white_space",
	"other_begin : string_tok white_space",
	"special : comma_tok",
	"special : equal_tok",
	"special : semi_colon_tok",
	"special : l_brc_tok",
	"special : r_brc_tok",
	"white_space : /* empty */",
	"white_space : white_spaces",
	"white_spaces : white_space_tok",
	"white_spaces : white_spaces white_space_tok",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free((char*)yys); free((char*)yyv); return(0); }
#define YYABORT		{ free((char*)yys); free((char*)yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 672 "src/scp/scp.y"
{ cout << yypvt[-0].s; } break;
case 2:
# line 673 "src/scp/scp.y"
{ cout << yypvt[-0].s; } break;
case 7:
# line 685 "src/scp/scp.y"
{ 
        yyval.s = qualified_method (yypvt[-2].s, yypvt[-1].s, yypvt[-0].s, ParamList::count()) + yypvt[-0].s;
     } break;
case 9:
# line 693 "src/scp/scp.y"
{
	yyval.s = yypvt[-3].s + qualified_method (yypvt[-2].s, yypvt[-1].s, yypvt[-0].s, ParamList::count()) + yypvt[-0].s;
     } break;
case 10:
# line 697 "src/scp/scp.y"
{
	yyval.s = yypvt[-2].s + unqualified_call (yypvt[-1].s, ParamList::count()) + yypvt[-0].s;
     } break;
case 12:
# line 705 "src/scp/scp.y"
{ 
        yyval.s = self_qualified_call (yypvt[-3].s, yypvt[-2].s, yypvt[-1].s, ParamList::count()) + yypvt[-0].s;
     } break;
case 13:
# line 709 "src/scp/scp.y"
{
        yyval.s = self_unqualified_call (yypvt[-2].s, yypvt[-1].s, ParamList::count()) + yypvt[-0].s;
     } break;
case 14:
# line 713 "src/scp/scp.y"
{
        yyval.s = self_replacement (yypvt[-0].s);
     } break;
case 15:
# line 720 "src/scp/scp.y"
{
	yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s;
	ParamList::leave();
     } break;
case 16:
# line 724 "src/scp/scp.y"
{
	ParamList::add();
     } break;
case 17:
# line 728 "src/scp/scp.y"
{
     	yyval.s = yypvt[-2].s + strings::make(yypvt[-1].c) + yypvt[-0].s;

	if (ParamList::add_prefix())
   	   ParamList::prefix(0) = yyval.s;
	ParamList::leave();
     } break;
case 19:
# line 739 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 20:
# line 743 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 21:
# line 744 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 24:
# line 750 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 25:
# line 751 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 27:
# line 756 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 28:
# line 757 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 31:
# line 763 "src/scp/scp.y"
{ is_operator = FALSE; yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 32:
# line 764 "src/scp/scp.y"
{ is_operator = TRUE;  yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 33:
# line 768 "src/scp/scp.y"
{ yyval.s = yypvt[-2].s + strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 34:
# line 773 "src/scp/scp.y"
{
	if (ParamList::add_tpsuffix())
	{  ParamList::tpsuffix() = strings::make(NULL);

	   yyval.s = strings::make(yypvt[-1].c) + ParamList::tpsuffix() + yypvt[-0].s;
	}
	else
	   yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s;
     } break;
case 35:
# line 785 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 36:
# line 789 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 37:
# line 792 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 38:
# line 797 "src/scp/scp.y"
{ 
	yyval.s = strings::make(yypvt[-2].c) + yypvt[-0].s + yypvt[-1].s; 
     } break;
case 39:
# line 803 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 40:
# line 804 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 41:
# line 805 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 42:
# line 806 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 43:
# line 808 "src/scp/scp.y"
{  
	yyval.s = strings::make (obst_strdup ("()")) + yypvt[-2].s + yypvt[-0].s; // simplify operator
	delete yypvt[-3].c;					   // for replacement
	delete yypvt[-1].c;
     } break;
case 44:
# line 814 "src/scp/scp.y"
{  
	yyval.s = strings::make (obst_strdup ("[]")) + yypvt[-2].s + yypvt[-0].s; // simplify operator
	delete yypvt[-3].c;					   // for replacement
	delete yypvt[-1].c;
     } break;
case 45:
# line 823 "src/scp/scp.y"
{
	ParamList::enter();
     } break;
case 46:
# line 827 "src/scp/scp.y"
{
	yyval.s = strings::make(yypvt[-2].c) + yypvt[-0].s;	// the {}-part is counted as #2
     } break;
case 48:
# line 834 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 49:
# line 835 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 50:
# line 836 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 51:
# line 837 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 52:
# line 838 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 53:
# line 839 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 54:
# line 840 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 55:
# line 841 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + yypvt[-0].s; } break;
case 56:
# line 842 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 57:
# line 843 "src/scp/scp.y"
{ yyval.s = strings::make(yypvt[-1].c) + yypvt[-0].s; } break;
case 58:
# line 848 "src/scp/scp.y"
{  
	yyval.s = strings::make(yypvt[-0].c);

	ParamList::add();
	if (ParamList::add_prefix())
	{  ParamList::prefix() = strings::make(NULL);
	   yyval.s = yyval.s + ParamList::prefix();
	}
     } break;
case 59:
# line 858 "src/scp/scp.y"
{  
        if (nesting == 0  AND  NOT ParamList::in_list())
	   global_var_init = TRUE;
        yyval.s = strings::make(yypvt[-0].c);
     } break;
case 60:
# line 864 "src/scp/scp.y"
{ 
        global_var_init = FALSE;
        yyval.s = strings::make(yypvt[-0].c);
     } break;
case 61:
# line 869 "src/scp/scp.y"
{
	nesting ++;
	yyval.s = strings::make(yypvt[-0].c);
     } break;
case 62:
# line 874 "src/scp/scp.y"
{
	if (--nesting <= 0)
	{  delete class_name_of_method;
	   class_name_of_method = 0;
	   nesting = 0;
	}
	yyval.s = strings::make(yypvt[-0].c);
     } break;
case 63:
# line 885 "src/scp/scp.y"
{ yyval.s = strings::make(); } break;
case 65:
# line 890 "src/scp/scp.y"
{ yyval.s =      strings::make(yypvt[-0].c); } break;
case 66:
# line 891 "src/scp/scp.y"
{ yyval.s = yypvt[-1].s + strings::make(yypvt[-0].c); } break;
	}
	goto yystack;		/* reset registers in driver code */
}
