/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

/* ========================================================================= */
/* DEFINITIONS                                                               */
/* ========================================================================= */
/*                                                                           */
/* MODULE : sync_trc.h                                                       */
/*                                                                           */
/* ORIGINAL                                                                  */
/* AUTHOR: Claus Engel                         DATE: 08.04.1992              */
/*                                                                           */
/* CHANGES: see .changes                                                     */
/*                                                                           */
/* VERSION: none                                                             */
/* ========================================================================= */


#ifndef __SYNCTRC__
#define __SYNCTRC__ 1

#define OBST_IMP_TIME
#include "obst_stdinc.h"

#include "trc_tsy.h"



// Container-ID
#define TCONTAINER(id) TI(id)


// sos_Access_mode
#define TAM(a) \
    switch (a) \
    { \
    case READING:  TXT("READING"); break; \
    case CHECKOUT: TXT("CHECKOUT"); break; \
    case WRITING:  TXT("WRITING"); break; \
    default:       TXT("???????"); \
    }

// ta_Access_mode
#define TTM(a) \
    switch (a) \
    { \
    case CHECK_AC: TXT("CHECK_AC"); break; \
    case READ_AC : TXT("READ_AC"); break; \
    case WRITE_AC: TXT("WRITE_AC"); break; \
    case NO_AC   : TXT("NO_AC"); break; \
    default:    TXT("??????????"); \
    }

// sos_Sync_mode
#define TSM(s) \
    switch (s) \
    { \
    case WAITING:  TXT("WAITING"); break; \
    case TESTING:  TXT("TESTING"); break; \
    default:       TXT("???????"); \
    }

// Lock_mode
#define  TSL(r) \
    switch (r) \
    { \
    case NOLOCK:       TXT("NO LOCK"); break; \
    case WRITE:        TXT("WRITE"); break; \
    case READLOCK:     TXT("READLOCK"); break; \
    case WRITELOCK:    TXT("WRITELOCK"); break; \
    default:           TXT("?????????"); \
    }

// sos_Open_Result
#define TOR(r) \
    switch (r) \
    { \
    case OPENED:       TXT("OPENED"); break; \
    case LOCKED:       TXT("LOCKED"); break; \
    case UNACCESSIBLE: TXT("UNACCESSIBLE"); break; \
    default:           TXT("??????"); \
    }

// sos_Container_status
#define TCS(s) \
    switch (s) \
    { \
    case READABLE:     TXT("READABLE"); break; \
    case CHECKEDOUT:   TXT("CHECKEDOUT"); break; \
    case WRITEABLE:     TXT("WRITEABLE"); break; \
    case UNAVAILABLE:  TXT("UNAVAILABLE"); break; \
    case DESTROYED:    TXT("DESTROYED"); break; \
    default:           TXT("????????"); \
    }

// sos_Transaction_tp
#define TTT(t) \
    switch (t) \
    { \
    case NOTYPE:     TXT("NOTYPE"); break; \
    case TIMESTAMP:  TXT("TIMESTAMP"); break; \
    case LOCKING:    TXT("LOCKING"); break; \
    case OPTIMISTIC: TXT("OPTIMISTIC"); break; \
    default:         TXT("????????"); \
    }

// sos_Transaction_status
#define TTS(s) \
    switch (s) \
    { \
    case INACTIVE:   TXT("INACTIVE"); break; \
    case ACTIVE:     TXT("ACTIVE"); break; \
    case COMMITTED:  TXT("COMMITTED"); break; \
    case ABORTED:    TXT("ABORTED"); break; \
    default:         TXT("???????"); \
    }

// sos_SOSet
#define TSOSET(set) \
    TT(tsy_VL, \
    agg_iterate (set, SyncObj so) \
    { \
        TI(so.get_soscontainer()); TXT(","); \
    } agg_iterate_end (set, so); \
    TXT("."))

// Transaction
#define TTA(inta) \
    TT(tsy_VL, \
    TT(tsy_VL,TXT("TA-----------------------------------------------------")); \
    if INVALID(inta) \
      { TT(tsy_VL, TXT("NO_OBJECT")); } \
     else { \
      Transaction outa = Transaction::make(inta); \
      TT(tsy_VL, TXT("TS:"); TI(outa.get_ts())); \
      TT(tsy_VL, TXT("PID:"); TI(outa.get_hostproc_id())); \
      TT(tsy_VL, TTT(outa.get_type()); TTS(outa.get_status()); \
                TB(outa.get_implicit())); \
      TXT("openset: "); TSOSET(outa.get_openset()); \
      TXT("readset: "); TSOSET(outa.get_readset()); \
      TXT("writeset:"); TSOSET(outa.get_writeset()); } \
    TXT("--------------------------------------------------------")); 

// SyncObj
#define TSOBJ(inso) \
     TT(tsy_VL,\
     TT(tsy_VL,TXT("SyncObj-----------------------------------------------")); \
     if INVALID(inso) \
      { TT(tsy_VL, TXT("NO_OBJECT"));  }\
     else { \
      SyncObj ouso = SyncObj::make(inso); \
      TT(tsy_VL, TXT("ct:"); TI(ouso.get_soscontainer())); \
      TT(tsy_VL, TXT("Lock:");TSL(ouso.get_lock()); \
               TXT("#Queue:"); TI(ouso.get_queue().card()));}\
      TXT("--------------------------------------------------------"));


// BlockedTA
#define TBTA(bta) \
    TT(tsy_VL, \
    TT(tsy_VL, TXT("BTA---------------------------------------------------")); \
    if INVALID(bta) \
      { TT(tsy_VL, TXT("NO_OBJECT")); } \
     else { \
      TT(tsy_VL, TXT("BlockedTA.TS: "); TI(bta.get_ta().get_ts())); \
      TT(tsy_VL, TTT(bta.get_ta().get_type()); TAM(bta.get_am())); } \
    TXT("--------------------------------------------------------"));
#endif
