#ifndef	_OBST_TRC_H
#define	_OBST_TRC_H
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#include "obst_config.h"

typedef int T_addrformat;

#define T_DEC  (T_addrformat)1
#define T_UNS  (T_addrformat)2
#define T_OCT  (T_addrformat)3
#define T_HEX  (T_addrformat)4

#ifdef NO_TT

#define TT(l,c)
#define TTN(l,c)
#define T_PROC(n)
#define T_ENTER
#define T_LEAVE
#define T_INIT(name)
#define T_REDEF(spec)
#define T_EXIT()

#else

extern unsigned char tt_active[];

#ifdef __cplusplus
extern "C" {
#endif
extern char* tt_calloc __FSIG_((char*, const int));
extern char* tt_alloc  __FSIG_((char*, const int));
extern void  tt_free   __FSIG_((char*, char*)),
	     tt_init   __FSIG_((const char* const)),
	     tt_redef  __FSIG_((const char* const)),
	     tt_exit   (),
	     tt_enter  __FSIG_((const char* const)),
	     tt_leave  __FSIG_((const char* const)),
	     tt_nl  (),
	     tt_txt __FSIG_((const char* const)),
	     tt_i   __FSIG_((const char* const, const int)),
	     tt_u   __FSIG_((const char* const, const unsigned)),
	     tt_o   __FSIG_((const char* const, const unsigned)),
	     tt_x   __FSIG_((const char* const, const unsigned)),
	     tt_li  __FSIG_((const char* const, const long)),
	     tt_lo  __FSIG_((const char* const, const long)),
	     tt_lx  __FSIG_((const char* const, const long)),
	     tt_c   __FSIG_((const char* const, const int)),
	     tt_s   __FSIG_((const char* const, const char*)),
	     tt_a   __FSIG_((const char* const, const char* const, const int)),
	     tt_sa  __FSIG_((const char* const, const char** const, const int)),
	     tt_p   __FSIG_((const char* const, const void* const));

#ifdef __cplusplus
}
#endif


#define	T_PROC(n)	char *tt_proc = (n);
#define	T_INIT(name)	tt_init(name);
#define T_REDEF(spec)	tt_redef(spec);
#define T_EXIT()	tt_exit();

#define TT(l,c)         if(tt_active[l]){c;tt_nl();}
#define TTN(l,c)        if(tt_active[l]){c;}

#define T_ENTER		tt_enter (tt_proc);
#define T_LEAVE		tt_leave (tt_proc);

#define	TB(b)	 tt_txt ((b) ? "b: TRUE" : "b: FALSE")
#define TXT(xt)  tt_txt ( xt )
#define	TI(i)	 tt_i ( "i:", i )
#define TU(u)	 tt_u ( "u:", u )
#define	TO(o)	 tt_o ( "o:", o )
#define	TX(x)	 tt_x ( "x:", x )
#define	TLI(li)	 tt_li ( "li:", li )
#define	TLO(lo)	 tt_lo ( "lo:", lo )
#define	TLX(lx)	 tt_lx ( "lx:", lx )
#define TC(c)	 tt_c ( "c:", c )
#define TS(s)	 tt_s ( "s:", s )
#define TA(a,n)  tt_a ( "a:", a, n )
#define TSA(a,n) tt_sa ( "a:", a, n )
#define TP(p)	 tt_p ( "p:", p )
#define TsS(sS)  if((sS)==NO_OBJECT)tt_s("sS:","<NO_OBJECT>"); \
		 else{char*_x=(sS).make_Cstring();tt_s("sS:",_x);delete _x;}
#define TOBJ(o)  {tt_i("o.c:",(int)o.container());tt_i("o.o:",(int)o.offset());}

#endif
#endif
