/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

/* This is a C-file (no C++); trc.h provides the appropriate C/C++   */
/* interface.							     */

/* ================================================================= */
/* ===   MODULE - REALISATION                                    === */
/* ================================================================= */
/*                                                                   */
/* MODULE-NAME: obst_trc.c               KEY : trc                   */
/*                                                                   */
/* ORIGINAL                                                          */
/* AUTHOR : UNIBASE-Project              DATE: 6-3-86                */
/*                                                                   */
/* UPDATE HISTORY                                                    */
/* AUTHOR : rainer holzapfel             DATE: 26-11-86              */
/* AUTHOR : andreas geppert              DATE: 03-08-87              */
/* AUTHOR : dietmar theobald (dt)        DATE: 03-09-91              */
/*	    removed most superfluous stuff, tried to turn this into  */
/*	    maintainable code					     */
/*                                                                   */
/* ================================================================= */
/*                                                                   */
/* PURPOSE:                                                          */
/*P         This module contains the functions of trc, making        */
/*P         possible various kinds of test output.                   */
/*                                                                   */
/* ================================================================= */

/* ================================================================= */
/* global declaration of system                                      */
/* ================================================================= */

#define OBST_IMP_STDCONST
#define OBST_IMP_STRINGOP
#define OBST_IMP_FILE
#define OBST_IMP_MALLOC
#define OBST_IMP_ERROR
#define OBST_IMP_TIME
#include "obst_stdinc.h"

#include "_obst_config.h"
#include "obst_progstd.h"          /* programming guidelines         */
#include "obst.h"		   /* for obst_getenv()		     */

typedef int bool ;
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

typedef char* 	     string;
typedef const char * conststring;


/* ================================================================= */
/* other C-libraries                                                 */
/* ================================================================= */


extern   string		ttyname();
extern	 string     PTR environ;

extern   int		sys_nerr;
extern   string	        sys_errlist [];


/* ================================================================= */
/* EXPORT:                                                           */
/* ================================================================= */

#ifdef NO_TT
#undef NO_TT	/* Assert that this module is part of the OBST library,	*/
#endif		/* even if OBST is generated without trace code.	*/

#include "obst_trc.h"


/* ================================================================= */
/*                                                                   */
/* REALISATION:                                                      */
/*                                                                   */
/* ================================================================= */

/* ================================================================= */
/*    MODULE - CONSTANTS / MACROS:                                   */
/* ================================================================= */

/*#define tt_MAXLEVEL		(see _obst_config.h) */
#define tt_STDOUT    1
#define tt_STDERR    2
#define tt_DEL	     0177
/*#define tt_MAXCOLS		(see _obst_config.h) */
/*#define tt_STDINDENT		(see _obst_config.h) */
/*#define tt_MAXINDENT		(see _obst_config.h) */

#define tt_TRACE_COND(level) (level % 10 == 0)

#define T_ALLOC(v,t,l)	(v = (t *) tt_alloc ( "v", (l) * sizeof (t) ))
#define T_CALLOC(v,t,l)	(v = (t *) tt_calloc ( "v", (l) * sizeof (t) ))
#define T_FREE(v)	(tt_free ( "v", v ), v = NULL )


/* ================================================================= */
/*    MODULE - TYPES:                                                */
/* ================================================================= */

/* ================================================================= */
/*    MODULE - VARIABLES:                                            */
/* ================================================================= */

/* in obst_globals.C: tt_digits, tt_addrformat */

LOCAL    string            tt_command;
EXPORT	 string            tt_faddr;
EXPORT	 string            tt_laddr;
LOCAL	 string		   tt_env_var = ENVVAR_TRC;	     /*_obst_config.h*/
LOCAL	 string		   tt_default_file = tt_DEFAULT_FILE;/*_obst_config.h*/
LOCAL    char		   tt_digits [] = "0123456789abcdef";
LOCAL	 string		   tt_filename;
LOCAL    char	           tt_buf [512];
LOCAL	 int	           tt_file = -1,
			   tt_tmp_file,
	                   tt_col  = 0,
	                   tt_indent = 0,
                           tt_cmd_indx;
EXPORT	 int               tt_do_indent /* = FALSE */,  /* done	      */
	                   tt_afdebug   /* = FALSE */,  /* implicitly */
	                   tt_screen    /* = FALSE */;
LOCAL    time_t	           tt_start;
LOCAL	 T_addrformat	   tt_addrformat = T_HEX;

/* Erweiterung: */

EXPORT unsigned char tt_active [tt_MAXLEVEL + 1];
/* Boole'sches Array; NEQ 0 fuer einen aktiven Level */

/* Ende der Erweiterung. Rainer Holzapfel, 26-Nov-1986 */


/* ================================================================= */
/*    MODULE - OPERATIONS:                                           */
/* ================================================================= */

LOCAL	char	*appint (), *applong (), *appstr (),
		*tt_app (), *tt_enc (), *tt_ecc (), *tt_enp ();
LOCAL   void    tt_writefile ();


/* ***************************************************************** */
LOCAL int getchr ()
/* ***************************************************************** */
{  while (TRUE)
   {  int c = tt_command[tt_cmd_indx++];
      switch (c)
      {  case 'T' : return ('t');
	 case '#' :
	 case 't' :
	 case '-' :
	 case ',' :
	 case '0' :
	 case '1' :
	 case '2' :
	 case '3' :
	 case '4' :
	 case '5' :
	 case '6' :
	 case '7' :
	 case '8' :
	 case '9' :
	 case EOS : return (c);
      }
   }
} /* getchr */


/* ***************************************************************** */
LOCAL void ungetchr ()
/* ***************************************************************** */
{
   tt_cmd_indx--;
}  /* ungetchr */


/* ***************************************************************** */
LOCAL int getnum ()
/* ***************************************************************** */
{
   int result = 0;
   char c;

   while ('0' <= (c = getchr())  AND  c <= '9')
      result = (result * 10) + (c - '0');

   ungetchr ();
   return (result > tt_MAXLEVEL) ? tt_MAXLEVEL
				 : result;
} /* getnum */


/* ***************************************************************** */
LOCAL void interval (int_lo, int_hi)
/* ***************************************************************** */

	int PTR int_lo,  PTR int_hi;

{	int	c;

   if ('0' <= (c = getchr())  AND  c <= '9')
   {  ungetchr ();
      CONT( int_lo ) = getnum ();
      CONT( int_hi ) = CONT( int_lo );
      c = getchr ();
   }
   else
   {  CONT( int_lo ) = 0;
      CONT( int_hi ) = -1;
   }
   if (c NEQ '-')
      ungetchr ();
   else
   {  c = getchr ();
      ungetchr ();

      CONT( int_hi ) = ('0' <= c  AND  c <= '9') ? getnum ()
						 : tt_MAXLEVEL;
   }
} /* interval */


/* ***************************************************************** */
LOCAL void interpret (cmd_str)
/* ***************************************************************** */

	string	cmd_str;

{	int	c;
	int	stdtrace;
	int	level, int_lo, int_hi;

   tt_command  = cmd_str;
   tt_cmd_indx = 0;

   while (TRUE)
   {  while ((c = getchr()) NEQ EOS  AND  c NEQ '#')
	 ;
      if (c EQ EOS)
	 break;

      if ((c = getchr()) EQ 't')
	 stdtrace = TRUE;
      else
      {  ungetchr ();
	 stdtrace = FALSE;
      }
      interval (REF( int_lo ), REF( int_hi ));
      if (stdtrace)
	 for (level = int_lo; level <= int_hi; level++ )
	    tt_active[level] = tt_TRACE_COND(level);
      else
	 for (level = int_lo; level <= int_hi; level++ )
	    tt_active[level] = TRUE;
   }
} /* interpret */
/* Ende der Ergaenzung. Rainer Holzapfel, 26-Nov-1986 */


/* ***************************************************************** */
LOCAL  void	tt_writefile ( ptr_into_tt_buf )
/* ***************************************************************** */

	string	ptr_into_tt_buf;

{  if (tt_file < 0)
      tt_init ( NULL );

   write ( tt_screen ? tt_STDERR : tt_file,
	   tt_buf,
	   (unsigned) (ptr_into_tt_buf - tt_buf) );
}


/* ***************************************************************** */
LOCAL  string	tt_app ( txt )
/* ***************************************************************** */

	string	txt;

{
   	string	pt;
   	int	i, l;

  if ( txt )
  {  if ( CONT( txt ) EQ ' ' )
       txt ++;
     else if ( CONT( txt ) EQ tt_DEL )
       CONT( txt ) = ' ';	/* const strings must not start with tt_DEL! */

     l = strlen ( txt );
     if ( l > tt_MAXCOLS )
     {  l = tt_MAXCOLS;   /* const strings must not exceed tt_MAXCOLS chars! */
        txt [tt_MAXCOLS] = EOS;
     }
  }
  else
     l = 0;

  pt = tt_buf;

  if ( tt_col + l + 2 > tt_MAXCOLS )  /* note: tt_MAXINDENT << tt_MAXCOLS */
  {  CONT( pt ++ ) = EOL;
     tt_col = 0;
  }

  if ( tt_do_indent  AND  tt_col < tt_indent )
     for ( tt_col = i = tt_indent; i > 0; i -- )
       CONT( pt ++ ) = ' ';

  if ( tt_col > ( tt_do_indent ? tt_indent : 0 ) )
  {  CONT( pt ++ ) = ',';
     CONT( pt ++ ) = ' ';
     tt_col += 2;
  }
  if ( txt )
  {  pt = appstr ( pt, txt );
     CONT( pt ++ ) = ' ';
     tt_col += l + 1;
  }

  return ( pt );
} /* tt_app */


/* ***************************************************************** */
LOCAL  string	appint ( s, i, l )
/* ***************************************************************** */

   	string	s;
   	int	i, l;

{

   	int	flag = FALSE, zerofill = TRUE, k;

  if ( i < 0 )
  {
    CONT( s ++ ) = '-';
    i = -i;
  }

  if ( l < 0 )
  {
    zerofill = FALSE;
    l = -l;
  }

  while ( l > 5 )
  {
    CONT( s ++ ) = zerofill ? '0' : ' ';
    l --;
  }

  if ( l EQ 5 )
    flag = TRUE;

  k = i / 10000;
  i %= 10000;

  if ( flag OR k )
  {
    if ( k OR zerofill )
      CONT( s ++ ) = k + '0';
    else
      CONT( s ++ ) = ' ';

    flag = TRUE;
  }
  else if ( l >= 4 )
    flag = TRUE;

  k = i / 1000;
  i %= 1000;

  if ( flag OR k )
  {
    if ( k OR zerofill )
      CONT( s ++ ) = k + '0';
    else
      CONT( s ++ ) = ' ';

    flag = TRUE;
  }
  else if ( l >= 3 )
    flag = TRUE;

  k = i / 100;
  i %= 100;

  if ( flag OR k )
  {
    if ( k OR zerofill )
      CONT( s ++ ) = k + '0';
    else
      CONT( s ++ ) = ' ';

    flag = TRUE;
  }
  else if ( l >= 2 )
    flag = TRUE;

  k = i / 10;
  i %= 10;

  if ( flag OR k )
  {
    if ( k OR zerofill )
      CONT( s ++ ) = k + '0';
    else
      CONT( s ++ ) = ' ';
  }

  CONT( s ++ ) = i + '0';
  CONT( s ) = EOS;
  return ( s );
} /* appint */


/* ***************************************************************** */
LOCAL  string	applong ( s, l )
/* ***************************************************************** */

   	string	s;
   	long	l;

{

	char	buf [16];
   	string	pt;

  if ( l < 0 )
  {
    CONT( s ++ ) = '-';
    l = -l;
  }

  if ( NOT  ( l ) )
  {
    CONT( s ++ ) = '0';
    CONT( s ) = EOS;
    return ( s );
  }

  for ( ( buf [15] = EOS, pt = buf + 14 ); l; pt -- )
  {
    CONT( pt ) = (char) ( l MOD 10 ) + '0';
    l = l / 10;
  }

  while ( CONT( s ++ ) = CONT(  ++ pt ) ) ;

  return ( s - 1 );
} /* applong */


/* ***************************************************************** */
LOCAL  string	appstr ( s1, s2 )
/* ***************************************************************** */

   	string	s1;
        string  s2;

{

  while ( CONT( s1 ++ ) = CONT( s2 ++ ) ) ;

  return ( s1 - 1 );
} /* appstr */


/* ***************************************************************** */
LOCAL  string	tt_ecc ( pt, val )
/* ***************************************************************** */

	string	pt;
	int	val;

{static int	 C_escapes [] = { '0', EOS, EOS, EOS, EOS, EOS, EOS, 'a',
				  'b', 't', 'n', 'v', 'f', 'r' };
	int	 esc_char;

  if ( isascii ( val ) AND isprint ( val ) )
  {  if ( val EQ ' ' )
     {  CONT( pt ++ ) = val = '.';
        tt_col ++;
     }

     CONT( pt ++ ) = val;
     tt_col ++;
  }
  else if ( val <= '\r' AND ( esc_char = C_escapes [val] ) )
  {  CONT( pt ++ ) = '\\';
     CONT( pt ++ ) = esc_char;
     tt_col += 2;
  }
  else
  {  CONT( pt ++ ) = '\\';
     CONT( pt ++ ) = tt_digits [((unsigned)val >> 6) BITAND 0x3];
     CONT( pt ++ ) = tt_digits [((unsigned)val >> 3) BITAND 0x7];
     CONT( pt ++ ) = tt_digits [val BITAND 0x7];
     tt_col += 3;
  }
  return ( pt );

} /* tt_ecc */


/* ***************************************************************** */
LOCAL	string	tt_eccs ( pt, c, count )
/* ***************************************************************** */

   	string	pt;
        int     c;
   	int	count;

{	int	oldcol = tt_col;
	char	buf[20];
	string  buf_pt = buf;

  if ( count > 1 )
  {  buf_pt = tt_enc ( buf_pt, (long) count, T_DEC );
     CONT( buf_pt ++ ) = '*';
     tt_col ++;
  }
  buf_pt = tt_ecc ( buf_pt, (unsigned)c );
  CONT( buf_pt ++ ) = ' ';
  CONT( buf_pt    ) = EOS;

  if ( tt_col < tt_MAXCOLS )
     tt_col = oldcol;
  else
  {  CONT( pt ++ ) = EOL;
     tt_writefile ( pt );

     pt = tt_buf;
     CONT( pt ++ ) = ' ';
     tt_col = 1;
  }
  pt = appstr ( pt, buf );
  tt_col += buf_pt - buf;
  
  return ( pt );
} /* tt_eccs */


/* ***************************************************************** */
LOCAL  string	tt_enc ( s, val, mode )
/* ***************************************************************** */

	string	s;
   	long	val;
   	T_addrformat	mode;

{
	char	hbuf [20];
   	string	pt = hbuf + 19;
   	bool	neg = FALSE;
	long	help;
	int	shft;  /* = 4 */

  CONT( pt -- ) = EOS;

  if ( val EQ 0 )
    CONT( pt -- ) = '0';

  else if ( mode EQ T_UNS OR mode EQ T_DEC )
  {
    if ( mode EQ T_DEC AND val < 0 )
    {
      neg = TRUE;
      val = -val;
    }

    for ( ; val; val /= 10 )
      CONT( pt -- ) = tt_digits [val MOD 10];

    if ( neg )
      CONT( pt -- ) = '-';
  }
  else
  {
    if ( mode EQ T_HEX )
    {
      CONT( s ++ ) = 'X';
      help = 0xfL;
      shft = 4;
    }
    else
    {
      CONT( s ++ ) = '0';
      help = 07L;
      shft = 3;
    }

    CONT( pt -- ) = tt_digits [val BITAND help];
    val = ( val >> shft ) BITAND
		BITCPL( ( help << ( sizeof (long) * 8 - shft ) ) );

    while ( val )
    {
      CONT( pt -- ) = tt_digits [val BITAND help];
      val >>= shft;
    }
  }

  tt_col += strlen ( ++ pt );
  return ( appstr ( s, pt ) );
} /* tt_enc */


/* ***************************************************************** */
LOCAL  string tt_enp ( pt, val )
/* ***************************************************************** */

   	string	pt;
	string	val;

{
   	long	hval = (long) val;

  if ( NOT val )
    return ( appstr ( pt, "NULL" ) );

  pt = tt_enc ( pt, hval, tt_addrformat );

  return ( pt );
} /* tt_enp */


/* ***************************************************************** */
LOCAL void tt_err ( action, file )
/* ***************************************************************** */

   	string	action;
        string  file;

{

   	string	pt;

  tt_nl ();

  pt = tt_app ( "Cannot" );
  pt = appstr ( pt, action );

  if ( file AND CONT( file ) )
  {
    CONT( pt ++ ) = ' ';
    CONT( pt ++ ) = '\'';
    pt = appstr ( pt, file );
    CONT( pt ++ ) = '\'';
  }

  if ( errno )
  {
    CONT( pt ++ ) = ':';
    CONT( pt ++ ) = ' ';

    if ( errno < sys_nerr )
      pt = appstr ( pt, sys_errlist [errno] );
    else
    {
      pt = appstr ( pt, "Unknown Error #" );
      pt = appint ( pt, errno, 0 );
    }
  }

  CONT( pt ++ ) = EOL;
  tt_col = 0;
  tt_writefile ( pt );
} /* tt_err */


/* ***************************************************************** */
EXPORT  string	tt_alloc ( s, n )
/* ***************************************************************** */

string	s;
int	n;

{
   	string	pt = malloc ( ( unsigned int ) n );

  T_PROC  ( "tt_alloc" );
  if (tt_afdebug)
  {
     tt_s ( tt_proc, s ); TI (n); tt_p ( "=", pt );
     tt_nl ();
  }

  if ( NOT  pt )
  {
    perror ( tt_proc );
    abort ();
  }

  if ( NOT  tt_faddr )
    tt_faddr =  pt;

  if ( pt > tt_laddr )
    tt_laddr =  pt + n - 1 ;

  return ( pt );
} /* tt_alloc */


/* ***************************************************************** */
EXPORT string	tt_calloc ( s, n )
/* ***************************************************************** */

string	s;
int	n;

{
   	string	cpt;
	string  pt = malloc ( ( unsigned int ) n );

  T_PROC  ( "tt_calloc" );
  if (tt_afdebug)
  {
     tt_s ( tt_proc, s ); TI (n); tt_p ( "=", pt );
     tt_nl ();
  }

  if ( NOT  pt )
  {
    perror ( tt_proc );
    abort ();
  }

  if ( NOT  tt_faddr )
    tt_faddr =  pt;

  if ( pt > tt_laddr )
    tt_laddr =  pt + n - 1;

  for ( cpt = pt; n > 0; n -- )
    CONT( cpt ++ ) = EOS;

  return ( pt );
} /* tt_calloc */


/* ***************************************************************** */
EXPORT  void  tt_free ( s, p )
/* ***************************************************************** */

string	s;
string  p;

{
  if (tt_afdebug)
  {
     tt_s ( "tt_free", s ); tt_p ( "=", p );
     tt_nl ();
  }

  if ( p < tt_faddr OR p > tt_laddr )
  {
    tt_p ( "can't tt_free", p );
    return;
  }
  free ( p );
} /* tt_free */


/* ***************************************************************** */
EXPORT  void tt_redef ( str )
/* ***************************************************************** */

   	conststring	str;

{
   int	i;

   for ( i = tt_MAXLEVEL; i > 0; --i ) tt_active [i] = FALSE;
   tt_active[0] = TRUE;
     /* Richard 25.1.88: set level 0 always! */

   while ( CONT( str ) )
   {  if (CONT( str ) EQ '#')
      {  interpret ( str );
	 break;
      }
      else if (isdigit ( CONT(str) ))
      {
	 int level = atoi ( str ),
	     j     = (level > tt_MAXLEVEL) ? tt_MAXLEVEL
					   : level;
	 while (j >= 0)
	    tt_active [j --] = TRUE;

	 while (isdigit( CONT(++ str) ))
	    ;
      }
      else
         switch ( CONT(str ++) )
	 {  case 'I': case 'i': tt_do_indent  = TRUE;  break;
	    case 'S': case 's': tt_screen     = TRUE;  break;
		      case 'a': tt_afdebug    = 1;     break;
	    case 'A':           tt_afdebug    = 2;     break;
	    case 'H': case 'h': tt_addrformat = T_HEX; break;
	    case 'D': case 'd': tt_addrformat = T_DEC; break;
	    case 'O': case 'o': tt_addrformat = T_OCT; break;
	    case 'U': case 'u': tt_addrformat = T_UNS; break;
	    case 'N': case 'n': tt_active[0]  = FALSE; break;
	       /* Richard 25.1.88: reset level 0 */
	 }
   }
} /* tt_redef */


/* ***************************************************************** */
EXPORT  void  tt_init ( pname )
/* ***************************************************************** */

   	conststring	pname;

{
   	struct	tm	PTR tm;
	struct	tm	PTR localtime ();
	string  	pt;
	string  	envstr;
	int		i;

   if ( tt_file >= 0 )
     return;

   if (envstr = obst_getenv (tt_env_var))
   {  tt_redef (envstr);
      tt_tmp_file = FALSE;
   }
   else
   {  for ( i = tt_MAXLEVEL; i > 0; --i ) tt_active [i] = FALSE;
      tt_active[0] = TRUE;
      tt_tmp_file  = TRUE;
   }
   time ( REF( tt_start ) );
   tm = localtime ( REF( tt_start ) );

   if ( pname EQ NULL  OR  strlen ( pname ) EQ 0 )
      pname = tt_default_file;

  if ( ( tt_file = creat ( pname, 0666 ) ) < 0 )
  {
    perror ( pname );
    sleep ( 10 );
    exit ( 99 );
  }
  tt_filename = obst_strdup ( pname );

  fchmod ( tt_file, 0666 );
  fcntl ( tt_file, F_SETFD, 1 );

  pt = tt_buf;
  if (envstr)
  {  pt = appstr ( pt, tt_env_var );
     CONT( pt++ ) = '=';
     pt = appstr ( pt, envstr );
     CONT( pt++ ) = EOL;
  }
  pt = appstr ( pt, "pid " );
  pt = appint ( pt, getpid (), 0 );

  pt = appstr ( pt, "; start " );
  pt = appint ( pt, tm -> tm_hour, 0 );
  CONT( pt ++ ) = ':';
  pt = appint ( pt, tm -> tm_min, 2 );
  CONT( pt ++ ) = ':';
  pt = appint ( pt, tm -> tm_sec, 2 );
  pt = appstr ( pt, "; tty " );
  if (envstr = ttyname (tt_STDOUT))
     pt = appstr ( pt, envstr );
  else
     CONT ( pt ++ ) = '?';
  CONT( pt ++ ) = EOL;

  write ( tt_file, tt_buf, ( unsigned int ) ( pt - tt_buf ) );

} /* tt_init */


/* ***************************************************************** */
EXPORT  void  tt_exit ()
/* ***************************************************************** */

{

struct	tbuffer {
  long	p_user, p_sys,
	c_user, c_sys; } buf;
   	long	alltime, cputime;
   	string	pt;
	time_t	endtime;
   	struct	tm	PTR tm;
	struct	tm	PTR localtime ();

  if ( tt_file < 0 )
    return;

  if ( tt_tmp_file )
     unlink ( tt_filename );
  else
  {  tt_nl ();

     times ( REF(  buf ) );
     time	( REF(  endtime ) );
     tm = localtime ( REF( endtime ) );

     cputime = ( buf.p_user * 100 ) / 60;
     pt = applong ( tt_buf, cputime / 100 );
     CONT( pt ++  )= '.';
     CONT( pt ++ ) = ( cputime MOD 100 ) / 10 + '0';
     CONT( pt ++ ) = cputime MOD 10 + '0';
     strcpy ( pt, " user, " );
     cputime = ( buf.p_sys * 100 ) / 60;
     pt = applong ( pt + 7, cputime / 100 );
     CONT( pt ++ ) = '.';
     CONT( pt ++ ) = ( cputime MOD 100 ) / 10 + '0';
     CONT( pt ++ ) = cputime MOD 10 + '0';
     strcpy ( pt, " sys, " );
     alltime = endtime - tt_start;
     pt = appint ( pt + 6, (int) (alltime / 3600), 0 );
     alltime %= 3600;
     CONT(  pt ++ ) = ':';
     pt = appint ( pt, (int) (alltime / 60), 2 );
     CONT(  pt ++ ) = ':';
     pt = appint ( pt, (int) (alltime MOD 60), 2 );
     strcpy ( pt, " real, end at " );
     pt = appint ( pt + 14, tm -> tm_hour, 0 );
     CONT( pt ++ ) = ':';
     pt = appint ( pt, tm -> tm_min, 2 );
     CONT( pt ++ ) = ':';
     pt = appint ( pt, tm -> tm_sec, 2 );
     CONT( pt ++ ) = EOL;
     CONT( pt ) = EOS;

     write ( tt_file, tt_buf, ( unsigned int ) ( pt - tt_buf ) );
  }
  close ( tt_file );
  free ( tt_filename );

  tt_file = -1;
} /* tt_exit */


/* ***************************************************************** */
EXPORT  void  tt_enter ( proc )
/* ***************************************************************** */

   	conststring	proc;

{
   	string	pt;

  tt_nl ();

  pt = appstr ( tt_app ( "Enter {" ), proc );
  tt_col += strlen ( proc );
  tt_writefile ( pt );

  tt_indent = ( tt_indent + tt_STDINDENT ) MOD tt_MAXINDENT;
} /* tt_enter */


/* ***************************************************************** */
EXPORT  void  tt_leave ( proc )
/* ***************************************************************** */

   	conststring	proc;

{
   	string	pt;

  tt_indent = ( tt_indent + tt_MAXINDENT-tt_STDINDENT ) MOD tt_MAXINDENT;
  tt_nl ();

  pt = appstr ( tt_app ( "Leave }" ), proc );
  tt_col += strlen ( proc );
  tt_writefile ( pt );

} /* tt_leave */


/* ***************************************************************** */
EXPORT  void  tt_nl ()
/* ***************************************************************** */

{
  if ( tt_col )
  {  tt_writefile ( appstr ( tt_buf, "\n" ) );
     tt_col = 0;
  }
}


/* ***************************************************************** */
EXPORT  void tt_txt ( txt )
/* ***************************************************************** */

	conststring	txt;

{  tt_writefile ( tt_app ( txt ) - 1 );
   tt_col -= 1;
}


/* ***************************************************************** */
EXPORT  void  tt_i ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	int		val;

{  tt_writefile ( tt_enc ( tt_app(txt), (long) val, T_DEC ) );
}


/* ***************************************************************** */
EXPORT  void  tt_u ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	unsigned 	val;

{  tt_writefile ( tt_enc ( tt_app(txt), (long) val, T_UNS ) );
}


/* ***************************************************************** */
EXPORT void tt_o ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	unsigned 	val;

{  tt_writefile ( tt_enc ( tt_app(txt), (long) val, T_OCT ) );
}


/* ***************************************************************** */
EXPORT  void  tt_x ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	unsigned 	val;

{  tt_writefile ( tt_enc ( tt_app(txt), (long) val, T_HEX ) );
}


/* ***************************************************************** */
EXPORT  void  tt_li ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	long		val;

{  tt_writefile ( tt_enc ( tt_app(txt), val, T_DEC ) );
}


/* ***************************************************************** */
EXPORT  void  tt_lo ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	long		val;

{  tt_writefile ( tt_enc ( tt_app(txt), val, T_OCT ) );
}


/* ***************************************************************** */
EXPORT  void  tt_lx ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	long		val;

{  tt_writefile ( tt_enc ( tt_app(txt), val, T_HEX ) );
}


/* ***************************************************************** */
EXPORT  void  tt_c ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	int		val;

{  tt_writefile ( tt_ecc ( tt_app(txt), val ) );
}


/* ***************************************************************** */
EXPORT  void  tt_s ( txt, val )
/* ***************************************************************** */

   	conststring  txt;
        conststring  val;

{
   	string	pt;
   	int	l = val ? strlen ( val ) : 6;

  if ( tt_col + l + ( txt ? strlen ( txt ) : 0 ) > tt_MAXCOLS )
     tt_nl ();

  pt = tt_app ( txt );

  if ( NOT val )
  {  pt = appstr ( pt, "<NULL>" );
     tt_col += 6;
  }
  else
  {  CONT( pt ++ ) = '<';
     pt = tt_enp ( pt, val );
     CONT( pt ++ ) = '>';
     CONT( pt ++ ) = ' ';
     CONT( pt ++ ) = '\'';
     tt_col += 4;

     while ( TRUE )
     {  conststring end = val + (tt_MAXCOLS - tt_col) - 2;

	while ( val <= end  AND  CONT( val ) )
	{  CONT ( pt ++ ) = CONT ( val );
	   if ( CONT( val ++ ) EQ EOL )
	   {  -- pt;
	      break;
	   }
	   ++ tt_col;
	}
	if ( CONT( val ) )
	{  CONT ( pt ++ ) = EOL;
	   tt_writefile ( pt );
	   pt     = tt_buf;
	   tt_col = 0;
	}
	else
	   break;
     }
     CONT ( pt ++ ) = '\'';
     ++ tt_col;
  }
  tt_writefile ( pt );

} /* tt_s */


/* ***************************************************************** */
EXPORT  void tt_a ( txt, val, nel )
/* ***************************************************************** */

	conststring	txt;
   	conststring	val;
   	int		nel;

{
   	int	count;
	int	printable_max_seq;
   	string	pt;
        int     lastc;
        string  tt_app();
	string  tt_enp();

  pt = tt_app ( txt );
  CONT( pt ++ ) = '<';
  pt = tt_enp ( pt, val );
  CONT( pt ++ ) = '>';
  CONT( pt ++ ) = ' ';
  tt_col += 3;

  tt_writefile ( pt );

  if ( NOT  val )
     return;

  pt = tt_buf;

  if ( nel <= 0 )
     nel = strlen ( val ) + 1;				/* note: nel >= 1! */

  printable_max_seq = ( nel > 50 ? 3 : 50 );

  lastc = CONT( val ++ );
  count = 1;
  while ( TRUE )
  {  if ( --nel > 0  AND  lastc EQ CONT( val ) )
        count ++;
     else
     {  if ( isprint ( lastc )  AND  count <= printable_max_seq )
	   while ( --count >= 0 )
	      pt = tt_eccs ( pt, lastc, 1 );
	else
	   pt = tt_eccs ( pt, lastc, count );

	if ( nel EQ 0 )
	   break;

        count = 1;
        lastc = CONT( val );
     }
     val ++;
  }
  CONT( pt ++ ) = EOL;
  tt_writefile ( pt );
  tt_col = 0;

} /* tt_a */


/* ***************************************************************** */
EXPORT  void  tt_sa ( txt, val, nel )
/* ***************************************************************** */

	conststring	txt;
   	conststring	PTR val;
   	int		nel;

{
   	int	cnt;
   	string	pt = tt_app ( txt );
	char	buf [10];

  CONT( pt ++ ) = EOL;
  tt_col = 0;
  tt_writefile ( pt );

  for ( cnt = 0; nel > 0; cnt ++, val ++, nel -- )
  {
    pt = buf;
    CONT( pt ++ ) = tt_DEL;
    CONT( pt ++ ) = '[';
    CONT( pt ++ ) = cnt / 10 + '0';
    CONT( pt ++ ) = cnt MOD 10 + '0';
    CONT( pt ++ ) = ']';
    CONT( pt    ) = EOS;

    tt_s ( buf, CONT( val ) );
    tt_nl ();
  }
} /* tt_sa */


/* ***************************************************************** */
EXPORT  void  tt_p ( txt, val )
/* ***************************************************************** */

	conststring	txt;
	const void*	val;

{  tt_writefile ( tt_enp ( tt_app(txt), val ) );
}
