/*  Test passing of arguments to functions.  Use various sorts of arguments,
    including basic types, pointers to those types, structures, lots of
    args, etc, in various combinations. */


char c = 'a';
char *cp = &c;

unsigned char uc = 'b';
unsigned char *ucp = &uc;

short s = 1;
short *sp = &s;

unsigned short us = 6;
unsigned short *usp = &us;

int i = 2;
int *ip = &i;

unsigned int ui = 7;
unsigned int *uip = &ui;

long l = 3;
long *lp = &l;

unsigned long ul = 8;
unsigned long *ulp = &ul;

float f = 4.0;
float *fp = &f;

double d = 5.0;
double *dp = &d;

struct stag {
    int s1;
    int s2;
} st = { 101, 102 };
struct stag *stp = &st;

union utag {
    int u1;
    long u2;
} un;
union utag *unp = &un;

char carray[] = {'a', 'n', ' ', 'a', 'r', 'r', 'a', 'y', '\0'};


/* Test various permutations and interleaving of integral arguments */


call0a (c, s, i, l)
char c; short s; int i; long l; {}

call0b (s, i, l, c)
short s; int i; long l; char c; {}

call0c (i, l, c, s)
int i; long l; char c; short s; {}

call0d (l, c, s, i)
long l; char c; short s; int i; {}

call0e (c1, l, c2, i, c3, s, c4, c5)
char c1; long l; char c2; int i; char c3; short s; char c4; char c5; {}


/* Test various permutations and interleaving of unsigned integral arguments */


call1a (uc, us, ui, ul)
unsigned char uc; unsigned short us; unsigned int ui; unsigned long ul; {}

call1b (us, ui, ul, uc)
unsigned short us; unsigned int ui; unsigned long ul; unsigned char uc; {}

call1c (ui, ul, uc, us)
unsigned int ui; unsigned long ul; unsigned char uc; unsigned short us; {}

call1d (ul, uc, us, ui)
unsigned long ul; unsigned char uc; unsigned short us; unsigned int ui; {}

call1e (uc1, ul, uc2, ui, uc3, us, uc4, uc5)
unsigned char uc1; unsigned long ul; unsigned char uc2; unsigned int ui;
unsigned char uc3; unsigned short us; unsigned char uc4; unsigned char uc5; {}


/* Test various permutations and interleaving of integral arguments with
   floating point arguments. */


call2a (c, f1, s, d1, i, f2, l, d2)
char c; float f1; short s; double d1; int i; float f2; long l; double d2; {}

call2b (f1, s, d1, i, f2, l, d2, c)
float f1; short s; double d1; int i; float f2; long l; double d2; char c; {}

call2c (s, d1, i, f2, l, d2, c, f1)
short s; double d1; int i; float f2; long l; double d2; char c; float f1; {}

call2d (d1, i, f2, l, d2, c, f1, s)
double d1; int i; float f2; long l; double d2; char c; float f1; short s; {}

call2e (i, f2, l, d2, c, f1, s, d1)
int i; float f2; long l; double d2; char c; float f1; short s; double d1; {}

call2f (f2, l, d2, c, f1, s, d1, i)
float f2; long l; double d2; char c; float f1; short s; double d1; int i; {}

call2g (l, d2, c, f1, s, d1, i, f2)
long l; double d2; char c; float f1; short s; double d1; int i; float f2; {}

call2h (d2, c, f1, s, d1, i, f2, l)
double d2; char c; float f1; short s; double d1; int i; float f2; long l; {}

call2i (c1, f1, c2, c3, d1, c4, c5, c6, f2, s, c7, d2)
char c1; float f1; char c2; char c3; double d1; char c4; char c5; char c6;
float f2; short s; char c7; double d2; {}


/* Test pointers to various integral and floating types. */


call3a (cp, sp, ip, lp)
char *cp; short *sp; int *ip; long *lp; {}

call3b (ucp, usp, uip, ulp)
unsigned char *ucp; unsigned short *usp; unsigned int *uip;
unsigned long *ulp; {}

call3c (fp, dp)
float *fp; double *dp; {}


/* Test passing structures and unions by reference. */


call4a (stp)
struct stag *stp; {}

call4b (unp)
union utag *unp; {}


/* Test passing structures and unions by value. */


call5a (st)
struct stag st; {}

call5b (un)
union utag un; {}


/* Test shuffling of args */


call6a (c, s, i, l, f, d, uc, us, ui, ul)
char c; short s; int i; long l; float f; double d;
unsigned char uc; unsigned short us; unsigned int ui; unsigned long ul;
{
    call6b (s, i, l, f, d, uc, us, ui, ul);
}

call6b (s, i, l, f, d, uc, us, ui, ul)
short s; int i; long l; float f; double d;
unsigned char uc; unsigned short us; unsigned int ui; unsigned long ul;
{
    call6c (i, l, f, d, uc, us, ui, ul);
}

call6c (i, l, f, d, uc, us, ui, ul)
int i; long l; float f; double d;
unsigned char uc; unsigned short us; unsigned int ui; unsigned long ul;
{
    call6d (l, f, d, uc, us, ui, ul);
}

call6d (l, f, d, uc, us, ui, ul)
long l; float f; double d;
unsigned char uc; unsigned short us; unsigned int ui; unsigned long ul;
{
    call6e (f, d, uc, us, ui, ul);
}

call6e (f, d, uc, us, ui, ul)
float f; double d;
unsigned char uc; unsigned short us; unsigned int ui; unsigned long ul;
{
    call6f (d, uc, us, ui, ul);
}

call6f (d, uc, us, ui, ul)
double d;
unsigned char uc; unsigned short us; unsigned int ui; unsigned long ul;
{
    call6g (uc, us, ui, ul);
}

call6g (uc, us, ui, ul)
unsigned char uc; unsigned short us; unsigned int ui; unsigned long ul;
{
    call6h (us, ui, ul);
}

call6h (us, ui, ul)
unsigned short us; unsigned int ui; unsigned long ul;
{
    call6i (ui, ul);
}

call6i (ui, ul)
unsigned int ui; unsigned long ul;
{
    call6j (ul);
}

call6j (ul)
unsigned long ul;
{
    call6k ();
}

call6k ()
{
}


/*  Test shuffling of args, round robin */


call7a (c, i, s, l, f, uc, d, us, ul, ui)
char c; int i; short s; long l; float f; unsigned char uc; double d; unsigned short us; unsigned long ul; unsigned int ui;
{
    call7b (i, s, l, f, uc, d, us, ul, ui, c);
}

call7b (i, s, l, f, uc, d, us, ul, ui, c)
int i; short s; long l; float f; unsigned char uc; double d; unsigned short us; unsigned long ul; unsigned int ui; char c;
{
    call7c (s, l, f, uc, d, us, ul, ui, c, i);
}

call7c (s, l, f, uc, d, us, ul, ui, c, i)
short s; long l; float f; unsigned char uc; double d; unsigned short us; unsigned long ul; unsigned int ui; char c; int i;
{
    call7d (l, f, uc, d, us, ul, ui, c, i, s);
}

call7d (l, f, uc, d, us, ul, ui, c, i, s)
long l; float f; unsigned char uc; double d; unsigned short us; unsigned long ul; unsigned int ui; char c; int i; short s;
{
    call7e (f, uc, d, us, ul, ui, c, i, s, l);
}

call7e (f, uc, d, us, ul, ui, c, i, s, l)
float f; unsigned char uc; double d; unsigned short us; unsigned long ul; unsigned int ui; char c; int i; short s; long l;
{
    call7f (uc, d, us, ul, ui, c, i, s, l, f);
}

call7f (uc, d, us, ul, ui, c, i, s, l, f)
unsigned char uc; double d; unsigned short us; unsigned long ul; unsigned int ui; char c; int i; short s; long l; float f;
{
    call7g (d, us, ul, ui, c, i, s, l, f, uc);
}

call7g (d, us, ul, ui, c, i, s, l, f, uc)
double d; unsigned short us; unsigned long ul; unsigned int ui; char c; int i; short s; long l; float f; unsigned char uc;
{
    call7h (us, ul, ui, c, i, s, l, f, uc, d);
}

call7h (us, ul, ui, c, i, s, l, f, uc, d)
unsigned short us; unsigned long ul; unsigned int ui; char c; int i; short s; long l; float f; unsigned char uc; double d;
{
    call7i (ul, ui, c, i, s, l, f, uc, d, us);
}

call7i (ul, ui, c, i, s, l, f, uc, d, us)
unsigned long ul; unsigned int ui; char c; int i; short s; long l; float f; unsigned char uc; double d; unsigned short us;
{
    call7j (ui, c, i, s, l, f, uc, d, us, ul);
}

call7j (ui, c, i, s, l, f, uc, d, us, ul)
unsigned int ui; char c; int i; short s; long l; float f; unsigned char uc; double d; unsigned short us; unsigned long ul;
{
    call7k (c, i, s, l, f, uc, d, us, ul, ui);
}

call7k (c, i, s, l, f, uc, d, us, ul, ui)
char c; int i; short s; long l; float f; unsigned char uc; double d; unsigned short us; unsigned long ul; unsigned int ui;
{
}


/*  Test printing of structures passed as arguments to recursive functions. */


typedef struct s
{
  short s;
  int i;
  long l;
} SVAL;	

hitbottom ()
{
}

void recurse (a, depth)
SVAL a;
int depth;
{
  a.s = a.i = a.l = --depth;
  if (depth == 0)
    hitbottom ();
  else
    recurse (a, depth);
}

test_struct_args ()
{
  SVAL s; s.s = 5; s.i = 5; s.l = 5;

  recurse (s, 5);
}

/*======================================================================*/

main ()
{
  /* Test calling with basic integer types */
  call0a (c, s, i, l);
  call0b (s, i, l, c);
  call0c (i, l, c, s);
  call0d (l, c, s, i);
  call0e (c, l, c, i, c, s, c, c);

  /* Test calling with unsigned integer types */
  call1a (uc, us, ui, ul);
  call1b (us, ui, ul, uc);
  call1c (ui, ul, uc, us);
  call1d (ul, uc, us, ui);
  call1e (uc, ul, uc, ui, uc, us, uc, uc);

  /* Test calling with integral types mixed with floating point types */
  call2a (c, f, s, d, i, f, l, d);
  call2b (f, s, d, i, f, l, d, c);
  call2c (s, d, i, f, l, d, c, f);
  call2d (d, i, f, l, d, c, f, s);
  call2e (i, f, l, d, c, f, s, d);
  call2f (f, l, d, c, f, s, d, i);
  call2g (l, d, c, f, s, d, i, f);
  call2h (d, c, f, s, d, i, f, l);
  call2i (c, f, c, c, d, c, c, c, f, s, c, d);;

  /* Test dereferencing pointers to various integral and floating types */

  call3a (cp, sp, ip, lp);
  call3b (ucp, usp, uip, ulp);
  call3c (fp, dp);

  /* Test dereferencing pointers to structs and unions */

  call4a (stp);
  un.u1 = 1;
  call4b (unp);

  /* Test calling with structures and unions. */

  call5a (st);
  un.u1 = 2;
  call5b (un);

  /* Test shuffling of args */

  call6a (c, s, i, l, f, d, uc, us, ui, ul);
  call7a (c, i, s, l, f, uc, d, us, ul, ui);
  
  /* Test passing structures recursively. */

  test_struct_args ();

}
