.\"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
.\"# File:        cmail.man
.\"#
.\"# Author:      Evan Welsh
.\"#
.\"# Email:       welsh@epcc.ed.ac.uk
.\"#
.\"# Modified:    $Date: 1993/09/05 11:25:01 $
.\"#              $Revision: 1.3 $
.\"# Summary:     Man page for cmail
.\"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
.\"
.TH CMAIL 1
.PD
.ad b
.SH NAME
cmail \- an email chess helper
.SH SYNOPSIS
\fBcmail\fR
[\|\fB-c\fR\|]
[\|\fB-w\fR\|]
[\|\fB-v\fR\|]
[\|\fB-[\|no\|]mail\fR\|]
[\|\fB-[\|no\|]xboard\fR\|]
[\|\fB-remail\fR\|]
[\|\fB-game\fR
.IR name
\|]
[\|\fB-me\fR
.IR name
\|]
[\|\fB-opp\fR
.IR name
\|]
[\|\fB-oppaddr\fR
.IR address
\|]
[\|\fB-dir\fR
.IR directory
\|]
[\|\fB-gamesfile\fR
.IR file
\|]
[\|\fB-aliasesfile\fR
.IR file
\|]
[\|\fB-logfile\fR
.IR file
\|]
[\|\fB-td\fR
.IR delay
\|]
.SH DESCRIPTION
.PP
The \fIcmail\fP program will help you play chess by email with opponents of
your choice using an X interface.  To use it, you will need to be able to
run \fIxboard\fP with which \fIcmail\fP is distributed, available by
anonymous FTP from numerous sites around the world. It has been tested with
\fIxboard 3.0\fP; it may require modification for other versions.
.SH OPTIONS
You will usually run cmail without giving any options.  See the next
section for instructions.
.TP 8
.B \-c
Shows the conditions of the GNU General Public License.
.TP 8
.B \-w
Shows the warranty notice of the GNU General Public License.
.TP 8
.B \-v
Provides verbose output useful for debugging.
.TP 8
.B \-[\|no\|]mail
Invokes or inhibits the sending of a mail message containing the move.
.TP 8
.B \-[\|no\|]xboard
Invokes or inhibits the running of \fIxboard\fP on the game file.
.TP 8
.B \-remail
Resends the last mail message for that game. This inhibits running
\fIxboard\fP.
.TP 8
.B \-game \fIname\fP
The name of the game to be processed.
.TP 8
.B \-me \fIname\fP
The user's own alias. This defaults to the environment variable
$CMAIL_ADDRESS or failing that the user's login name.
.TP 8
.B \-opp \fIname\fP
An alias for the opponent.
.TP 8
.B \-oppaddr \fIaddress\fP
The opponent's email address.
.TP 8
.B \-dir \fIdirectory\fP
The directory in which \fIcmail\fP keeps its files. This defaults to the
environment variable $CMAIL_DIR or failing that $CHESSDIR, $HOME/Chess or
~/Chess. It will be created if it does not exist.
.TP 8
.B \-gamesfile \fIfile\fP
A file containing a list of games with email addresses. This defaults to
the environment variable $CMAIL_GAMES or failing that .cmailgames.
.TP 8
.B \-aliasesfile \fIfile\fP
A file containing one or more aliases for a set of email addresses. This
defaults to the environment variable $CMAIL_ALIASES or failing that
.cmailaliases.
.TP 8
.B \-logfile \fIfile\fP
A file in which to dump verbose debugging messages that are invoked with
the
.B \-v
option.
.TP 8
.B \-td \fIdelay\fP
This is passed to \fIxboard\fP to set the speed at which the moves are
displayed on start-up. It defaults to the environment variable
$CMAIL_TIME_DELAY if set.
.SH STARTING A GAME
Type \fIcmail\fP from a shell.  After an opening message, you will be
prompted for a game name, which is optional -- if you simply press return,
the game name will take the form \fIyou\fP-VS-\fIopponent\fP.  You will
next be prompted for the name of your opponent.  If you haven't played this
person before, you will also be prompted for his/her email address.
\fIcmail\fP will invoke \fIxboard\fP.  Make your first move and select
\fIExit\fP from the \fIFile\fP menu.  If all is well, \fIcmail\fP will mail
a copy of the move to your opponent, and you will get a confirmation
message.  If you decide not to make a move after all, select \fIReset
Game\fP from the \fIFile\fP menu and then select \fIExit\fP.
.SH ANSWERING A MOVE
When you get a message from an opponent containing a move in one of your
games, simply pipe the message through \fIcmail\fP.  In some mailers this
is as simple as typing "| \fIcmail\fP" at the proper message, while in
others you may have to save the message to a file and do "\fIcmail\fP <
file" at the command line.  In either case \fIcmail\fP will update the
appropriate game log files, and start \fIxboard\fP.  As before, simply make
a move and select \fIExit\fP from the \fIFile\fP menu.  If you want to look
at a variation and play several moves, go ahead, but when you want to send
your move, select \fIReload Same Game\fP from the \fIFile\fP menu to get
back to the original position, then make the move you want and select
\fIExit\fP.  Don't just undo the extra moves with \fIBackward\fP since
those moves will still be sent with the message.  Also as before, if you
decide you aren't ready to make a move now, select \fIReset Game\fP and
then \fIExit\fP.
.PP
When you decide you are ready to make a move it isn't necessary to pipe
the message through \fIcmail\fP again. You can use \fIcmail\fP from the
command line just as when starting the game. But this time you only need to
type in the name of the game. Note that you don't have to be in the
\fIcmail\fP directory when you run it from the command line.
.SH LIMITATIONS
\fIcmail\fP currently doesn't provide much error checking.  If you exit
from \fIxboard\fP without either moving or selecting \fIReset Game\fP, or
if you make more than one move before you exit (without using \fIReload
Same Game\fP to undo the extra moves as described above), or if you go back
and change the previous game history, or if you exit when the display does
not show the current game position, \fIcmail\fP will send a bogus message
to your opponent.
.SH FILES
"\fI.cmailgames\fP"
contains a list of games with the email addresses of the opponents.
.PP
"\fI.cmailaliases\fP"
contains one or more aliases for a set of email addresses.
.SH BUGS
No known bugs.
.SH BUG REPORTS
I make no promises but if you send bug reports/suggestions to
welsh@epcc.ed.ac.uk I'll do my best to fix/implement them.
.SH COMMENTS
This perl script was hacked together over a period of a few months and
perhaps it should really be converted to C at some point.
.SH AUTHOR
Copyright (C) 1993  Free Software Foundation, Inc.
.PP
\fIcmail\fP is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
\fIcmail\fP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with cmail; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.sp
.ta 1.0i 3.0i
.nf
Author:	Evan Welsh <welsh@epcc.ed.ac.uk>
	Edinburgh Parallel Computing Centre
	JCMB, Kings Buildings
	The University of Edinburgh
	Edinburgh EH9 3JZ
	Scotland
.fi
.SH CONTRIBUTORS
.PP
Patrick Surry helped with design, testing and documentation.
.PP
Tim Mann helped integrate \fIcmail\fP with \fIxboard\fP.
.SH SEE ALSO
\fIxboard\fP(1)


