%{
/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	latex_latin1

extern int diacritics_only;

%}

After			[ \t]*(\{\})?

%%
\\#			{ if (diacritics_only) ECHO; else output ('#'); }
\\\$			{ if (diacritics_only) ECHO; else output ('$'); }
\\%			{ if (diacritics_only) ECHO; else output ('%'); }
\\&			{ if (diacritics_only) ECHO; else output ('&'); }
\\_			{ if (diacritics_only) ECHO; else output ('_'); }
\\\{			{ if (diacritics_only) ECHO; else output ('{'); }
\\\}			{ if (diacritics_only) ECHO; else output ('}'); }

\\backslash{After}	{ if (diacritics_only) ECHO; else output ('\\'); }
"\\ "			{ if (diacritics_only) ECHO; else output ('\240'); }
"!'"			{ if (diacritics_only) ECHO; else output ('\241'); }





"\\S{}"			{ if (diacritics_only) ECHO; else output ('\247'); }
"\\\"{}"		{ if (diacritics_only) ECHO; else output ('\250'); }


"``"			{ if (diacritics_only) ECHO; else output ('\253'); }
"\\neg{}"		{ if (diacritics_only) ECHO; else output ('\254'); }
"\\-"			{ if (diacritics_only) ECHO; else output ('\255'); }


"\\mbox{$^\\circ$}"	{ if (diacritics_only) ECHO; else output ('\260'); }
"\\mbox{$\\pm$}"	{ if (diacritics_only) ECHO; else output ('\261'); }
"\\mbox{$^2$}"		{ if (diacritics_only) ECHO; else output ('\262'); }
"\\mbox{$^3$}"		{ if (diacritics_only) ECHO; else output ('\263'); }
"\\'{}"			{ if (diacritics_only) ECHO; else output ('\264'); }
"\\mbox{$\\mu$}"	{ if (diacritics_only) ECHO; else output ('\265'); }

"\\cdotp"		{ if (diacritics_only) ECHO; else output ('\267'); }
"\\,{}"			{ if (diacritics_only) ECHO; else output ('\270'); }
"\\mbox{$^1$}"		{ if (diacritics_only) ECHO; else output ('\271'); }

"''"			{ if (diacritics_only) ECHO; else output ('\273'); }
"\\frac1/4{}"		{ if (diacritics_only) ECHO; else output ('\274'); }
"\\frac1/2{}"		{ if (diacritics_only) ECHO; else output ('\275'); }
"\\frac3/4{}"		{ if (diacritics_only) ECHO; else output ('\276'); }
"?'"			{ if (diacritics_only) ECHO; else output ('\277'); }
"\\`A"			{ output ('\300'); }
"\\'A"			{ output ('\301'); }
"\\^A"			{ output ('\302'); }
"\\~A"			{ output ('\303'); }
"\\\"A"			{ output ('\304'); }
"\\AA{}"		{ output ('\305'); }
"\\AE{}"		{ output ('\306'); }
"\\c C"			{ output ('\307'); }
"\\c{C}"		{ output ('\307'); }
"\\`E"			{ output ('\310'); }
"\\'E"			{ output ('\311'); }
"\\^E"			{ output ('\312'); }
"\\\"E"			{ output ('\313'); }
"\\`I"			{ output ('\314'); }
"\\'I"			{ output ('\315'); }
"\\^I"			{ output ('\316'); }
"\\\"I"			{ output ('\317'); }

"\\~N"			{ output ('\321'); }
"\\`O"			{ output ('\322'); }
"\\'O"			{ output ('\323'); }
"\\^O"			{ output ('\324'); }
"\\~O"			{ output ('\325'); }
"\\\"O"			{ output ('\326'); }

"\\O{}"			{ output ('\330'); }
"\\`U"			{ output ('\331'); }
"\\'U"			{ output ('\332'); }
"\\^U"			{ output ('\333'); }
"\\\"U"			{ output ('\334'); }
"\\'Y"			{ output ('\335'); }

"\\ss{}"		{ output ('\337'); }
"\\`a"			{ output ('\340'); }
"\\'a"			{ output ('\341'); }
"\\^a"			{ output ('\342'); }
"\\~a"			{ output ('\343'); }
"\\\"a"			{ output ('\344'); }
"\\aa{}"		{ output ('\345'); }
"\\ae{}"		{ output ('\346'); }
"\\c c"			{ output ('\347'); }
"\\c{c}"		{ output ('\347'); }
"\\`e"			{ output ('\350'); }
"\\'e"			{ output ('\351'); }
"\\^e"			{ output ('\352'); }
"\\\"e"			{ output ('\353'); }
"\\`\\i{}"		{ output ('\354'); }
"\\`{\\i}"		{ output ('\354'); }
"\\'\\i{}"		{ output ('\355'); }
"\\'{\\i}"		{ output ('\355'); }
"\\^\\i{}"		{ output ('\356'); }
"\\^{\\i}"		{ output ('\356'); }
"\\\"\\i{}"		{ output ('\357'); }
"\\\"{\\i}"		{ output ('\357'); }

"\\~n"			{ output ('\361'); }
"\\`o"			{ output ('\362'); }
"\\'o"			{ output ('\363'); }
"\\^o"			{ output ('\364'); }
"\\~o"			{ output ('\365'); }
"\\\"o"			{ output ('\366'); }

"\\o{}"			{ output ('\370'); }
"\\`u"			{ output ('\371'); }
"\\'u"			{ output ('\372'); }
"\\^u"			{ output ('\373'); }
"\\\"u"			{ output ('\374'); }
"\\'y"			{ output ('\375'); }

"\\\"y"			{ output ('\377'); }
