%{
/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	texte_ascii

extern char diaeresis_char;	/* Character for diaeresis */

void
texte_ascii_diaeresis (void)
{
  int counter;

  for (counter = 0; counter < yyleng; counter++)
    if (yytext[counter+1] == diaeresis_char)
      {
	output ('"');
	output ('\b');
	output (yytext[counter]);
	counter++;
      }
    else
      output (yytext[counter]);
}
%}

s			(^|[^a-zA-Z])
d			[:"]
l			[a-zA-Z]

%%
[eE]'''			{ output ('\''); output ('\b'); output (yytext[0]);
			  output ('"'); output ('\b'); output ('>'); }
[eE]''			{ output (yytext[0]);
			  output ('"'); output ('\b'); output ('>'); }
[eE]'			{ output ('\''); output ('\b'); output (yytext[0]); }
[aAeEiIoOuU][`^]	{ output (yytext[1]); output ('\b');
			  output (yytext[0]); } 
[cC]\,/[aAoOuU]		{ output (','); output ('\b'); output (yytext[0]); }
[aAeEiIoOuU]{d}/{l}	{ output ('"'); output ('\b'); output (yytext[0]); } 

{s}[Bb]esaigue{d}	{ texte_ascii_diaeresis (); }
{s}[Cc]igue{d}		{ texte_ascii_diaeresis (); }
{s}[Aa]igue{d}		{ texte_ascii_diaeresis (); }
{s}[Aa]mbigue{d}	{ texte_ascii_diaeresis (); }
{s}[Cc]ontigue{d}	{ texte_ascii_diaeresis (); }
{s}[Ee]xigue{d}		{ texte_ascii_diaeresis (); }
{s}[Ss]ubaigue{d}	{ texte_ascii_diaeresis (); }
{s}[Ss]uraigue{d}	{ texte_ascii_diaeresis (); }
{s}[Aa]i{d}		{ texte_ascii_diaeresis (); }
{s}[Cc]ongai{d}		{ texte_ascii_diaeresis (); }
{s}[Gg]oi{d}		{ texte_ascii_diaeresis (); }
{s}[Hh]ai{d}kai{d}	{ if (yytext[4] == diaeresis_char)
			    texte_ascii_diaeresis ();
			  else
			    ECHO;
			}
{s}[Ii]noui{d}		{ texte_ascii_diaeresis (); }
[JjTtLl]'[Aa][Ii]{d}	{ ECHO; }
{s}[Ss]ai{d}		{ texte_ascii_diaeresis (); }
{s}[Ss]amurai{d}	{ texte_ascii_diaeresis (); }
{s}[Tt]hai{d}		{ texte_ascii_diaeresis (); }
{s}[Tt]okai{d}		{ texte_ascii_diaeresis (); }
{s}[Cc]anoe{d}		{ texte_ascii_diaeresis (); }
{s}Esau{d}		{ texte_ascii_diaeresis (); }

``			{ output ('"'); output ('\b'); output ('<'); }
''			{ output ('"'); output ('\b'); output ('>'); }
