%{
/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1989.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	texte_latin1

extern char diaeresis_char;	/* Character for diaeresis */

void
texte_latin1_diaeresis (void)
{
  int counter;

  for (counter = 0; counter < yyleng; counter++)
    if (yytext[counter+1] == diaeresis_char)
      {
	switch (yytext[counter])
	  {
	    /* The following #ifdef removes the case 'A': this seemingly
	       unrelated line triggers a `NULL in input' diagnostic in flex.
	       Would you believe?  */
#if 0
	  case 'A': output ('\304'); break;
#endif
	  case 'E': output ('\313'); break;
	  case 'I': output ('\317'); break;
	  case 'O': output ('\326'); break;
	  case 'U': output ('\334'); break;
	  case 'a': output ('\344'); break;
	  case 'e': output ('\353'); break;
	  case 'i': output ('\357'); break;
	  case 'o': output ('\366'); break;
	  case 'u': output ('\374'); break;
	  case 'y': output ('\377'); break;
	  default:  output (yytext[counter]);
	  }
	counter++;
      }
    else
      output (yytext[counter]);
}
%}

s			(^|[^a-zA-Z])
d			[:"]
l			[a-zA-Z]

%%

``			{ output ('\253'); }
''			{ output ('\273'); }

A`			{ output ('\300'); }
A^			{ output ('\302'); }
A{d}/{l}		{ output ('\304'); }
a`			{ output ('\340'); }
a^			{ output ('\342'); }
a{d}/{l}		{ output ('\344'); }

C\,/[aAoOuU]		{ output ('\307'); }
c\,/[aAoOuU]		{ output ('\347'); }

E`			{ output ('\310'); }
E'''			{ output ('\311'); output ('\273'); }
E''			{ output ('E'); output ('\273'); }
E'			{ output ('\311'); }
E^			{ output ('\312'); }
E{d}/{l}		{ output ('\313'); }
e`			{ output ('\350'); }
e'''			{ output ('\351'); output ('\273'); }
e''			{ output ('e'); output ('\273'); }
e'			{ output ('\351'); }
e^			{ output ('\352'); }
e{d}/{l}		{ output ('\353'); }

I`			{ output ('\314'); }
I^			{ output ('\316'); }
I{d}/{l}		{ output ('\317'); }
i`			{ output ('\354'); }
i^			{ output ('\356'); }
i{d}/{l}		{ output ('\357'); }

O`			{ output ('\322'); }
O^			{ output ('\324'); }
O{d}/{l}		{ output ('\326'); }
o`			{ output ('\362'); }
o^			{ output ('\364'); }
o{d}/{l}		{ output ('\366'); }

U`			{ output ('\331'); }
U^			{ output ('\333'); }
U{d}/{l}		{ output ('\334'); }
u`			{ output ('\371'); }
u^			{ output ('\373'); }
u{d}/{l}		{ output ('\374'); }

Y{d}/{l}		{ output ('Y'); }
y{d}/{l}		{ output ('\337'); }

{s}[Bb]esaigue{d}	{ texte_latin1_diaeresis (); }
{s}[Cc]igue{d}		{ texte_latin1_diaeresis (); }
{s}[Aa]igue{d}		{ texte_latin1_diaeresis (); }
{s}[Aa]mbigue{d}	{ texte_latin1_diaeresis (); }
{s}[Cc]ontigue{d}	{ texte_latin1_diaeresis (); }
{s}[Ee]xigue{d}		{ texte_latin1_diaeresis (); }
{s}[Ss]ubaigue{d}	{ texte_latin1_diaeresis (); }
{s}[Ss]uraigue{d}	{ texte_latin1_diaeresis (); }
{s}[Aa]i{d}		{ texte_latin1_diaeresis (); }
{s}[Cc]ongai{d}		{ texte_latin1_diaeresis (); }
{s}[Gg]oi{d}		{ texte_latin1_diaeresis (); }
{s}[Hh]ai{d}kai{d}	{ if (yytext[4] == diaeresis_char)
			    texte_latin1_diaeresis ();
			  else
			    ECHO;
			}
{s}[Ii]noui{d}		{ texte_latin1_diaeresis (); }
[JjTtLl]'[Aa][Ii]{d}	{ ECHO; }
{s}[Ss]ai{d}		{ texte_latin1_diaeresis (); }
{s}[Ss]amurai{d}	{ texte_latin1_diaeresis (); }
{s}[Tt]hai{d}		{ texte_latin1_diaeresis (); }
{s}[Tt]okai{d}		{ texte_latin1_diaeresis (); }
{s}[Cc]anoe{d}		{ texte_latin1_diaeresis (); }
{s}Esau{d}		{ texte_latin1_diaeresis (); }
