#ifndef lint
static char SccsDefId[] = "%W%  %G%";
#endif

/* Module:	borders.h
 * Purpose:	Define the default button border patterns
 * Defines:	defBorders
 * Xlib calls:	none
 * Note:	Set by MakeButtonBox()
 * Note:	Used by btn_MakeBdrBitmap() in border.c to put border pattern
 *		on buttons.  Included by create.c where assignments are made.
 * Copyright:	1989, 1990 Smithsonian Astrophysical Observatory
 *		You may do anything you like with this file except remove
 *		this copyright.  The Smithsonian Astrophysical Observatory
 *		makes no representations about the suitability of this
 *		software for any purpose.  It is provided "as is" without
 *		express or implied warranty.
 * Modified:	{0} Michael VanHilst	initial version		21 March 1989
 *		{1} MVH map expanded to 4x32 covering 4 corners	26 March 1990
 *		{n} <who> -- <does what> -- <when>
 */

/*
 * Data:	off_out_button_bits
 * Purpose:	32x32 bit border pattern
 *		for button in off state, not occupied by pointer
 * Note:	compatable with X11 bitmap tool
 */
#define off_out_button_width 32
#define off_out_button_height 32
static char off_out_button_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x07, 0xf8, 0xff, 0xff, 0x1f,
   0x3c, 0x00, 0x00, 0x3c, 0x0c, 0x00, 0x00, 0x30, 0x0e, 0x00, 0x00, 0x70,
   0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
   0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
   0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
   0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
   0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
   0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
   0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x0e, 0x00, 0x00, 0x70,
   0x0c, 0x00, 0x00, 0x30, 0x3c, 0x00, 0x00, 0x3c, 0xf8, 0xff, 0xff, 0x1f,
   0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00};

/*
 * Data:	off_in_button_bits
 * Purpose:	32x32 bit border pattern
 *		for button in off state, occupied by pointer
 * Note:	compatable with X11 bitmap tool
 */
#define off_in_button_width 32
#define off_in_button_height 32
static char off_in_button_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x07, 0xf8, 0xff, 0xff, 0x1f,
  0x3c, 0x00, 0x00, 0x3c, 0x8c, 0xff, 0xff, 0x31, 0xee, 0xff, 0xff, 0x77,
  0xe6, 0x00, 0x00, 0x67, 0x76, 0x00, 0x00, 0x6e, 0x36, 0x00, 0x00, 0x6c,
  0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c,
  0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c,
  0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c,
  0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c,
  0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c,
  0x76, 0x00, 0x00, 0x6e, 0xe6, 0x00, 0x00, 0x67, 0xee, 0xff, 0xff, 0x77,
  0x8c, 0xff, 0xff, 0x31, 0x3c, 0x00, 0x00, 0x3c, 0xf8, 0xff, 0xff, 0x1f,
  0xe0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00};

/*
 * Data:	on_out_button_bits
 * Purpose:	32x32 bit border pattern
 *		for button in on state, not occupied by pointer
 * Note:	compatable with X11 bitmap tool
 */
#define on_out_button_width 32
#define on_out_button_height 32
static char on_out_button_bits[] = {
 0x0f, 0x00, 0x00, 0xf0, 0xe3, 0xff, 0xff, 0xc7, 0xf9, 0xff, 0xff, 0x9f,
 0x3d, 0x00, 0x00, 0xbc, 0x0c, 0x00, 0x00, 0x30, 0x0e, 0x00, 0x00, 0x70,
 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60,
 0x06, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x60, 0x0e, 0x00, 0x00, 0x70,
 0x0c, 0x00, 0x00, 0x30, 0x3d, 0x00, 0x00, 0xbc, 0xf9, 0xff, 0xff, 0x9f,
 0xe3, 0xff, 0xff, 0xc7, 0x0f, 0x00, 0x00, 0xf0};

/*
 * Data:	on_in_button_bits
 * Purpose:	32x32 bit border pattern
 *		for button in on state, occupied by pointer
 * Note:	compatable with X11 bitmap tool
 */
#define on_in_button_width 32
#define on_in_button_height 32
static char on_in_button_bits[] = {
 0x0f, 0x00, 0x00, 0xf0, 0xe3, 0xff, 0xff, 0xc7, 0xf9, 0xff, 0xff, 0x9f,
 0x3d, 0x00, 0x00, 0xbc, 0x8c, 0xff, 0xff, 0x31, 0xee, 0xff, 0xff, 0x77,
 0xe6, 0x00, 0x00, 0x67, 0x76, 0x00, 0x00, 0x6e, 0x36, 0x00, 0x00, 0x6c,
 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c,
 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c,
 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c,
 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c,
 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c, 0x36, 0x00, 0x00, 0x6c,
 0x76, 0x00, 0x00, 0x6e, 0xe6, 0x00, 0x00, 0x67, 0xee, 0xff, 0xff, 0x77,
 0x8c, 0xff, 0xff, 0x31, 0x3d, 0x00, 0x00, 0xbc, 0xf9, 0xff, 0xff, 0x9f,
 0xe3, 0xff, 0xff, 0xc7, 0x0f, 0x00, 0x00, 0xf0};

/*
 * Data:	defBorders
 * Purpose:	Default border patterns for four states of button
 * Note:	Used by MakeButtonBox in MakeBox.c
 * Note:	ButtonBorders defined in Buttons.h
 */
static BorderPatterns defBorders = {
  (unsigned char *)off_out_button_bits,
  (unsigned char *)off_in_button_bits,
  (unsigned char *)on_out_button_bits,
  (unsigned char *)on_in_button_bits };
