/*
 * $Header: /home/campbell/Languages/Scheme/scm/x-scm/RCS/ol.c,v 1.1 1992/07/03 03:06:52 campbell Beta $
 *
 * Author: Larry Campbell (campbell@redsox.bsw.com)
 *
 * Copyright 1992 by The Boston Software Works, Inc.
 * Permission to use for any purpose whatsoever granted, as long
 * as this copyright notice remains intact.  Please send bug fixes
 * or enhancements to the above email address.
 *
 * Class and function definitions for scm interface to OpenLook
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/AbbrevMenu.h>
#include <Xol/BulletinBo.h>
#include <Xol/Caption.h>
#include <Xol/CheckBox.h>
#include <Xol/ControlAre.h>
#include <Xol/Exclusives.h>
#include <Xol/FooterPane.h>
#include <Xol/Form.h>
#include <Xol/Gauge.h>
#include <Xol/Menu.h>
#include <Xol/MenuButton.h>
#include <Xol/Nonexclusi.h>
#include <Xol/Notice.h>
#include <Xol/OblongButt.h>
#include <Xol/PopupWindo.h>
#include <Xol/RectButton.h>
#include <Xol/RubberTile.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/ScrollingL.h>
#include <Xol/Slider.h>
#include <Xol/StaticText.h>
#include <Xol/Stub.h>
#include <Xol/TextEdit.h>
#include <Xol/TextField.h>

#include "scm.h"
#include "xt.h"

static char	s_ol_initialize[] = "ol:initialize";

xt_widget_class_t ol_widget_classes[] = {
    "ol:abbrev-menu-button",	&abbrevMenuButtonWidgetClass,
    "ol:bulletin-board",	&bulletinBoardWidgetClass,
    "ol:caption",		&captionWidgetClass,
    "ol:check-box",		&checkBoxWidgetClass,
    "ol:control-area",		&controlAreaWidgetClass,
    "ol:exclusives",		&exclusivesWidgetClass,
    "ol:footer-panel",		&footerPanelWidgetClass,
    "ol:form",			&formWidgetClass,
    "ol:gauge",			&gaugeWidgetClass,
    "ol:menu-button",		&menuButtonWidgetClass,
    "ol:menu-button-gadget",	&menuButtonGadgetClass,
    "ol:menu-shell",		&menuShellWidgetClass,
    "ol:nonexclusives",		&nonexclusivesWidgetClass,
    "ol:notice-shell",		&noticeShellWidgetClass,
    "ol:oblong-button",		&oblongButtonWidgetClass,
    "ol:oblong-button-gadget",	&oblongButtonGadgetClass,
    "ol:popup-window-shell",	&popupWindowShellWidgetClass,
    "ol:rect-button",		&rectButtonWidgetClass,
    "ol:rubber-tile",		&rubberTileWidgetClass,
    "ol:scrollbar",		&scrollbarWidgetClass,
    "ol:scrolled-window",	&scrolledWindowWidgetClass,
    "ol:scrolling-list",	&scrollingListWidgetClass,
    "ol:slider",		&sliderWidgetClass,
    "ol:static-text",		&staticTextWidgetClass,
    "ol:stub",			&stubWidgetClass,
    "ol:text-edit",		&textEditWidgetClass,
    "ol:text-field",		&textFieldWidgetClass
};


SCM ol_initialize(sname, sclass, args)
SCM sname, sclass, args;
{
  Widget top_level;
  char *argv[1];
  int argc;

  ASSERT(NIMP(sname) && STRINGP(sname), args, ARG1, s_ol_initialize);
  ASSERT(NIMP(sclass) && STRINGP(sclass), args, ARG2, s_ol_initialize);

  argv[0] = CHARS(sname);
  argc = 1;
  top_level = OlInitialize(CHARS(sname), CHARS(sclass), 0, 0, &argc, argv);

  ASSERT(top_level != 0, sname, "OlInitialize error", s_ol_initialize);

  return make_widget(top_level);
}


iproc ol_lsubr2s[] = {
  {s_ol_initialize, ol_initialize},
  {0, 0}
};

void init_ol()
{
  init_iprocs(ol_lsubr2s, tc7_lsubr_2);
  xt_init_widget_classes(
    ol_widget_classes,
    XtNumber(ol_widget_classes),
    "*open-look-widget-classes*");
}
