/***********************************************************************
 *
 *	This file produces a set of Smalltalk definitions that define much of
 *	the interface to SunView.
 *
 ***********************************************************************/


/***********************************************************************
 *
 * Copyright (C) 1990, 1991 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 1, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 ***********************************************************************/


#include <stdio.h>
#include <ctype.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <suntool/window.h>
#include <suntool/textsw.h>
#include <suntool/panel.h>
#include <suntool/walkmenu.h>
#include <suntool/icon.h>

#if defined(__STDC__) 
#define ATTR_TAB(attr_name)  #attr_name, (long)(attr_name)
#else
#define ATTR_TAB(attr_name)  "attr_name", (long)(attr_name)
#endif

struct attrStruct {
  char	*name;
  long	value;
};
		   
struct attrStruct panelAttrs[] = {
  ATTR_TAB(PANEL_ITEM_X),
  ATTR_TAB(PANEL_ITEM_X_GAP),
  ATTR_TAB(PANEL_LABEL_X),
  ATTR_TAB(PANEL_VALUE_X),
  ATTR_TAB(PANEL_SLIDER_WIDTH),
  ATTR_TAB(PANEL_WIDTH),
  ATTR_TAB(PANEL_CHOICE_X),
  ATTR_TAB(PANEL_MARK_X),
  ATTR_TAB(PANEL_CHOICE_XS),
  ATTR_TAB(PANEL_MARK_XS),
  ATTR_TAB(PANEL_ITEM_Y),
  ATTR_TAB(PANEL_ITEM_Y_GAP),
  ATTR_TAB(PANEL_LABEL_Y),
  ATTR_TAB(PANEL_VALUE_Y),
  ATTR_TAB(PANEL_HEIGHT),
  ATTR_TAB(PANEL_CHOICE_Y),
  ATTR_TAB(PANEL_MARK_Y),
  ATTR_TAB(PANEL_CHOICE_YS),
  ATTR_TAB(PANEL_MARK_YS),
  ATTR_TAB(PANEL_VALUE),
  ATTR_TAB(PANEL_LABEL_DISPLAY_LENGTH),
  ATTR_TAB(PANEL_VALUE_DISPLAY_LENGTH),
  ATTR_TAB(PANEL_VALUE_STORED_LENGTH),
  ATTR_TAB(PANEL_MIN_VALUE),
  ATTR_TAB(PANEL_MAX_VALUE),
  ATTR_TAB(PANEL_CHOICE_OFFSET),
  ATTR_TAB(PANEL_TIMER_SECS),
  ATTR_TAB(PANEL_TIMER_USECS),
  ATTR_TAB(PANEL_MENU_CHOICE_VALUES),
  ATTR_TAB(PANEL_VALUE_UNDERLINED),
  ATTR_TAB(PANEL_ITEM_BOXED),
  ATTR_TAB(PANEL_LABEL_BOLD),
  ATTR_TAB(PANEL_CHOICES_BOLD),
  ATTR_TAB(PANEL_SHOW_ITEM),
  ATTR_TAB(PANEL_SHOW_VALUE),
  ATTR_TAB(PANEL_SHOW_RANGE),
  ATTR_TAB(PANEL_SHOW_MENU),
  ATTR_TAB(PANEL_SHOW_MENU_MARK),
  ATTR_TAB(PANEL_CHOOSE_ONE),
  ATTR_TAB(PANEL_ADJUSTABLE),
  ATTR_TAB(PANEL_BLINK_CARET),
  ATTR_TAB(PANEL_ACCEPT_KEYSTROKE),
  ATTR_TAB(PANEL_LABEL_SHADED),
  ATTR_TAB(PANEL_TOGGLE_VALUE),
  ATTR_TAB(PANEL_NOTIFY_LEVEL),
  ATTR_TAB(PANEL_DISPLAY_LEVEL),
  ATTR_TAB(PANEL_LAYOUT),
  ATTR_TAB(PANEL_FEEDBACK),
  ATTR_TAB(PANEL_PAINT),
  ATTR_TAB(PANEL_MOUSE_STATE),
  ATTR_TAB(PANEL_MASK_CHAR),
  ATTR_TAB(PANEL_LABEL_STRING),
  ATTR_TAB(PANEL_VALUE_STRING),
  ATTR_TAB(PANEL_NOTIFY_STRING),
  ATTR_TAB(PANEL_MENU_TITLE_STRING),
  ATTR_TAB(PANEL_NAME),
  ATTR_TAB(PANEL_CHOICE_STRINGS),
  ATTR_TAB(PANEL_MENU_CHOICE_STRINGS),
  ATTR_TAB(PANEL_CHOICE_STRING),
  ATTR_TAB(PANEL_LABEL_IMAGE),
  ATTR_TAB(PANEL_MENU_TITLE_IMAGE),
  ATTR_TAB(PANEL_MENU_MARK_IMAGE),
  ATTR_TAB(PANEL_MENU_NOMARK_IMAGE),
  ATTR_TAB(PANEL_TYPE_IMAGE),
  ATTR_TAB(PANEL_CHOICE_IMAGES),
  ATTR_TAB(PANEL_MENU_CHOICE_IMAGES),
  ATTR_TAB(PANEL_MARK_IMAGES),
  ATTR_TAB(PANEL_NOMARK_IMAGES),
  ATTR_TAB(PANEL_CHOICE_IMAGE),
  ATTR_TAB(PANEL_MARK_IMAGE),
  ATTR_TAB(PANEL_NOMARK_IMAGE),
  ATTR_TAB(PANEL_LABEL_FONT),
  ATTR_TAB(PANEL_VALUE_FONT),
  ATTR_TAB(PANEL_MENU_TITLE_FONT),
  ATTR_TAB(PANEL_FONT),
  ATTR_TAB(PANEL_CHOICE_FONTS),
  ATTR_TAB(PANEL_MENU_CHOICE_FONTS),
  ATTR_TAB(PANEL_NOTIFY_PROC),
  ATTR_TAB(PANEL_TIMER_PROC),
  ATTR_TAB(PANEL_EVENT_PROC),
  ATTR_TAB(PANEL_BACKGROUND_PROC),
  ATTR_TAB(PANEL_ITEM_RECT),
  ATTR_TAB(PANEL_PIXWIN),
  ATTR_TAB(PANEL_CLIENT_DATA),
  ATTR_TAB(PANEL_VERTICAL_SCROLLBAR),
  ATTR_TAB(PANEL_HORIZONTAL_SCROLLBAR),
  ATTR_TAB(PANEL_CURSOR),
  ATTR_TAB(PANEL_CARET_ITEM),
  ATTR_TAB(PANEL_FIRST_ITEM),
  ATTR_TAB(PANEL_NEXT_ITEM),
  ATTR_TAB(PANEL_PARENT_PANEL),
  NULL, NULL
};



struct attrStruct frameAttrs[] = {
  ATTR_TAB(FRAME_CLOSED),
  ATTR_TAB(FRAME_INHERIT_COLORS),
  ATTR_TAB(FRAME_SHOW_LABEL),
  ATTR_TAB(FRAME_SUBWINDOWS_ADJUSTABLE),
  ATTR_TAB(FRAME_LABEL),
  ATTR_TAB(FRAME_FOREGROUND_COLOR),
  ATTR_TAB(FRAME_BACKGROUND_COLOR),
  ATTR_TAB(FRAME_ICON),
  ATTR_TAB(FRAME_CLOSED_X),
  ATTR_TAB(FRAME_CLOSED_Y),
  ATTR_TAB(FRAME_CLOSED_RECT),
  ATTR_TAB(FRAME_CURRENT_RECT),
  ATTR_TAB(FRAME_OPEN_RECT),
  ATTR_TAB(FRAME_ARGS),
  ATTR_TAB(FRAME_ARGC_PTR_ARGV),
  ATTR_TAB(FRAME_CMDLINE_HELP_PROC),
  ATTR_TAB(FRAME_BORDER_STYLE),
  ATTR_TAB(FRAME_EMBOLDEN_LABEL),
  ATTR_TAB(FRAME_NTH_WINDOW),
  ATTR_TAB(FRAME_NTH_SUBWINDOW),
  ATTR_TAB(FRAME_NTH_SUBFRAME),
  ATTR_TAB(FRAME_DONE_PROC),
  ATTR_TAB(FRAME_DEFAULT_DONE_PROC),
  ATTR_TAB(FRAME_NO_CONFIRM),
  ATTR_TAB(FRAME_NULL_ATTR),
  NULL, NULL
};


struct attrStruct canvasAttrs[] = {
  ATTR_TAB(CANVAS_PIXWIN),
  ATTR_TAB(CANVAS_LEFT),
  ATTR_TAB(CANVAS_TOP),
  ATTR_TAB(CANVAS_WIDTH),
  ATTR_TAB(CANVAS_HEIGHT),
  ATTR_TAB(CANVAS_DEPTH),
  ATTR_TAB(CANVAS_MARGIN),
  ATTR_TAB(CANVAS_RETAINED),
  ATTR_TAB(CANVAS_FIXED_IMAGE),
  ATTR_TAB(CANVAS_REPAINT_PROC),
  ATTR_TAB(CANVAS_RESIZE_PROC),
  ATTR_TAB(CANVAS_AUTO_CLEAR),
  ATTR_TAB(CANVAS_AUTO_EXPAND),
  ATTR_TAB(CANVAS_AUTO_SHRINK),
  ATTR_TAB(CANVAS_FAST_MONO),
  NULL, NULL
};


struct attrStruct winAttrs[] = {
  ATTR_TAB(WIN_ERROR_MSG),
  ATTR_TAB(WIN_X),
  ATTR_TAB(WIN_Y),
  ATTR_TAB(WIN_RIGHT_OF),
  ATTR_TAB(WIN_BELOW),
  ATTR_TAB(WIN_WIDTH),
  ATTR_TAB(WIN_HEIGHT),
  ATTR_TAB(WIN_PERCENT_WIDTH),
  ATTR_TAB(WIN_PERCENT_HEIGHT),
  ATTR_TAB(WIN_COLUMNS),
  ATTR_TAB(WIN_ROWS),
  ATTR_TAB(WIN_RECT),
  ATTR_TAB(WIN_SCREEN_RECT),
  ATTR_TAB(WIN_FIT_HEIGHT),
  ATTR_TAB(WIN_FIT_WIDTH),
  ATTR_TAB(WIN_SHOW),
  ATTR_TAB(WIN_MENU),
  ATTR_TAB(WIN_CURSOR),
  ATTR_TAB(WIN_HORIZONTAL_SCROLLBAR),
  ATTR_TAB(WIN_VERTICAL_SCROLLBAR),
  ATTR_TAB(WIN_EVENT_PROC),
  ATTR_TAB(WIN_INPUT_DESIGNEE),
  ATTR_TAB(WIN_GRAB_ALL_INPUT),
  ATTR_TAB(WIN_KBD_INPUT_MASK),
  ATTR_TAB(WIN_CONSUME_KBD_EVENT),
  ATTR_TAB(WIN_IGNORE_KBD_EVENT),
  ATTR_TAB(WIN_CONSUME_KBD_EVENTS),
  ATTR_TAB(WIN_IGNORE_KBD_EVENTS),
  ATTR_TAB(WIN_PICK_INPUT_MASK),
  ATTR_TAB(WIN_CONSUME_PICK_EVENT),
  ATTR_TAB(WIN_IGNORE_PICK_EVENT),
  ATTR_TAB(WIN_CONSUME_PICK_EVENTS),
  ATTR_TAB(WIN_IGNORE_PICK_EVENTS),
  ATTR_TAB(WIN_FONT),
  ATTR_TAB(WIN_TOP_MARGIN),
  ATTR_TAB(WIN_BOTTOM_MARGIN),
  ATTR_TAB(WIN_LEFT_MARGIN),
  ATTR_TAB(WIN_RIGHT_MARGIN),
  ATTR_TAB(WIN_ROW_HEIGHT),
  ATTR_TAB(WIN_COLUMN_WIDTH),
  ATTR_TAB(WIN_ROW_GAP),
  ATTR_TAB(WIN_COLUMN_GAP),
  ATTR_TAB(WIN_TYPE),
  ATTR_TAB(WIN_OWNER),
  ATTR_TAB(WIN_NAME),
  ATTR_TAB(WIN_CLIENT_DATA),
  ATTR_TAB(WIN_IMPL_DATA),
  ATTR_TAB(WIN_FD),
  ATTR_TAB(WIN_DEVICE_NAME),
  ATTR_TAB(WIN_DEVICE_NUMBER),
  ATTR_TAB(WIN_PIXWIN),
  ATTR_TAB(WIN_MOUSE_XY),
  ATTR_TAB(WIN_SHOW_UPDATES),
  ATTR_TAB(WIN_OBJECT),
  ATTR_TAB(WIN_GET_PROC),
  ATTR_TAB(WIN_SET_PROC),
  ATTR_TAB(WIN_PRESET_PROC),
  ATTR_TAB(WIN_POSTSET_PROC),
  ATTR_TAB(WIN_LAYOUT_PROC),
  ATTR_TAB(WIN_NOTIFY_DESTROY_PROC),
  ATTR_TAB(WIN_NOTIFY_EVENT_PROC),
  ATTR_TAB(WIN_DEFAULT_EVENT_PROC),
  ATTR_TAB(WIN_CREATED),
  ATTR_TAB(WIN_COMPATIBILITY),
  ATTR_TAB(WIN_COMPATIBILITY_INFO),
  ATTR_TAB(WIN_REGISTER),
  ATTR_TAB(WIN_NOTIFY_INFO),
  ATTR_TAB(WIN_NULL_ATTR),
  ATTR_TAB(WIN_KBD_FOCUS),
  ATTR_TAB(WIN_EVENT_STATE),
  NULL, NULL
};


struct attrStruct textswAttrs[] = {
  ATTR_TAB(TEXTSW_ADJUST_IS_PENDING_DELETE),
  ATTR_TAB(TEXTSW_AGAIN_LIMIT),
  ATTR_TAB(TEXTSW_AGAIN_RECORDING),
  ATTR_TAB(TEXTSW_AUTO_INDENT),
  ATTR_TAB(TEXTSW_AUTO_SCROLL_BY),
  ATTR_TAB(TEXTSW_BLINK_CARET),
  ATTR_TAB(TEXTSW_BROWSING),
  ATTR_TAB(TEXTSW_CHECKPOINT_FREQUENCY),
  ATTR_TAB(TEXTSW_CLIENT_DATA),
  ATTR_TAB(TEXTSW_CONFIRM_OVERWRITE),
  ATTR_TAB(TEXTSW_CONTENTS),
  ATTR_TAB(TEXTSW_CONTROL_CHARS_USE_FONT),
  ATTR_TAB(TEXTSW_DESTROY_ALL_VIEWS),
  ATTR_TAB(TEXTSW_DISABLE_CD),
  ATTR_TAB(TEXTSW_DISABLE_LOAD),
  ATTR_TAB(TEXTSW_EDIT_BACK_CHAR),
  ATTR_TAB(TEXTSW_EDIT_BACK_LINE),
  ATTR_TAB(TEXTSW_EDIT_BACK_WORD),
  ATTR_TAB(TEXTSW_EDIT_COUNT),
  ATTR_TAB(TEXTSW_ERROR_MSG),
  ATTR_TAB(TEXTSW_ES_CREATE_PROC),
  ATTR_TAB(TEXTSW_FILE),
  ATTR_TAB(TEXTSW_FONT),
  ATTR_TAB(TEXTSW_HEIGHT),
  ATTR_TAB(TEXTSW_HISTORY_LIMIT),
  ATTR_TAB(TEXTSW_IGNORE_LIMIT),
  ATTR_TAB(TEXTSW_INSERT_MAKES_VISIBLE),
  ATTR_TAB(TEXTSW_INSERT_ONLY),
  ATTR_TAB(TEXTSW_INSERTION_POINT),
  ATTR_TAB(TEXTSW_LENGTH),
  ATTR_TAB(TEXTSW_LOAD_DIR_IS_CD),
  ATTR_TAB(TEXTSW_LOWER_CONTEXT),
  ATTR_TAB(TEXTSW_MEMORY_MAXIMUM),
  ATTR_TAB(TEXTSW_MENU),
  ATTR_TAB(TEXTSW_MODIFIED),
  ATTR_TAB(TEXTSW_MULTI_CLICK_SPACE),
  ATTR_TAB(TEXTSW_MULTI_CLICK_TIMEOUT),
  ATTR_TAB(TEXTSW_MUST_SHOW_CARET),
  ATTR_TAB(TEXTSW_NAME),
  ATTR_TAB(TEXTSW_NAME_TO_USE),
  ATTR_TAB(TEXTSW_NO_RESET_TO_SCRATCH),
  ATTR_TAB(TEXTSW_NO_SELECTION_SERVICE),
  ATTR_TAB(TEXTSW_NOTIFY_LEVEL),
  ATTR_TAB(TEXTSW_NOTIFY_PROC),
  ATTR_TAB(TEXTSW_PIXWIN),
  ATTR_TAB(TEXTSW_READ_ONLY),
  ATTR_TAB(TEXTSW_RESET_MODE),
  ATTR_TAB(TEXTSW_STATUS),
  ATTR_TAB(TEXTSW_STORE_CHANGES_FILE),
  ATTR_TAB(TEXTSW_STORE_SELF_IS_SAVE),
  ATTR_TAB(TEXTSW_TAB_WIDTH),
  ATTR_TAB(TEXTSW_TOOL),
  ATTR_TAB(TEXTSW_UPPER_CONTEXT),
  ATTR_TAB(TEXTSW_WIDTH),
  ATTR_TAB(TEXTSW_COALESCE_WITH),
  ATTR_TAB(TEXTSW_END_ALL_VIEWS),
  ATTR_TAB(TEXTSW_FOR_ALL_VIEWS),
  ATTR_TAB(TEXTSW_FIRST),
  ATTR_TAB(TEXTSW_FIRST_LINE),
  ATTR_TAB(TEXTSW_LEFT_MARGIN),
  ATTR_TAB(TEXTSW_LINE_BREAK_ACTION),
  ATTR_TAB(TEXTSW_RIGHT_MARGIN),
  ATTR_TAB(TEXTSW_SCROLLBAR),
  ATTR_TAB(TEXTSW_UPDATE_SCROLLBAR),
  ATTR_TAB(TEXTSW_SPARE_1),
  ATTR_TAB(TEXTSW_SPARE_2),
  NULL, NULL
};


struct attrStruct menuAttrs[] = {
  ATTR_TAB(MENU_ACTION_PROC),
  ATTR_TAB(MENU_ACTION),
  ATTR_TAB(MENU_ACTION_IMAGE),
  ATTR_TAB(MENU_ACTION_ITEM),
  ATTR_TAB(MENU_APPEND_ITEM),
  ATTR_TAB(MENU_APPEND),
  ATTR_TAB(MENU_BOXED),
  ATTR_TAB(MENU_CENTER),
  ATTR_TAB(MENU_CLIENT_DATA),
  ATTR_TAB(MENU_COLUMN_MAJOR),
  ATTR_TAB(MENU_DEFAULT),
  ATTR_TAB(MENU_DEFAULT_ITEM),
  ATTR_TAB(MENU_DEFAULT_IMAGE),
  ATTR_TAB(MENU_DISABLE_ITEM),
  ATTR_TAB(MENU_DEFAULT_SELECTION),
  ATTR_TAB(MENU_DESCEND_FIRST),
  ATTR_TAB(MENU_FEEDBACK),
  ATTR_TAB(MENU_FIRST_EVENT),
  ATTR_TAB(MENU_FONT),
  ATTR_TAB(MENU_GEN_PULLRIGHT),
  ATTR_TAB(MENU_GEN_PULLRIGHT_IMAGE),
  ATTR_TAB(MENU_GEN_PULLRIGHT_ITEM),
  ATTR_TAB(MENU_GEN_PROC),
  ATTR_TAB(MENU_GEN_PROC_IMAGE),
  ATTR_TAB(MENU_GEN_PROC_ITEM),
  ATTR_TAB(MENU_HEIGHT),
  ATTR_TAB(MENU_IMAGE),
  ATTR_TAB(MENU_IMAGE_ITEM),
  ATTR_TAB(MENU_IMAGES),
  ATTR_TAB(MENU_INITIAL_SELECTION),
  ATTR_TAB(MENU_INITIAL_SELECTION_SELECTED),
  ATTR_TAB(MENU_INITIAL_SELECTION_EXPANDED),
  ATTR_TAB(MENU_INACTIVE),
  ATTR_TAB(MENU_INSERT),
  ATTR_TAB(MENU_INSERT_ITEM),
  ATTR_TAB(MENU_ITEM),
  ATTR_TAB(MENU_INVERT),
  ATTR_TAB(MENU_JUMP_AFTER_SELECTION),
  ATTR_TAB(MENU_JUMP_AFTER_NO_SELECTION),
  ATTR_TAB(MENU_LAST_EVENT),
  ATTR_TAB(MENU_LEFT_MARGIN),
  ATTR_TAB(MENU_LIKE),
  ATTR_TAB(MENU_MARGIN),
  ATTR_TAB(MENU_MENU),
  ATTR_TAB(MENU_NITEMS),
  ATTR_TAB(MENU_NOTIFY_PROC),
  ATTR_TAB(MENU_NTH_ITEM),
  ATTR_TAB(MENU_NCOLS),
  ATTR_TAB(MENU_NROWS),
  ATTR_TAB(MENU_PARENT),
  ATTR_TAB(MENU_PULLRIGHT),
  ATTR_TAB(MENU_PULLRIGHT_DELTA),
  ATTR_TAB(MENU_PULLRIGHT_IMAGE),
  ATTR_TAB(MENU_PULLRIGHT_ITEM),
  ATTR_TAB(MENU_RELEASE),
  ATTR_TAB(MENU_RELEASE_IMAGE),
  ATTR_TAB(MENU_REMOVE),
  ATTR_TAB(MENU_REMOVE_ITEM),
  ATTR_TAB(MENU_REPLACE),
  ATTR_TAB(MENU_REPLACE_ITEM),
  ATTR_TAB(MENU_RIGHT_MARGIN),
  ATTR_TAB(MENU_SELECTED),
  ATTR_TAB(MENU_SELECTED_ITEM),
  ATTR_TAB(MENU_SHADOW),
  ATTR_TAB(MENU_STAY_UP),
  ATTR_TAB(MENU_STRING),
  ATTR_TAB(MENU_STRING_ITEM),
  ATTR_TAB(MENU_STRINGS),
  ATTR_TAB(MENU_TITLE_ITEM),
  ATTR_TAB(MENU_TITLE_IMAGE),
  ATTR_TAB(MENU_TYPE),
  ATTR_TAB(MENU_VALID_RESULT),
  ATTR_TAB(MENU_VALUE),
  ATTR_TAB(MENU_WIDTH),
  ATTR_TAB(MENU_NOP),
  ATTR_TAB(MENU_BUTTON),
  ATTR_TAB(MENU_FD),
  ATTR_TAB(MENU_IE),
  ATTR_TAB(MENU_POS),
  NULL, NULL
};


struct attrStruct iconAttrs[] = {
  ATTR_TAB(ICON_X),
  ATTR_TAB(ICON_Y),
  ATTR_TAB(ICON_WIDTH),
  ATTR_TAB(ICON_HEIGHT),
  ATTR_TAB(ICON_IMAGE_RECT),
  ATTR_TAB(ICON_LABEL_RECT),
  ATTR_TAB(ICON_IMAGE),
  ATTR_TAB(ICON_LABEL),
  ATTR_TAB(ICON_FONT),
  NULL, NULL
};


main()
{
  FILE *f;

  f = fopen("win.st", "w");

  emitDictDef(f, "PanelAttrs",	panelAttrs);
  emitDictDef(f, "FrameAttrs",	frameAttrs);
  emitDictDef(f, "CanvasAttrs", canvasAttrs);
  emitDictDef(f, "WindowAttrs", winAttrs);
  emitDictDef(f, "TextswAttrs", textswAttrs);
  emitDictDef(f, "MenuAttrs",	menuAttrs);
  emitDictDef(f, "IconAttrs",	iconAttrs);

  fclose(f);
}

emitDictDef(f, dictName, attrs)
FILE	*f;
char	*dictName;
struct attrStruct attrs[];
{
  struct attrStruct *asp;

  fprintf(f, "Smalltalk at: #%s put: Dictionary new!\n\n", dictName);

  fprintf(f, "%s findDefsFor: #(\n", dictName);
  for (asp = attrs; asp->name; asp++) {
    emitNameDef(f, dictName, asp);
  }

  fprintf(f, ")\n!\n\n");
}


emitNameDef(f, dictName, asp)
FILE	*f;
char	*dictName;
struct attrStruct *asp;
{
  char		buf[50];

  canonAttrName(asp->name, buf);
  
/*  fprintf(f, "%-15s at: #%-30s put: 16r%08X!\n", dictName, buf, asp->value); */
  fprintf(f, "    (%-30s '%s')\n", buf, asp->name);
}


canonAttrName(attrName, buf)
char	*attrName, *buf;
{
  char		*sp, *dp;
  int		upper;

  upper = 0;

  for (sp = attrName, dp = buf; *sp; sp++) {
    if (*sp == '_') {
      upper = 1;
      continue;
    }

    if (upper) {
      *dp++ = *sp;
      upper = 0;
    } else {
      if (isupper(*sp)) {
	*dp++ = tolower(*sp);
      } else {
	*dp++ = *sp;
      }
    }
    
  }

  *dp = '\0';
}
