/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "globals.h"
#include "regs.h"

/* breakpoint structure */
struct br {
	unsigned int addr;
	unsigned int instr;
	int activeflag;
} brtable[NUMBREAK];
int num_breaks;

/* for data breakpoints */
struct br dbrtable[NUMDBREAK];
int num_dbreaks;

extern unsigned int control_table[16];
/****************************************/
/* Set Instruction Breakpoint 		*/
/*    for Cx, use sysctl 		*/
/****************************************/
void set_breakpoint(addr1, addr2, mode)
unsigned int addr1;
unsigned int addr2;
int mode;
{
	addr1 = addr1 | 0x3;
	addr2 = addr2 | 0x3;

	if ((mode == ONE) || (mode == NONE)) { /* disable 2nd address */
		addr2 = 0;
		if (mode == NONE) {  /* also disable 1st address */
			addr1 = 0;
		}
	}
	control_table[0] = addr1 ;
	control_table[1] = addr2 ;
	send_sysctl(0x400, 0, 0);   /* force CA to reload breakpoints */
}

/****************************************/
/* Initialize Breakpoints 		*/
/****************************************/
init_breakpoints()
{
int i;
	/* initialize data breakpoint table */
	for (i=0; i<NUMDBREAK; i++) {
		dbrtable[i].addr = 0;
		dbrtable[i].instr = 0;
		dbrtable[i].activeflag = FALSE;
	}
	num_dbreaks = 0;

	/* initialize instruction breakpoint table */
	for (i=0; i<NUMBREAK; i++) {
		brtable[i].addr = 0;
		brtable[i].instr = 0;
		brtable[i].activeflag = FALSE;
	}
	num_breaks = 0;
}
/************************************************/
/* Set data breakpoints 			*/
/*                           			*/
/************************************************/
databreak()
{
int i,q;
int *addr1;
int addr2;
int found, reg;

	addr1 = (int *)get_word(q, &reg, TWO, FALSE);
	if (errno == TRUE) {
		/* no options given, display current breakpoints */
		display_dbreak();
		return;
	}
	for (i=0; i<NUMDBREAK; i++) 
		if ((dbrtable[i].addr == (int)addr1) && 
		    (dbrtable[i].activeflag)) {
			print("\r\n Data breakpoint has already been set at this location");
			return;
		}
	if (num_dbreaks == NUMDBREAK) {
		print("\n\r No data breakpoints left");
		return;
	}
	found = FALSE;
	for (i=0; i<NUMDBREAK; i++) {
		if ((! dbrtable[i].activeflag) && (!found)) {
			register_set[REG_TC] = register_set[REG_TC] | 0x80;
			dbrtable[i].addr = (int)addr1;
			dbrtable[i].instr = *addr1;
			dbrtable[i].activeflag = TRUE;
			found = TRUE;
			num_dbreaks++;
		}
		else
			addr2 = brtable[i].addr;
	}
	if (num_dbreaks == 1)
		set_dbreakpoint (addr1, 0x0, ONE);
	else
		set_dbreakpoint (addr1, addr2, BOTH);
}

/*************************************************/
/* Set Data Breakpoints              	 	 */
/*                           			 */
/*************************************************/
set_dbreakpoint(addr1, addr2, mode)
unsigned int addr1;
unsigned int addr2;
int mode;
{
	control_table[25] |= 0x00ff0000;
	if ((mode == ONE) || (mode == NONE)) { /* disable 2nd address */
		control_table[25] &= 0xffcfffff;

		if (mode == NONE) {  /* also disable 1st address */
			control_table[25] &= 0xfffcffff;
		}
	}
	control_table[2] = addr1;
	control_table[3] = addr2;
	send_sysctl(0x400, 0, 0);   /* force CA to reload breakpoints */
}

/*************************************************/
/* Display Data Breakpoints              	 */
/*                           			 */
/*************************************************/
display_dbreak()
{
int i;
	print ("\n\r Data breakpoints at :");
	for (i=0; i<NUMDBREAK; i++) {
		if (dbrtable[i].activeflag) {
			print ("\n\r");
			out_hex(dbrtable[i].addr, INT, TRUE);
		}
	}
}

/************************************************/
/* Delete a Data Breakpoint           	 	*/
/*                           			*/
/************************************************/
delete_data()
{
int i, q;
int *addr1;
int addr2;
int found1, found2, reg;

	addr1 = (int *)get_word(q, &reg, TWO, FALSE);
	if (errno == TRUE) {
		print ("\n\r No breakpoint removed");
		return;
	}
	found1 = found2 = FALSE;
	for (i=0; i<NUMDBREAK; i++) {
		if ((dbrtable[i].addr == (int)addr1) && (!found1)) {
			if (! dbrtable[i].activeflag) {
				print("\r\n Breakpoint already inactive");
				return;
			}
			dbrtable[i].activeflag = FALSE;
			found1 = TRUE;
			num_dbreaks--;
			if (num_dbreaks == 0) { /* disable breakpts */
				set_dbreakpoint(0x0, 0x0, NONE);
				display_dbreak();
				return;
			}
		}
		else if ((dbrtable[i].activeflag) && (!found2)) {
			addr2 = dbrtable[i].addr;
			found2 = TRUE;
		}
		else if ((dbrtable[i].activeflag) && (!found1)) 
			addr1 = (int *)dbrtable[i].addr;
	}
	if (!found1) {
		print ("\r\n Invalid breakpoint");
		display_dbreak();
		return;
	}
	if (num_dbreaks == 1) {
		set_dbreakpoint(addr2, 0x0, ONE);
		display_dbreak();
	}
	else {
		set_dbreakpoint(addr1, addr2, BOTH);
		display_dbreak();
	}
}

/************************************************/
/* Display Breakpoints              	 	*/
/*                           			*/
/************************************************/
display_break()
{
int i;
	print ("\n\r Instruction breakpoints at :");
	for (i=0; i<NUMBREAK; i++) {
		if (brtable[i].activeflag) {
			print ("\n\r");
			out_hex(brtable[i].addr, INT, TRUE);
		}
	}
}

/************************************************/
/* Set a Breakpoint              	 	*/
/*                           			*/
/************************************************/
breakpt()
{
int i,q;
int *addr1;
int addr2;
int found, reg;

	addr1 = (int *)get_word(q, &reg, TWO, FALSE);
	if (errno == TRUE) {
		/* no options given, display current breakpoints */
		display_break();
		return;
	}
	for (i=0; i<NUMBREAK; i++) 
		if ((brtable[i].addr == (int)addr1) && 
		    (brtable[i].activeflag)) {
			print("\r\n Breakpoint has already been set at this location");
			return;
		}
	if (num_breaks == NUMBREAK) {
		print("\n\r No breakpoints left");
		return;
	}
	found = FALSE;
	for (i=0; i<NUMBREAK; i++) {
		if ((! brtable[i].activeflag) && (!found)) {
			register_set[REG_TC] = register_set[REG_TC] | 0x80;
			brtable[i].addr = (int)addr1;
			brtable[i].instr = *addr1;
			brtable[i].activeflag = TRUE;
			found = TRUE;
			num_breaks++;
		}
		else
			addr2 = brtable[i].addr;
	}
	if (num_breaks == 1)
		set_breakpoint (addr1, 0x0, ONE);
	else
		set_breakpoint (addr1, addr2, BOTH);
}

/************************************************/
/* Delete a Breakpoint              	 	*/
/*                           			*/
/************************************************/
delete()
{
int i, q;
int *addr1;
int addr2;
int found1, found2, reg;

	addr1 = (int *)get_word(q, &reg, TWO, FALSE);
	if (errno == TRUE) {
		print ("\n\r No breakpoint removed");
		return;
	}
	found1 = found2 = FALSE;
	for (i=0; i<NUMBREAK; i++) {
		if ((brtable[i].addr == (int)addr1) && (!found1)) {
			if (! brtable[i].activeflag) {
				print("\r\n Breakpoint already inactive");
				return;
			}
			brtable[i].activeflag = FALSE;
			found1 = TRUE;
			num_breaks--;
			if (num_breaks == 0) { /* disable breakpts */
				set_breakpoint(0x0, 0x0, NONE);
				register_set[REG_TC] &= 0xffffff7f;
				display_break();
				return;
			}
		}
		else if ((brtable[i].activeflag) && (!found2)) {
			addr2 = brtable[i].addr;
			found2 = TRUE;
		}
		else if ((brtable[i].activeflag) && (!found1)) 
			addr1 = (int *)brtable[i].addr;
	}
	if (!found1) {
		print ("\r\n Invalid breakpoint");
		display_break();
		return;
	}
	if (num_breaks == 1) {
		set_breakpoint(addr2, 0x0, ONE);
		display_break();
	}
	else {
		set_breakpoint(addr1, addr2, BOTH);
		display_break();
	}
}
