/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "iac.h"
#include "defines.h"
#include "globals.h"
#include "regs.h"

/* breakpoint structure */
struct br {
	unsigned int addr;
	unsigned int instr;
	int activeflag;
} brtable[NUMBREAK];
int num_breaks;

/****************************************/
/* Set Instruction Breakpoint 		*/
/*    for Kx, use IAC 			*/
/****************************************/
void set_breakpoint(addr1, addr2, mode)
unsigned int addr1;
unsigned int addr2;
int mode;
{
iac_struct iac;
	
	if ((mode == ONE) || (mode == NONE)) { /* disable 2nd address */
		addr2 = addr2 | 0x02;
		if (mode == NONE) {  /* also disable 1st address */
			addr1 = addr1 | 0x02;
		}
	}
	iac.message_type = 0x8f;
	iac.field3 = addr1;
	iac.field4 = addr2;
	send_iac((int)&iac);
}

/****************************************/
/* Initialize Breakpoints 		*/
/****************************************/
init_breakpoints()
{
int i;
	/* initialize instruction breakpoint table */
	for (i=0; i<NUMBREAK; i++) {
		brtable[i].addr = 0;
		brtable[i].instr = 0;
		brtable[i].activeflag = FALSE;
	}
	num_breaks = 0;
}

/************************************************/
/* Set data breakpoints 			*/
/*                           			*/
/************************************************/
databreak()
{
	print ("\n\r Not implemented on the Kx architecture");
}

/************************************************/
/* Delete a Data Breakpoint           	 	*/
/*                           			*/
/************************************************/
delete_data()
{
	print ("\n\r Not implemented on the Kx architecture");
}

/************************************************/
/* Display Breakpoints              	 	*/
/*                           			*/
/************************************************/
display_break()
{
int i;
	print ("\n\r Instruction breakpoints at :");
	for (i=0; i<NUMBREAK; i++) {
		if (brtable[i].activeflag) {
			print ("\n\r");
			out_hex(brtable[i].addr, INT, TRUE);
		}
	}
}

/************************************************/
/* Set a Breakpoint              	 	*/
/*                           			*/
/************************************************/
breakpt()
{
int i,q;
int *addr1;
int addr2;
int found, reg;

	addr1 = (int *)get_word(q, &reg, TWO, FALSE);
	if (errno == TRUE) {
		/* no options given, display current breakpoints */
		display_break();
		return;
	}
	for (i=0; i<NUMBREAK; i++) 
		if ((brtable[i].addr == (int)addr1) && 
		    (brtable[i].activeflag)) {
			print("\r\n Breakpoint has already been set at this location");
			return;
		}
	if (num_breaks == NUMBREAK) {
		print("\n\r No breakpoints left");
		return;
	}
	found = FALSE;
	for (i=0; i<NUMBREAK; i++) {
		if ((! brtable[i].activeflag) && (!found)) {
			register_set[REG_TC] = register_set[REG_TC] | 0x80;
			brtable[i].addr = (int)addr1;
			brtable[i].instr = *addr1;
			brtable[i].activeflag = TRUE;
			found = TRUE;
			num_breaks++;
		}
		else
			addr2 = brtable[i].addr;
	}
	if (num_breaks == 1)
		set_breakpoint (addr1, 0x0, ONE);
	else
		set_breakpoint (addr1, addr2, BOTH);
}

/************************************************/
/* Delete a Breakpoint              	 	*/
/*                           			*/
/************************************************/
delete()
{
int i, q;
int *addr1;
int addr2;
int found1, found2, reg;

	addr1 = (int *)get_word(q, &reg, TWO, FALSE);
	if (errno == TRUE) {
		print ("\n\r No breakpoint removed");
		return;
	}
	found1 = found2 = FALSE;
	for (i=0; i<NUMBREAK; i++) {
		if ((brtable[i].addr == (int)addr1) && (!found1)) {
			if (! brtable[i].activeflag) {
				print("\r\n Breakpoint already inactive");
				return;
			}
			brtable[i].activeflag = FALSE;
			found1 = TRUE;
			num_breaks--;
			if (num_breaks == 0) { /* disable breakpts */
				set_breakpoint(0x0, 0x0, NONE);
				register_set[REG_TC] &= 0xffffff7f;
				display_break();
				return;
			}
		}
		else if ((brtable[i].activeflag) && (!found2)) {
			addr2 = brtable[i].addr;
			found2 = TRUE;
		}
		else if ((brtable[i].activeflag) && (!found1)) 
			addr1 = (int *)brtable[i].addr;
	}
	if (!found1) {
		print ("\r\n Invalid breakpoint");
		display_break();
		return;
	}
	if (num_breaks == 1) {
		set_breakpoint(addr2, 0x0, ONE);
		display_break();
	}
	else {
		set_breakpoint(addr1, addr2, BOTH);
		display_break();
	}
}
