/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "globals.h"
#include "lookup.h"
#include "regs.h"

/************************************************/
/* Disassemble A Word in Memory        		*/
/*                           			*/
/************************************************/
dasm()
{
unsigned int *addr;
int cycles;
int i, reg;

	cycles = 1;
	reg = 0;
	addr = (unsigned int *)get_word(&cycles, &reg, TWO, FALSE);
	if (errno == TRUE) {
		if (!reg)
			addr = (unsigned int *)register_set[REG_IP];
	}
	ip = addr;
	for (i=0; i<cycles; i++) {
		print("\n\r");
		out_hex(ip, INT, TRUE);
		print(" : ");
		out_hex(*ip, INT, TRUE);
		dis();
		ip++;
	}
}

/****************************************/
/* Disassemble Instructions		*/
/****************************************/
dis()
{
unsigned int instruction; 	/* 32 bit machine instruction */
unsigned int opcode; 	

	instruction = *ip;
	opcode = instruction >> 24;

	/* check for valid opcode */
	if (instr[opcode].opcode != 0) {
		if (opcode < 0x20) {
			print ("           ");
			ctrl(instruction, opcode);
		}
		else if (opcode < 0x40) {
			print ("           ");
			cobr(instruction, opcode);
		}
		else if (opcode > 0xCA) {
			print ("           ");
			invalid(instruction);
		}
		else if (opcode >= 0x80) {
			mem(instruction, opcode);
		}
		else {
			print ("           ");
			reg(instruction, opcode);
		}
	}

	/* still may be valid opcode, but of REG format */
	else {
		/* valid REG opcode */
		if (strcmp(instr[opcode].name, "")) {
			print ("           ");
			reg(instruction, opcode);
		}
	
		/* invalid instruction, print as data word */ 
		else {
			print ("           ");
			invalid (instruction);
		}
	}
}

/****************************************/
/* CTRL format				*/
/****************************************/
ctrl(instruction, op)
unsigned int instruction;
int op;
{
int displace, check;

	check = instruction & 0x3;
	if (check != 0) {
		invalid (instruction);
		return;
	}
	if (instr[op].opcode != op) {
		invalid (instruction);
		return;
	}
	print (instr[op].name);
	print ("  ");
	if ((op < 0x18) && (strcmp(instr[op].name, "ret"))) {
		displace = (int)(instruction & 0xffffff);
		if (displace & 0x800000) { /* sign bit is set */
			/* sign extend displacement */
			displace = (-1 & ~0x00ffffff) | displace;
		}
		displace += (int)ip;
		print ("0x");
		out_hex (displace, INT, TRUE);
	}
}

/****************************************/
/* COBR format				*/
/****************************************/
cobr(instruction, op)
unsigned int instruction;
int op;
{
int displace, dst, mode, src, check;
char *reg1, *reg2;

	check = instruction & 0x3;
	if (check != 0) {
		invalid (instruction);
		return;
	}
	if (instr[op].opcode != op) {
		invalid (instruction);
		return;
	}
	print (instr[op].name);
	print ("  ");

	dst = (instruction >> 19) & 0x1f;
	mode = (instruction >> 13) & 0x01;
	reg1 = regs[dst];

	if (op >= 0x30) {
		if (mode == 0)  {
			print (reg1);
			print (",   ");
		}
		else {
			print ("0x");
			out_hex (dst, BYTE, FALSE);
			print (",  ");
		}
		src = (instruction >> 14) & 0x1f;
		reg2 = regs[src];
		print (reg2);
		print (",  ");

		displace = (int)(instruction & 0x1fff);
		if (displace & 0x1000) { /* negative displacement */
			/* sign extend displacement */
			displace = (-1 & ~0x1fff) | displace;
		}
		displace += (int)ip;
		print ("0x");
		out_hex (displace, INT, TRUE);
	}
	else {
		print (reg1);
	}
}

/****************************************/
/* MEM format				*/
/****************************************/
mem(instruction, op)
unsigned int instruction;
int op;
{
int format, src, abase; 
char *reg1, *reg2;

	format = (instruction >> 12) & 0x01;
	src = (instruction >> 19) & 0x1f;
	reg1 = regs[src];
	abase = (instruction >> 14) & 0x1f;
	reg2 = regs[abase];

	if (format == 0) {	/* MEMA format */
		mema(instruction, op, reg1, reg2);
	}
	else { 			/* MEMB format */
		memb(instruction, op, reg1, reg2);
	}
}

/****************************************/
/* REG format				*/
/****************************************/
reg(instruction, op)
unsigned int instruction;
int op;
{
int index, numops, mode1, mode2, mode3, fp;
int src, dst, src2, tmp, count, check, valid;
char *name, *reg1, *reg2, *reg3;

	check = (instruction >> 5) & 0x03;
	if (check != 0) {
		invalid (instruction);
		return;
	}

	if ((instr[op].opcode == 0x6d9) || ((instr[op].opcode < 0x5ff) 
	   && (instr[op].opcode > 0x5c0))) {
		index = op;
		op = (op << 4) + ((instruction >> 7) & 0x0f);
		if (instr[index].opcode != op) {
			invalid (instruction);
			return;
		}
		name = instr[index].name;
		numops = instr[index].numops;
	}
	else {
		index = (int)atoh(instr[op].name);
		op = (op << 4) + ((instruction >> 7) & 0x0f);
		count = 0;
		while (instr[index].opcode != op) {
			if (count++ > 15) {
				invalid (instruction);
				return;
			}
			index++;
		}
		name = instr[index].name;
		numops = instr[index].numops;
	}
	print (name);   
	print ("  ");
	mode1 = (instruction >> 11) & 0x01;
	mode2 = (instruction >> 12) & 0x01;
	mode3 = (instruction >> 13) & 0x01;
	src = instruction & 0x1f;
	src2 = (instruction >> 14) & 0x1f;
	dst = (instruction >> 19) & 0x1f;
	if ((op >= 0x78b) || ((op < 0x6e9) && (op >= 0x674))) 
		fp = TRUE;
	else
		fp = FALSE;

	switch (numops) {
		case 0:	break;
		case 1:	if (op == 0x673) {
				mode1 = mode3;
				src = dst;
			}
			oneop (mode1, src, fp,instruction);
			break;
		case 2:	if ( ((op >= 0x5a0) && (op <= 0x5ae)) ||
			     ((op >= 0x600) && (op <= 0x602)) ||
			      (op == 0x684) || (op == 0x685) ||
			      (op == 0x694) || (op == 0x695) ) {
					dst = src2;
					mode3 = mode2;
			}
			twoop (mode1, src, mode3, dst, fp,instruction);
			break;
		case 3:	threeop (mode1,src,mode2,src2,mode3,dst,fp,
				instruction);
			break;
		default: break;
	}
}

/************************************************/
/* Print out effective address			*/
/*                           			*/
/************************************************/
ea(mode, reg2, reg3, word2, scale)
int mode;
char *reg2, *reg3;
unsigned int word2;
int scale;
{
unsigned int instruction;
	instruction = *ip;
	switch (mode) {
		case 4:	 		/* (reg) */
			co ('(');
			print (reg2);
			co (')');
			break;
		case 5:			/* displ+8(ip) */
			word2 += 8;
			print ("0x");
			out_hex (word2, INT, FALSE);
			print ("(0x");
			out_hex (ip, INT, FALSE);
			co (')');
			break;
		case 7:			/* (reg)[index*scale] */
			if (scale == 1) {
				co ('(');
				print (reg2);
				print (")[");
				print (reg3);
				co (']');
			}
			else {
				co ('(');
				print (reg2);
				print (")[");
				print (reg3);
				co ('*');
				out_hex (scale, BYTE, FALSE);
				co (']');
			}
			break;
		case 12:		/* displacement */
			print ("0x");
			out_hex (word2, INT, TRUE);
			break;
		case 13:		/* displ(reg) */
			print ("0x");
			out_hex (word2, INT, TRUE);
			co ('(');
			print (reg2);
			co (')');
			break;
		case 14:		/* displ[index*scale] */
			if (scale == 1) {
				print ("0x");
				out_hex(word2, INT, FALSE);
				co ('[');
				print (reg3);
				co (']');
			}
			else {
				print ("0x");
				out_hex(word2, INT, FALSE);
				co ('[');
				print (reg3);
				co ('*');
				out_hex (scale, BYTE, FALSE);
				co (']');
			}
			break;
		case 15:		/* displ(reg)[index*scale] */
			if (scale == 1) {
				print ("0x");
				out_hex (word2, INT, FALSE);
				co ('(');
				print (reg2);
				print (")[");
				print (reg3);
				co (']');
			}
			else {
				print ("0x");
				out_hex (word2, INT, FALSE);
				co ('(');
				print (reg2);
				print (")[");
				print (reg3);
				co ('*');
				out_hex (scale, BYTE, FALSE);
				co (']');
			}
			break;
		default:
			invalid (instruction);
			return;
	}
}

/************************************************/
/* MEMA instruction type      			*/
/*                           			*/
/************************************************/
mema (instruction, op, reg1, reg2)
unsigned int instruction;
int op;
char *reg1, *reg2;
{
int mode, offset, type;

	print ("           ");
	if (instr[op].opcode != op) {
		invalid (instruction);
		return;
	}
	print (instr[op].name);
	print ("  ");
	mode = (instruction >> 13) & 0x01;
	offset = instruction & 0xfff;
	type = op & 0x0f;

	/* load type */
	if ((type == 0) || (type == 5) || (type == 8)
	   || (type == 12)) {
		if (mode == 0) {
			print ("0x");
			out_hex (offset, INT, FALSE);
		}
		else {
			print ("0x");
			out_hex (offset, INT, FALSE);
			co ('(');
			print (reg2);
			co (')');
		}
		print (",   ");
		print (reg1);
	}

	/* store type */
	else if ((type == 2) || (type == 10)) {
		print (reg1);
		print (",   ");
		if (mode == 0) {
			print ("0x");
			out_hex (offset, INT, FALSE);
		}
		else {
			print ("0x");
			out_hex (offset, INT, FALSE);
			co ('(');
			print (reg2);
			co (')');
		}
	}

	/* bx/callx type */
	else if ((type == 4) || (type == 6)) {
		if (mode == 0) {
			print ("0x");
			out_hex (offset, INT, FALSE);
		}
		else {
			print ("0x");
			out_hex (offset, INT, FALSE);
			co ('(');
			print (reg2);
			co (')');
		}
	}
}

/************************************************/
/* MEMB instruction type      			*/
/*                           			*/
/************************************************/
memb (instruction, op, reg1, reg2)
unsigned int instruction;
int op;
char *reg1, *reg2;
{
int scale, index, type, mode, check;
unsigned int word2;
char *reg3;
unsigned int *oldip;

	mode = (instruction >> 10) & 0x0f;
	scale = (instruction >> 7) & 0x07;
	check = (instruction >> 5) & 0x03;
	if ((scale > 4) || (check != 0)) {
		invalid (instruction);
		return;
	}
	if (instr[op].opcode != op) {
		print ("           ");
		invalid (instruction);
		return;
	}
	scale = scaler[scale];
	index = instruction & 0x1f;
	reg3 = regs[index];

	switch (mode) {
		case 4:	
			print ("           ");
			print (instr[op].name);
			print ("  ");
			break;
		case 5:
			oldip = ip;
			ip++;
			word2 = *ip;
			co (SP);
			out_hex (word2, INT, TRUE);
			print ("  ");
			print (instr[op].name);
			print ("  ");
			break;
		case 7:
			print ("           ");
			print (instr[op].name);
			print ("  ");
			break;
		case 12: /* same for cases 12-15 */
		case 13:
		case 14:
		case 15:
			oldip = ip;
			ip++;
			co (SP);
			word2 = *ip;
			out_hex (word2, INT, TRUE);
			print ("  ");
			print (instr[op].name);
			print ("  ");
			break;
		default:
			invalid (instruction);
			return;
	}
	type = op & 0x0f;

	/* load type */
	if ((type == 0) || (type == 5) || (type == 8)
	   || (type == 12)) {
		ea(mode,reg2, reg3, word2, scale, oldip);
		print (",   ");
		print (reg1);
	}

	/* store type */
	else if ((type == 2) || (type == 10)) {
		print (reg1);
		print (",   ");
		ea(mode,reg2, reg3, word2, scale, oldip);
	}

	/* bx/callx type */
	else if ((type == 4) || (type == 6)) {
		ea(mode,reg2, reg3, word2, scale, oldip);
	}
	
}

/************************************************/
/* One Operand Register Instruction 		*/
/*                           			*/
/************************************************/
oneop(mode1,src,fp,instruction)
int mode1, src, fp,instruction;
{
char *reg1, *freg; 

	if(mode1 == 0) {
		reg1 = regs[src];
		print (reg1);
	}
	else if (fp) {
		if (src == 16)
			src = 4;
		if (src == 22)
			src = 5;
		freg = fregs[src];
		print (freg);
	}
	else {
		out_hex (src, SHORT, FALSE);
	}
}

/************************************************/
/* Two Operand Register Instruction 		*/
/*                           			*/
/************************************************/
twoop(mode1,src,mode2,src2,fp,instruction)
int mode1, src, mode2, src2, fp,instruction;
{
char *reg1, *reg2, *freg;

	if (mode1 == 0) {
		reg1 = regs[src];
		print (reg1);
		print (",  ");
	}
	else if (fp) {
		if (src == 16)
			src = 4;
		if (src == 22)
			src = 5;
		freg = fregs[src];
		print (freg);
		print (",  ");
	}
	else {
		out_hex (src, SHORT, FALSE);
		print (",  ");
	}
	if (mode2 == 0) {
		reg2 = regs[src2];
		print (reg2);
	}
	else if (fp) {
		if (src2 == 16)
			src2 = 4;
		if (src2 == 22)
			src2 = 5;
		freg = fregs[src2];
		print (freg);
	}
	else {
		out_hex (src2, SHORT, FALSE);
	}
}

/************************************************/
/* Three Operand Register Instruction 		*/
/*                           			*/
/************************************************/
threeop(mode1,src,mode2,src2,mode3,dst,fp,instruction)
int mode1, src, mode2, src2, mode3, dst, fp,instruction;
{
char *reg1, *reg2, *reg3, *freg;

	if (mode1 == 0) {
		reg1 = regs[src];
		print (reg1);
		print (",  ");
	}
	else if (fp) {
		if (src == 16)
			src = 4;
		if (src == 22)
			src = 5;
		freg = fregs[src];
		print (freg);
		print (",  ");
	}
	else {
		out_hex (src, SHORT, FALSE);
		print (",  ");
	}
	if (mode2 == 0) {
		reg2 = regs[src2];
		print (reg2);
		print (",  ");
	}
	else if (fp) {
		if (src2 == 16)
			src2 = 4;
		if (src2 == 22)
			src2 = 5;
		freg = fregs[src2];
		print (freg);
		print (",  ");
	}
	else {
		out_hex (src2, SHORT, FALSE);
		print (",  ");
	}
	if (mode3 == 0) {
		reg3 = regs[dst];
		print (reg3);
	}
	else if (fp) {
		if (dst == 16)
			dst = 4;
		if (dst == 22)
			dst = 5;
		freg = fregs[dst];
		print (freg);
	}
	else {
		out_hex (dst, SHORT, FALSE);
	}
}

/************************************************/
/* Invalid operation                		*/
/*                           			*/
/************************************************/
invalid (instruction)
int instruction;
{
	print (".word     0x");
	out_hex (instruction, INT, TRUE);
}	
