/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "qtcommon.h"

/************************************************/
/* Reset Board                         		*/
/*                           			*/
/************************************************/
reset()
{
	store_byte (RESET_DATA, RESET_ADDR);
}

/****************************************/
/* Disable interrupts on board		*/
/* 		           	        */
/*  this routine makes sure all of the  */
/* chips on the board are initialized to*/
/* a known state.			*/
/****************************************/
disable_ints()
{
/* initialize the 380 to known states - SHUT UP! */

unsigned char dummy;
	
/* INIT_INTERRUPTS				*/

	/* do dummy read of mask register for banks  Not sure
	why this is necessary, but the 380 doesn't seem to work
	without it.
	*/
	dummy = load_byte(ICW1_B);
	dummy = load_byte(ICW2_B);
	dummy = load_byte(ICW1_A);
	dummy = load_byte(ICW2_A);

	/* neutralize all vectors to interrupt level 8 */
	store_byte (8, VR0);   /* interrupt vector 0 */
	store_byte (8, VR1);   /* interrupt vector 1 */
	store_byte (8, VR1_5); /* interrupt vector 1.5 */
	store_byte (8, VR3);   /* interrupt vector 3 */
	store_byte (8, VR4);   /* interrupt vector 4 */
	store_byte (8, VR7);   /* interrupt vector 7 */
		
	/* set up ICW for Master controller (82380) */
	store_byte (0x11, ICW1_A); /* edge triggered, external */
				   /* cascade, ICW4 needed */

	store_byte (0x20, ICW2_A );    	/* change ICW2 */
	store_byte (0x04, ICW2_A );    	/* change ICW3 */
	store_byte (0x12, ICW4_A );	/* change ICW4 */
	store_byte (0xff, OCW1_A); 	/* disable bank A */

/* program slave interrupt controller */
	store_byte (0x11, ICW1_A); /* level triggered */
				   /*  ICW4 needed */

	/* neutralize all vectors */
	store_byte (8, VR8);  /* interrupt vector 8 */
	store_byte (8, VR9);  /* interrupt vector 9 */
	store_byte (8, VR11); /* interrupt vector 11 */
	store_byte (8, VR12); /* interrupt vector 12 */
	store_byte (8, VR13); /* interrupt vector 13 */
	store_byte (8, VR14); /* interrupt vector 14 */
	store_byte (8, VR15); /* interrupt vector 15 */
		
	store_byte (0x20, ICW2_A );    	/* change ICW2 */
	store_byte (0x02, ICW2_A );    	/* change ICW3 */
	store_byte (0x12, ICW4_A );	/* change ICW4 */
	store_byte (0xff, OCW1_A); 	/* disable bank B */

	/* clear off 1.5 level interrupts */
	dummy = load_byte (ICW1_B);
	dummy = load_byte (ICWR_B);
	dummy = load_byte (ICW1_A);
	dummy = load_byte (ICWR_A);
	dummy = load_byte (ICWR_C);


/* INIT_TIMER */

	store_byte (0x30, CWR1); /* MSB,LSB,16-bit binary,timer 0 */
	store_byte (0x02, CR0);  /* LSB initial count */
	store_byte (0x00, CR0);  /* MSB initial count */
	store_byte (0x70, CWR1); /* MSB,LSB,16-bit binary,timer 1 */
	store_byte (0x02, CR1);  /* LSB initial count */
	store_byte (0x00, CR1);  /* MSB initial count */
	store_byte (0xb0, CWR1); /* MSB,LSB,16-bit binary,timer 2 */
	store_byte (0x02, CR2);  /* LSB initial count */
	store_byte (0x00, CR2);  /* MSB initial count */
	store_byte (0x30, CWR2); /* LSB,MSB,16-bit binary,timer 3 */
	store_byte (0x02, CR3);  /* LSB initial count */
	store_byte (0x00, CR3);  /* MSB initial count */
	
	store_byte(0x00, CNTL1);   /* disable GATE */

}

/************************************************/
/* Download to Flash         			*/
/*                           			*/
/************************************************/
down_flash(monitor_flag)
int monitor_flag;
{
int term, type;
	if (monitor_flag) {	 /* program already running */
		print ("\n\rAlready running program, new download not");
		print ("\n\rallowed. Reset board or allow program to");
		print ("\n\rcomplete to download new program.");
	}
	else {
		print ("\n\rFlash Programming Algorithm Copyright (c) 1988, Intel Corporation");
		print ("\n\r                All Rights Reserved \n\r");
		if (f_parse_init() == ERROR) {
			print ("\n\rdownload aborted");
			return (ERROR);
		}
		print ("\r\n      Receiving file");
		if (receive_xmodem(FLASH) == ERROR)
			print ("\n\rdownload failed");
		else
			parse_terminate();
	}
}

/************************************************/
/* Check if Flash is Blank   			*/
/*                           			*/
/************************************************/
check_flash(type)
int type;
{
unsigned int *addr, a, md1, md2;
unsigned int *first_addr, *last_addr, *next_addr;
unsigned int data1, data2, size;

	addr = (unsigned int *)FLASH_ADDR;
	if (type == ERROR)
		return (ERROR);
	else if (type == 256)
		size = FLASH_ADDR + 0x20000;
	else
		size = FLASH_ADDR + 0x100000;
	first_addr = last_addr = (unsigned int *)size;

	while (addr < (unsigned int *)size) {

		/* find first non_blank address */
		if (*addr != 0xffffffff) {
			first_addr = addr;
			break;
		}
		addr++;
	}
	if (first_addr != last_addr) {
		addr = (unsigned int *)(size - 4);
		while (addr > first_addr) {

			/* find last non_blank address */
			if (*addr != 0xffffffff) {
				last_addr = addr;
				break;
			}
			addr--;
		}
	}
	if (last_addr == first_addr) {	    /* Flash space is blank */
		print ("\n\rflash space is blank");
		return (TRUE);	
	}
	else {
		size = size - FLASH_ADDR;
		print ("\n\rflash is programmed between 0x");
		out_hex (first_addr, INT, TRUE);
		print (" and 0x");
		out_hex (last_addr, INT, TRUE);
		print ("\n\rsize is 0x");
		out_hex(size, INT, FALSE);
		return (FALSE);
	}
}

/************************************************/
/* Board Test 					*/
/*                           			*/
/************************************************/
board_test()
{
	return(sram_test_a());
}

