/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
/************************************************/
/*	LOOKUP TABLE FOR OPCODES		*/
/* This table is rather confusing at first 	*/
/* glance.  Given the embedded nature of NINDY, */
/* the table is designed to pack them in as 	*/
/* tight as possible in a somewhat logical 	*/
/* order.  The opcodes are inserted into the 	*/
/* table in their respective places where 	*/
/* possible.  All of the two digit opcodes are  */
/* just a straight lookup.  The three digit 	*/
/* opcodes often must be inserted elsewhere into*/
/* the table where there is room.  Their new	*/
/* location is pointed to by the first two 	*/
/* digit's straight lookup.  It then turns into */
/* somewhat of a hash table to find the correct */
/* opcode from there.  Believe it or not it all	*/
/* works out fine.  It just takes some time for	*/
/* the programmer to get it all sorted out.	*/
/************************************************/
struct table {
	int 	opcode;
	char	name[9];
	int	numops;
} instr[] = {
	0x00,	"",		0,	/* --------00-------- */
	0x670,	"emul",		3,
	0x671,	"ediv",		3,
	0x673, 	"ldtime",	1,
	0x674,	"cvtir",	2,
	0x675,	"cvtilr",	2,
	0x676,	"scalerl",	3,
	0x677,	"scaler",	3,
	0x08,	"b",		1,
	0x09,	"call",		1,
	0x0a,	"ret",		0,
	0x0b,	"bal",		1,
	0x741,	"muli",		3,
	0x748,	"remi",		3,
	0x749,	"modi",		3,
	0x74b,	"divi",		3,	/* ________0F________ */
	0x10,	"bno",		1,	/* --------10-------- */
	0x11,	"bg",		1,
	0x12,	"be",		1,
	0x13,	"bge",		1,
	0x14,	"bl",		1,
	0x15,	"bne",		1,
	0x16,	"ble",		1,
	0x17,	"bo",		1,
	0x18,	"faultno",	0,
	0x19,	"faultg",	0,
	0x1a,	"faulte",	0,
	0x1b,	"faultge",	0,
	0x1c,	"faultl",	0,
	0x1d,	"faultne",	0,
	0x1e,	"faultle",	0,
	0x1f,	"faulto",	0,	/* ________1F________ */
	0x20,	"testno",	1,	/* --------20-------- */
	0x21,	"testg",	1,
	0x22,	"teste",	1,
	0x23,	"testge",	1,
	0x24,	"testl",	1,
	0x25,	"testne",	1,
	0x26,	"testle",	1,
	0x27,	"testo",	1,
	0x640,	"spanbit",	2,
	0x641,	"scanbit",	2,
	0x642,	"daddc",	3,
	0x643,	"dsubc",	3,
	0x644,	"dmovt",	2,
	0x645,	"modac",	3,
	0x646,	"condrec",	2,
	0x00,	"",		0,	/* ________2F________ */
	0x30,	"bbc",		3,	/* --------30-------- */
	0x31,	"cmpobg",	3,
	0x32,	"cmpobe",	3,
	0x33,	"cmpobge",	3,
	0x34,	"cmpobl",	3,
	0x35,	"cmpobne",	3,
	0x36,	"cmpoble",	3,
	0x37,	"bbs",		3,
	0x38,	"cmpibno",	3,
	0x39,	"cmpibg",	3,
	0x3a,	"cmpibe",	3,
	0x3b,	"cmpibge",	3,
	0x3c,	"cmpibl",	3,
	0x3d,	"cmpibne",	3,
	0x3e,	"cmpible",	3,
	0x3f,	"cmpibo",	3,	/* ________3F________ */
	0x690,	"atanrl",	3,	/* --------40-------- */
	0x691,	"logeprl",	3,
	0x692,	"logrl",	3,
	0x693,	"remrl",	3,
	0x694,	"cmporl",	2,
	0x695,	"cmprl",	2,
	0x00,	"",		0,
	0x00,	"",		0,
	0x698,	"sqrtrl",	2,
	0x699,	"exprl",	2,
	0x69a,	"logbnrl",	2,
	0x69b,	"roundrl",	2,
	0x69c,	"sinrl",	2,
	0x69d,	"cosrl",	2,
	0x69e,	"tanrl",	2,
	0x69f,	"classrl",	1,	/* ________4F________ */
	0x610,	"atmod",	3,	/* --------50-------- */
	0x612,	"atadd",	3,
	0x613,	"inspacc",	2,
	0x614,	"ldphy",	2,
	0x615,	"synld",	2,
	0x617,	"fill",		3,
	0x00,	"",		0,
	0x00,	"",		0,
	0x00,	"d0",		0,
	0x00,	"b3",		0,
	0x00,	"a3",		0,
	0x00,	"bd",		0,
	0x5cc,	"mov",		2,
	0x5dc,	"movl",		2,
	0x5ec,	"movt",		2,
	0x5fc,	"movq",		2,	/* ________5F________ */
	0x00,	"7a",		0,	/* --------60-------- */
	0x00,	"50",		0,
	0x00,	"",		0,
	0x00,	"71",		0,
	0x00,	"28",		0,
	0x00,	"9b",		0,
	0x00,	"f0",		0,
	0x00,	"01",		0,
	0x00,	"e0",		0,
	0x00,	"40",		0,
	0x00,	"",		0,
	0x00,	"",		0,
	0x00,	"c3",		0,
	0x6d9,	"movrl",	2,
	0x00,	"ad",		0,
	0x00,	"",		0,	/* ________6F________ */
	0x00,	"8d",		0,	/* --------70-------- */
	0x630,	"sdma",		3,
	0x631,	"udma",		0,
	0x638,	"sysctl",	3,
	0x00,	"0c",		0,
	0x00,	"",		0,
	0x00,	"",		0,
	0x00,	"",		0,
	0x00, 	"93",		0,
	0x00,	"cb",		0,
	0x600,	"synmov",	2,
	0x601,	"synmovl",	2,
	0x602,	"synmovq",	2,
	0x603,	"cmpstr",	3,
	0x604,	"movqstr",	3,
	0x605,	"movstr",	3,	/* ________7F________ */
	0x80,	"ldob",		2,	/* --------80-------- */
	0x00,	"",		0,
	0x82,	"stob",		2,
	0x00,	"",		0,
	0x84,	"bx",		1,
	0x85,	"balx",		2,
	0x86,	"callx",	1,
	0x00,	"",		0,
	0x88,	"ldos",		2,
	0x00,	"",		0,
	0x8a,	"stos",		2,
	0x00,	"",		0,
	0x8c,	"lda",		2,
	0x701,	"mulo",		3,
	0x708,	"remo",		3,
	0x70b,	"divo",		3,	/* ________8F________ */
	0x90,	"ld",		2,	/* --------90-------- */
	0x00,	"",		0,
	0x92,	"st",		2,
	0x78b,	"divr",		3,
	0x78c,	"mulr",		3,
	0x78d,	"subr",		3,
	0x78f,	"addr",		3,
	0x00,	"",		0,
	0x98,	"ldl",		2,
	0x00,	"",		0,
	0x9a,	"stl",		2,
	0x650,	"modify",	3,
	0x651,	"extract",	3,
	0x654,	"modtc",	3,
	0x655,	"modpc",	3,
	0x656,	"receive",	2,	/* ________9F________ */
	0xa0,	"ldt",		2,	/* --------A0-------- */
	0x00,	"",		0,
	0xa2,	"stt",		2,
	0x5a0, 	"cmpo",		2,
	0x5a1, 	"cmpi",		2,
	0x5a2, 	"concmpo",	2,
	0x5a3, 	"concmpi",	2,
	0x5a4, 	"cmpinco",	3,
	0x5a5, 	"cmpinci",	3,
	0x5a6, 	"cmpdeco",	3,
	0x5a7, 	"cmpdeci",	3,
	0x5ac, 	"scanbyte",	2,
	0x5ae, 	"chkbit",	2,
	0x6e2, 	"cpysre",	3,
	0x6e3, 	"cpyrsre",	3,
	0x6e1, 	"movre",	2,	/* ________AF________ */
	0xb0,	"ldq",		2,	/* --------B0-------- */
	0x00,	"",		0,
	0xb2,	"stq",		2,
	0x590, 	"addo",		3,
	0x591, 	"addi",		3,
	0x592, 	"subo",		3,
	0x593, 	"subi",		3,
	0x598, 	"shro",		3,
	0x59a, 	"shrdi",	3,
	0x59b, 	"shri",		3,
	0x59c, 	"shlo",		3,
	0x59d, 	"rotate",	3,
	0x59e, 	"shli",		3,
	0x5b0, 	"addc",		3,
	0x5b2, 	"subc",		3,
	0x00, 	"",		0,	/* ________BF________ */
	0xc0,	"ldib",		2,	/* --------C0-------- */
	0x00,	"",		0,
	0xc2,	"stib",		2,
	0x6c0,	"cvtri",	2,
	0x6c1,	"cvtril",	2,
	0x6c2,	"cvtzri",	2,
	0x6c3,	"cvtzril",	2,
	0x6c9,	"movr",		2,
	0xc8,	"ldis",		2,
	0x00,	"",		0,
	0xca,	"stis",		2,
	0x79b,	"divrl",	3,
	0x79c,	"mulrl",	3,
	0x79d,	"subrl",	3,
	0x00,	"",		0,
	0x79f,	"addrl",	3,	/* ________CF________ */
	0x580,	"notbit",	3,	/* --------D0-------- */
	0x581,	"and",		3,
	0x582,	"andnot",	3,
	0x583,	"setbit",	3,
	0x584,	"notand",	3,
	0x00,	"",		0,
	0x586,	"xor",		3,
	0x587,	"or",		3,
	0x588,	"nor",		3,
	0x589,	"xnor",		3,
	0x58a,	"not",		2,
	0x58b,	"ornot",	3,
	0x58c,	"clrbit",	3,
	0x58d,	"notor",	3,
	0x58e,	"nand",		3,
	0x58f,	"alterbit",	3,	/* ________DF________ */
	0x680,	"atanr",	3,	/* --------E0-------- */
	0x681,	"logepr",	3,
	0x682,	"logr",		3,
	0x683,	"remr",		3,
	0x684,	"cmpor",	2,
	0x685,	"cmpr",		2,
	0x00,	"",		0,
	0x00,	"",		0,
	0x688,	"sqrtr",	2,
	0x689,	"expr",		2,
	0x68a,	"logbnr",	2,
	0x68b,	"roundr",	2,
	0x68c,	"sinr",		2,
	0x68d,	"cosr",		2,
	0x68e,	"tanr",		2,
	0x68f,	"classr",	1,	/* ________EF________ */
	0x660,	"calls",	1,	/* --------F0-------- */
	0x00,	"",		0,
	0x662,	"send",		3,
	0x663,	"sendserv",	1,
	0x664,	"resumprcs",	1,
	0x665,	"schedprcs",	1,
	0x666,	"saveprcs",	0,
	0x00,	"",		0,
	0x668,	"condwait",	1,
	0x669,	"wait",		1,
	0x66a,	"signal",	1,
	0x66b,	"mark",		0,
	0x66c,	"fmark",	0,
	0x66d,	"flushreg",	0,
	0x00,	"",		0,
	0x66f,	"syncf",	0,	/* ________FF________ */
};

static char *regs[] = { "pfp", "sp", "rip", "r3", "r4", "r5",
"r6", "r7", "r8", "r9", "r10", "r11", "r12", "r13", "r14",
"r15", "g0", "g1", "g2", "g3", "g4", "g5", "g6", "g7", "g8",
"g9", "g10", "g11", "g12", "g13", "g14", "fp" };

static int scaler[] = {1, 2, 4, 8, 16};

static char *fregs[] = { "fp0", "fp1", "fp2", "fp3", "0.0", "1.0" };
