#ifndef _CTYPE_H
#define _CTYPE_H
/*  ctype.h : character classification for GNU cc.
 *
 *  04-Oct-89 Modified to use GNU inline facility. If -traditional is on 
 *            (e.g., __STDC__ is undefined, define as macros instead.
 *            To instantiate copies of the routines that
 *            people who don't include headers can call, set the
 *            __INSTANTIATE_CTYPE__ flag. [atw]
 */

extern	char	_ctype_[];
#define	_U	0001
#define	_L	0002
#define	_N	0004
#define	_S	0010
#define _P	0020
#define _C	0040
#define _X	0100
#define _SP	0200

#ifdef __STDC__
#ifdef __INSTANTIATE_CTYPE__
#define STATIC
#define INLINE
#else
#define STATIC static
#define INLINE __inline__
#endif
STATIC INLINE const isalpha(int c) {	return ((_ctype_+1)[c]&(_U|_L));       	};
STATIC INLINE const isupper(int c) {	return ((_ctype_+1)[c]&_U);		};
STATIC INLINE const islower(int c) {	return ((_ctype_+1)[c]&_L);		};
STATIC INLINE const isdigit(int c) {	return ((_ctype_+1)[c]&_N);		};
STATIC INLINE const isxdigit(int c) {	return ((_ctype_+1)[c]&(_N|_X));       	};
STATIC INLINE const isspace(int c) {	return ((_ctype_+1)[c]&_S);		};
STATIC INLINE const ispunct(int c) {	return ((_ctype_+1)[c]&_P);		};
STATIC INLINE const isalnum(int c) {	return ((_ctype_+1)[c]&(_U|_L|_N));	};
STATIC INLINE const isprint(int c) {	return ((_ctype_+1)[c]&(_SP|_P|_U|_L|_N));};
STATIC INLINE const isgraph(int c) {	return ((_ctype_+1)[c]&(_P|_U|_L|_N));	};
STATIC INLINE const iscntrl(int c) {	return ((_ctype_+1)[c]&_C);		};
STATIC INLINE const isascii(int c) {	return ((unsigned)(c)<=0177);		};

STATIC INLINE const __toupper(int c) {	return ((c) - 'a' + 'A');			};
STATIC INLINE const __tolower(int c) {	return ((c) - 'A' + 'a');			};
STATIC INLINE const   toascii(int c) {	return ((c) & 0177); 				};
STATIC INLINE const   toupper(int c) {  return( islower(c) ? __toupper(c) : c );	};
STATIC INLINE const   tolower(int c) {  return( isupper(c) ? __tolower(c) : c );	};
#undef STATIC
#undef INLINE
#else
/*
 * not __STDC__ ... no inlining ... use macros instead.
 */
#define	isalpha(c)	((_ctype_+1)[c]&(_U|_L))
#define	isupper(c)	((_ctype_+1)[c]&_U)
#define	islower(c)	((_ctype_+1)[c]&_L)
#define	isdigit(c)	((_ctype_+1)[c]&_N)
#define	isxdigit(c)	((_ctype_+1)[c]&(_N|_X))
#define	isspace(c)	((_ctype_+1)[c]&_S)
#define ispunct(c)	((_ctype_+1)[c]&_P)
#define isalnum(c)	((_ctype_+1)[c]&(_U|_L|_N))
#define isprint(c)	((_ctype_+1)[c]&(_SP|_P|_U|_L|_N))
#define isgraph(c)	((_ctype_+1)[c]&(_P|_U|_L|_N))
#define iscntrl(c)	((_ctype_+1)[c]&_C)
#define isascii(c)	((unsigned)(c)<=0177)

#define __toupper(c)	((c) - 'a' + 'A')
#define __tolower(c)	((c) - 'A' + 'a')
#define   toascii(c)	((c) & 0177)
#define   toupper(c)	(islower(c) ? __toupper(c) : c )
#define   tolower(c)	(isupper(c) ? __tolower(c) : c )

#endif /* __STDC__ */
#endif /* _CTYPE_H */
